package com.ejianc.business.project.service.impl;

import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.bean.StartWorkReportEntity;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.service.IStartWorkReportService;
import com.ejianc.business.project.bean.FourLibFollowEntity;
import com.ejianc.business.project.service.IFourLibFollowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("fourLibFollow") 
public class FourLibFollowBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IProjectSetService projectSetService;
	@Autowired
	private ICompletionWorkReportService completionWorkReportService;
	@Autowired
	private IFourLibFollowService fourLibFollowService;
	@Autowired
	private IStartWorkReportService startWorkReportService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FourLibFollowEntity fourLibFollowEntity = fourLibFollowService.selectById(billId);
		Long projectId = fourLibFollowEntity.getProjectId();
		Long sourceId = fourLibFollowEntity.getSourceId();
		if(sourceId != null){
			if("开工报告".equals(fourLibFollowEntity.getSourceType())){
				StartWorkReportEntity startWorkReportEntity = startWorkReportService.selectById(sourceId);
				startWorkReportEntity.setLibDate(fourLibFollowEntity.getServiceDate());
				startWorkReportEntity.setLibFollowType(fourLibFollowEntity.getFollowType());
				startWorkReportEntity.setLibLevel(fourLibFollowEntity.getLibLevel());
				startWorkReportEntity.setLibRemark(fourLibFollowEntity.getRemark());
				startWorkReportService.saveOrUpdate(startWorkReportEntity);
			} else if("竣工报告".equals(fourLibFollowEntity.getSourceType())){
				CompletionWorkReportEntity completionWorkReportEntity = completionWorkReportService.selectById(sourceId);
				completionWorkReportEntity.setLibDate(fourLibFollowEntity.getServiceDate());
				completionWorkReportEntity.setLibFollowType(fourLibFollowEntity.getFollowType());
				completionWorkReportEntity.setLibLevel(fourLibFollowEntity.getLibLevel());
				completionWorkReportEntity.setLibRemark(fourLibFollowEntity.getRemark());
				completionWorkReportService.saveOrUpdate(completionWorkReportEntity);
			}
		}
		if(projectId != null){
			ProjectSetEntity projectSetEntity = projectSetService.selectById(projectId);
			projectSetEntity.setLibDate(fourLibFollowEntity.getServiceDate());
			projectSetEntity.setLibFollowType(fourLibFollowEntity.getFollowType());
			projectSetEntity.setLibLevel(fourLibFollowEntity.getLibLevel());
			projectSetEntity.setLibRemark(fourLibFollowEntity.getRemark());
			projectSetService.saveOrUpdate(projectSetEntity);
		}


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
