package com.ejianc.business.projectOverView.mapper;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.JsglViewVO;
import com.ejianc.business.constructor.vo.ProgramReportVO;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.danger.vo.DangerProjectVO;
import com.ejianc.business.outputvalcount.vo.*;
import com.ejianc.business.plan.vo.TotalPlanVO;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.qualisafe.vo.CheckVO;
import com.ejianc.business.qualisafe.vo.RectificationNoticeVO;
import com.ejianc.business.qualisafe.vo.RectificationRepeatVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.technology.vo.YjDetailVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;


/**
 * 项目一览门户
 *
 * @author generator
 */
@Mapper
public interface ProjectOverViewMapper {

    /**
     * 根据项目id、方案类型查询审批通过的方案
     *
     * @param projectId
     * @param tags
     * @return
     */
    List<JsglViewVO> queryFaData(Long projectId, String tags);

    /**
     * 根据项目id、方案类型查询计划的方案
     *
     * @param projectId
     * @param tags
     * @return
     */
    List<ProgramReportVO> queryFaPlanData(Long projectId, String tags);

    /**
     * 根据项目id查询质量打分记录
     *
     * @param projectId
     * @return
     */
    List<CheckVO> queryQualityCheckData(Long projectId);

    /**
     * 根据项目id查询大型设备信息
     *
     * @param projectId
     * @return
     */
    List<RentParameterVO> queryLargeEquipment(Long projectId);

    /**
     * 根据项目id查询监理会议纪要数据
     *
     * @param projectId
     * @return
     */
    List<MeetingMinutesVO> queryMeetingMinutesData(Long projectId);

    /**
     * 根据项目id查询工程创优目标审定
     *
     * @return
     */
    GccymbsdVO queryTarget(Long projectId);

    /**
     * 根据项目id,日期年月，查询项目影像管理数据
     */
    List<XmyxglVO> queryImageData(Long projectId, int year, int month);

    /**
     * 根据项目id,查询所有项目影像管理数据
     */
    List<XmyxglVO> queryAllImageData(Long projectId);

    /**
     * 根据项目id,日期年月，查询月度产值统计
     */
    MonthlyStatisticsVO queryMonthlyStatistics(Long projectId, int year, int month);

    /**
     * 根据项目id，查询个人施工日志
     *
     * @param projectId
     * @return
     */
    List<PersonVO> queryPersonLog(Long projectId);

    /**
     * 根据项目id，查询项目施工日志
     *
     * @param projectId
     * @param date      非必填，如果为空则查询所有数据
     * @return
     */
    List<ProjectLogVO> queryProjectLog(Long projectId, String date);

    /**
     * 根据项目id,查询计划数量
     *
     * @param projectId
     * @return
     */
    Integer queryTotalPlanData(Long projectId);//总计划

    Integer queryYearPlanData(Long projectId);//年计划

    Integer queryMonthPlanData(Long projectId);//月计划

    Integer queryWeekPlanData(Long projectId);//周计划


    /**
     * 从中标人员选择中查找报备人员
     *
     * @param wrapper
     * @return
     */
    List<ZjllVO> getUserInfoByProjectId(Page<ZjllVO> page, @Param(Constants.WRAPPER)  QueryWrapper wrapper);

    /**
     * 根据项目id查询所有业绩
     *
     * @param projectId
     * @return
     */
    List<YjDetailVO> queryYjDetailList(Long projectId);

    /**
     * 根据项目id查询总计划
     * @param projectId
     * @return
     */
    @Select("SELECT * FROM `ejc-zjkjprogress`.`ejc_zjkjprogress_total_plan` " +
            "where dr = 0 and bill_state in (1,3) and project_id = #{project}")
    TotalPlanVO queryTotalPlanVO(Long projectId);

    /**
     * 根据项目id查询整改通知单
     * @param projectId
     * @return
     */
    @Select("SELECT * FROM `ejc-companypfm`.`t_quality_rectification_notice` " +
            "where dr = 0 and bill_state in (1,3) and project_id = #{projectId}")
    List<RectificationNoticeVO> queryNoticeList(Long projectId);

    /**
     * 根据项目id查询整改回复单
     * @param projectId
     * @return
     */
    @Select("SELECT * FROM `ejc-companypfm`.`t_quality_rectification_repeat` " +
            "where dr = 0 and bill_state in (1,3) and project_id = #{projectId}")
    List<RectificationRepeatVO> queryRepeatList(Long projectId);

    /**
     * 根据项目id查询相关方每日信息填报
     * @param projectId
     * @return
     */
    @Select("SELECT * FROM `zzyj-outputvalcount`.`t_project_info_register` " +
            "where dr = 0 and bill_state in (1,3) and project_id = #{projectId}")
    List<ProjectInfoRegisterVO> queryProjectInfoRegisterList(Long projectId);

    /**
     * 根据项目id查询相关方每日信息填报主表id查询子表，上级单位检查
     * @param ids
     * @return
     */
    List<ProjectInfoRegisterExamineVO> queryProjectInfoExamineList(@Param("ids") List<Long> ids);
    /**
     * 根据项目id查询相关方每日信息填报主表id查询子表，合同纠纷异常
     * @param ids
     * @return
     */
    List<ProjectInfoRegisterDisputeVO> queryProjectInfoDisputeList(@Param("ids") List<Long> ids);
    /**
     * 根据项目id查询相关方每日信息填报主表id查询子表，其他协同异常
     * @param ids
     * @return
     */
    List<ProjectInfoRegisterCommunicationVO> queryProjectInfoCommunicationList(@Param("ids") List<Long> ids);

    /**
     * 根据项目id、指标id查询风险管理风险等级
     * @param projectId
     * @param indexId
     * @return
     */
    @Select("SELECT * FROM `ejc-companypfm`.`t_risk_manage_assess_latest` a " +
            "LEFT JOIN ( SELECT id AS zi_id, zhu_id AS source_zhu_id FROM `ejc-companypfm`.t_risk_manage_assess_zi WHERE dr = 0 ) b ON a.source_id = b.zi_id " +
            "WHERE dr = 0 " +
            "AND project_id = #{projectId} " +
            "AND index_id = #{indexId} " +
            "AND is_close = 0 " +
            "limit 1")
    RiskAssessLatestVO queryProjectRiskLevel(Long projectId, Long indexId);

    /**
     * 根据项目id获得所有危大工程
     * @param projectId
     * @return
     */
    @Select("SELECT * FROM `ejc-promarket`.`ejc_promarket_danger_project` " +
            "where dr = 0 and bill_state in (1,3) and project_id = #{projectId}")
    List<DangerProjectVO> getDangerProjectList(Long projectId);


    /**
     * 根据项目id,计算类型获取劳务分包月度结算
     * @param projectId
     * @return
     */
    List<SettleVO> queryLaborSubSettle(Long projectId, String settleType);

    /**
     * 根据项目id,计算类型获取材料结算
     * @param projectId
     * @return
     */
    List<SettlementVO> queryMaterialSettle(Long projectId, String settleType);

    /**
     * 根据项目id,计算类型获取混凝土结算
     * @param projectId
     * @return
     */
    List<com.ejianc.business.pro.rmat.vo.SettleVO> queryRmatSettle(Long projectId, String settleType);


    /**
     * 查询项目进度明细
     * @param wrapper
     * @return
     */
    List<MonthlyStatisticsVO> getStatisticsByOrgIdUnder(@Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 查询应急演练
     * @param wrapper
     * @return
     */
    List<PracticeVO> getPracticeList(@Param(Constants.WRAPPER) QueryWrapper wrapper);

}
