package com.ejianc.business.promaterial.scrap.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.elasticsearch.search.DocValueFormat;


/**
 * 废旧物资处置申请
 * 
 * @author generator
 * 
 */
public class ScrapMaterialApplicationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime; // 申请日期
    private String billCode; // 单据编号
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private String parentOrgName; // 父组织名称
    private String parentOrgCode; // 父组织编码
    private String otherReason; // 其他原因
    private String mainMaterialName; // 主要物资名称
    private String compiler; // 编制人
    private String disposalReason; // 处置原因
    private String platformName; // 平台名称
    private String notFirstDisposalReason; // 非首次处置原因
    private Integer disposalNumber; // 处置次数
    private Integer billState; // 单据状态
    private Integer scrapType; // 废旧类型
    private Integer disposalType; // 处置方式
    private Integer isFirstDisposal; // 是否首次处置
    private Integer isNeedAssess; // 是否需要评估
    private Integer disposalPlatform; // 处置平台
    private Integer pricingType; // 定价方式
    private Long projectId; // 项目ID
    private Long orgId; // 组织
    private Long parentOrgId; // 父组织ID
    
    private List<ScrapMaterialApplicationInviteContentVO> scrapMaterialApplicationInviteContentList = new ArrayList<>(); // 废旧物资处置申请子表（拟邀请单位）
    private List<ScrapMaterialApplicationManifestContentVO> scrapMaterialApplicationManifestContentList = new ArrayList<>(); // 废旧物资处置申请子表（清单明细）

    private BigDecimal estimatedAmount; // 估算金额
    private BigDecimal minLimitPrice; // 最低限制金额

    private String scrapTypeName; // 废旧类型名称
    private String billStateName; // 单据状态名称
    private Integer isUsed; // 是否已使用
    private String isUsedName; // 是否已使用名称

    public Integer getIsUsed() {
        return isUsed;
    }

    public void setIsUsed(Integer isUsed) {
        this.isUsed = isUsed;
    }

    public String getIsUsedName() {
        return isUsedName;
    }

    public void setIsUsedName(String isUsedName) {
        this.isUsedName = isUsedName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getScrapTypeName() {
        return scrapTypeName;
    }

    public void setScrapTypeName(String scrapTypeName) {
        this.scrapTypeName = scrapTypeName;
    }

    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    public BigDecimal getMinLimitPrice() {
        return minLimitPrice;
    }

    public void setMinLimitPrice(BigDecimal minLimitPrice) {
        this.minLimitPrice = minLimitPrice;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getOtherReason() {
        return otherReason;
    }

    public void setOtherReason(String otherReason) {
        this.otherReason = otherReason;
    }
    public String getMainMaterialName() {
        return mainMaterialName;
    }

    public void setMainMaterialName(String mainMaterialName) {
        this.mainMaterialName = mainMaterialName;
    }
    public String getCompiler() {
        return compiler;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }
    public String getDisposalReason() {
        return disposalReason;
    }

    public void setDisposalReason(String disposalReason) {
        this.disposalReason = disposalReason;
    }
    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
    public String getNotFirstDisposalReason() {
        return notFirstDisposalReason;
    }

    public void setNotFirstDisposalReason(String notFirstDisposalReason) {
        this.notFirstDisposalReason = notFirstDisposalReason;
    }
    public Integer getDisposalNumber() {
        return disposalNumber;
    }

    public void setDisposalNumber(Integer disposalNumber) {
        this.disposalNumber = disposalNumber;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getScrapType() {
        return scrapType;
    }

    public void setScrapType(Integer scrapType) {
        this.scrapType = scrapType;
    }
    public Integer getDisposalType() {
        return disposalType;
    }

    public void setDisposalType(Integer disposalType) {
        this.disposalType = disposalType;
    }
    public Integer getIsFirstDisposal() {
        return isFirstDisposal;
    }

    public void setIsFirstDisposal(Integer isFirstDisposal) {
        this.isFirstDisposal = isFirstDisposal;
    }
    public Integer getIsNeedAssess() {
        return isNeedAssess;
    }

    public void setIsNeedAssess(Integer isNeedAssess) {
        this.isNeedAssess = isNeedAssess;
    }
    public Integer getDisposalPlatform() {
        return disposalPlatform;
    }

    public void setDisposalPlatform(Integer disposalPlatform) {
        this.disposalPlatform = disposalPlatform;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    @ReferSerialTransfer(referCode="project-set")

    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    
     public List<ScrapMaterialApplicationInviteContentVO> getScrapMaterialApplicationInviteContentList() {
        return scrapMaterialApplicationInviteContentList;
     }

     public void setScrapMaterialApplicationInviteContentList(List<ScrapMaterialApplicationInviteContentVO> scrapMaterialApplicationInviteContentList) {
        this.scrapMaterialApplicationInviteContentList = scrapMaterialApplicationInviteContentList;
     }
     public List<ScrapMaterialApplicationManifestContentVO> getScrapMaterialApplicationManifestContentList() {
        return scrapMaterialApplicationManifestContentList;
     }

     public void setScrapMaterialApplicationManifestContentList(List<ScrapMaterialApplicationManifestContentVO> scrapMaterialApplicationManifestContentList) {
        this.scrapMaterialApplicationManifestContentList = scrapMaterialApplicationManifestContentList;
     }
}
