package com.ejianc.business.promaterial.check.vo;

import com.ejianc.framework.core.response.BillStateEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 是否推送供方成功
 */
public enum WeighUnitEnum {

    千克("千克", 0),
    KG("KG", 0),
    kg("kg", 0),
    Kg("Kg", 0),
    公斤("公斤", 0),
    吨("吨", 1),
    t("t", 1),
    T("T", 1);

    private final Integer billStateCode;
    private final String description;

    private static Map<String, WeighUnitEnum> enumMap = new HashMap<>();

    WeighUnitEnum( String description,Integer billStateCode) {
        this.billStateCode = billStateCode;
        this.description = description;
    }

    public Integer getBillStateCode() {
        return billStateCode;
    }
    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(WeighUnitEnum.class).stream().collect(Collectors.toMap(WeighUnitEnum::getDescription, Function.identity(), (k1, k2) -> k2));
    }

    public static WeighUnitEnum getEnumByStateCode(String description) {
        return enumMap.get(description);
    }
}
