package com.ejianc.business.promaterial.delivery.api;

import com.ejianc.business.promaterial.delivery.hystrix.IDeliveryHystrix;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = IDeliveryHystrix.class
)
public interface IDeliveryApi {

    /**
     * 根据物资明细id 获取发货单详情
     *
     */
    @RequestMapping(
            value = {"/api/delivery/queryDeliveryByDetailId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<DeliveryVO> queryDeliveryByDetailId(@RequestParam("detailId") Long detailId);

    /**
     * 根据物资明细id 获取混凝土发货单详情
     *
     */
    @RequestMapping(
            value = {"/api/delivery/queryConcreteDeliveryByDetailId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<DeliveryVO> queryConcreteDeliveryByDetailId(@RequestParam("detailId") Long detailId);
}
