package com.ejianc.business.promaterial.loss.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.promaterial.loss.vo.LossAnalysisDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 损耗分析
 * 
 * @author generator
 * 
 */
public class LossAnalysisVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 
    private Long orgId; // 项目部id
    private String orgName; // 
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date analysisTime; // 分析时间
    private Long analysisUserId; // 统计人员
    private String analysisUserName; // 统计人员姓名
    private BigDecimal rebarLossRate; // 钢筋损耗率
    private BigDecimal concreteLossRate; // 混凝土损耗率
    private BigDecimal planNum; // 计划总量
    private BigDecimal actualNum; // 实际总量
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 业务日期
    private String analysisName; // 分析主题
    private List<LossAnalysisDetailVO> lossAnalysisDetailList = new ArrayList<>(); // 损耗分析明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getAnalysisTime() {
        return analysisTime;
    }

    public void setAnalysisTime(Date analysisTime) {
        this.analysisTime = analysisTime;
    }
    public Long getAnalysisUserId() {
        return analysisUserId;
    }

    public void setAnalysisUserId(Long analysisUserId) {
        this.analysisUserId = analysisUserId;
    }
    public String getAnalysisUserName() {
        return analysisUserName;
    }

    public void setAnalysisUserName(String analysisUserName) {
        this.analysisUserName = analysisUserName;
    }
    public BigDecimal getRebarLossRate() {
        return rebarLossRate;
    }

    public void setRebarLossRate(BigDecimal rebarLossRate) {
        this.rebarLossRate = rebarLossRate;
    }
    public BigDecimal getConcreteLossRate() {
        return concreteLossRate;
    }

    public void setConcreteLossRate(BigDecimal concreteLossRate) {
        this.concreteLossRate = concreteLossRate;
    }
    
     public List<LossAnalysisDetailVO> getLossAnalysisDetailList() {
        return lossAnalysisDetailList;
     }

     public void setLossAnalysisDetailList(List<LossAnalysisDetailVO> lossAnalysisDetailList) {
        this.lossAnalysisDetailList = lossAnalysisDetailList;
     }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getActualNum() {
        return actualNum;
    }

    public void setActualNum(BigDecimal actualNum) {
        this.actualNum = actualNum;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getAnalysisName() {
        return analysisName;
    }

    public void setAnalysisName(String analysisName) {
        this.analysisName = analysisName;
    }
}
