package com.ejianc.business.promaterial.contract.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 记录-合同条款实体
 * 
 * @author generator
 * 
 */
@ApiModel("记录-合同条款实体")
public class ContractRecordClauseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("记录主键")
    private Long recordId;
    @ApiModelProperty("原合同子表主键")
    private Long contractClauseId;
    @ApiModelProperty("合同条款名称Id")
    private Long clauseId;
    @ApiModelProperty("合同条款名称")
    private String clauseName;
    @ApiModelProperty("合同条款内容")
    private String clauseContent;
    @ApiModelProperty("所属合同Id")
    private Long contractId;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;
    private Long srcTblId; // 来源子表主键
    /**
     * 是否必填 0否  1是
     */
    private Integer necessaryStatus;

    public Integer getNecessaryStatus() {
        return necessaryStatus;
    }

    public void setNecessaryStatus(Integer necessaryStatus) {
        this.necessaryStatus = necessaryStatus;
    }

    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }

    /**
     * 记录主键
     */
    public Long getRecordId() {
        return recordId;
    }

    /**
     * 记录主键
     */
    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    /**
     * 原合同子表主键
     */
    public Long getContractClauseId() {
        return contractClauseId;
    }

    /**
     * 原合同子表主键
     */
    public void setContractClauseId(Long contractClauseId) {
        this.contractClauseId = contractClauseId;
    }
    /**
     * 合同条款名称Id
     */
    @ReferSerialTransfer(referCode="contractClause")
    public Long getClauseId() {
        return clauseId;
    }

    /**
     * 合同条款名称Id
     */
    @ReferDeserialTransfer
    public void setClauseId(Long clauseId) {
        this.clauseId = clauseId;
    }
    /**
     * 合同条款名称
     */
    public String getClauseName() {
        return clauseName;
    }

    /**
     * 合同条款名称
     */
    public void setClauseName(String clauseName) {
        this.clauseName = clauseName;
    }
    /**
     * 合同条款内容
     */
    public String getClauseContent() {
        return clauseContent;
    }

    /**
     * 合同条款内容
     */
    public void setClauseContent(String clauseContent) {
        this.clauseContent = clauseContent;
    }
    /**
     * 所属合同Id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 所属合同Id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    
}
