package com.ejianc.business.promaterial.pricelib.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 材料指导价子表
 * 
 * @author generator
 * 
 */
@ApiModel("材料指导价子表")
public class PriceGuideDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键ID")
    private Long guideId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("分类内码")
    private String innerCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("最低价(无税)")
    private BigDecimal minMny;
    @ApiModelProperty("最高价(无税)")
    private BigDecimal maxMny;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("合同价格区间（无税）")
    private String contractPriceArea;
    @ApiModelProperty("合同价格区间（含税）")
    private String contractTaxPriceArea;
    @ApiModelProperty("验收价格区间（无税）")
    private String checkPriceArea;
    @ApiModelProperty("验收价格区间（含税）")
    private String checkTaxPriceArea;
    @ApiModelProperty("结算价格区间（无税）")
    private String settlePriceArea;
    @ApiModelProperty("结算价格区间（含税）")
    private String settleTaxPriceArea;
    

    /**
     * 主表主键ID
     */
    public Long getGuideId() {
        return guideId;
    }

    /**
     * 主表主键ID
     */
    public void setGuideId(Long guideId) {
        this.guideId = guideId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 分类内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 分类内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 规则/型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规则/型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 最低价(无税)
     */
    public BigDecimal getMinMny() {
        return minMny;
    }

    /**
     * 最低价(无税)
     */
    public void setMinMny(BigDecimal minMny) {
        this.minMny = minMny;
    }
    /**
     * 最高价(无税)
     */
    public BigDecimal getMaxMny() {
        return maxMny;
    }

    /**
     * 最高价(无税)
     */
    public void setMaxMny(BigDecimal maxMny) {
        this.maxMny = maxMny;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 合同价格区间（无税）
     */
    public String getContractPriceArea() {
        return contractPriceArea;
    }

    /**
     * 合同价格区间（无税）
     */
    public void setContractPriceArea(String contractPriceArea) {
        this.contractPriceArea = contractPriceArea;
    }
    /**
     * 合同价格区间（含税）
     */
    public String getContractTaxPriceArea() {
        return contractTaxPriceArea;
    }

    /**
     * 合同价格区间（含税）
     */
    public void setContractTaxPriceArea(String contractTaxPriceArea) {
        this.contractTaxPriceArea = contractTaxPriceArea;
    }
    /**
     * 验收价格区间（无税）
     */
    public String getCheckPriceArea() {
        return checkPriceArea;
    }

    /**
     * 验收价格区间（无税）
     */
    public void setCheckPriceArea(String checkPriceArea) {
        this.checkPriceArea = checkPriceArea;
    }
    /**
     * 验收价格区间（含税）
     */
    public String getCheckTaxPriceArea() {
        return checkTaxPriceArea;
    }

    /**
     * 验收价格区间（含税）
     */
    public void setCheckTaxPriceArea(String checkTaxPriceArea) {
        this.checkTaxPriceArea = checkTaxPriceArea;
    }
    /**
     * 结算价格区间（无税）
     */
    public String getSettlePriceArea() {
        return settlePriceArea;
    }

    /**
     * 结算价格区间（无税）
     */
    public void setSettlePriceArea(String settlePriceArea) {
        this.settlePriceArea = settlePriceArea;
    }
    /**
     * 结算价格区间（含税）
     */
    public String getSettleTaxPriceArea() {
        return settleTaxPriceArea;
    }

    /**
     * 结算价格区间（含税）
     */
    public void setSettleTaxPriceArea(String settleTaxPriceArea) {
        this.settleTaxPriceArea = settleTaxPriceArea;
    }
    
}
