package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
@Api(value = "消耗材-验收主表", tags = {"消耗材-验收主表"})
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/check/card";
    ;

    @Autowired
    private ICheckService service;
    @Autowired
    private CheckBpmServiceImpl checkBpmService;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";

    @Autowired
    ICommonBusinessService check;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {

        CheckVO vo = service.saveOrUpdates(saveOrUpdateVO, false);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
    	CheckEntity entity = service.selectById(id);
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deletssse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deletesss(@RequestParam Long billId) {
        checkBpmService.afterApprovalProcessor(billId,null,"BILL_TYPE");
//        concreteCheckBpmService.afterApprovalProcessor(billId,null,"BT220224000000004");
        return null;
    }
//    @ApiOperation("批量删除单据")
//    @RequestMapping(value = "/deletesss1", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> deletesss1(@RequestParam Long billId) {
////        checkBpmService.afterAbstainingProcessor(billId,null,null);
//        concreteCheckBpmService.afterAbstainingProcessor(billId,null,null);
//        return null;
//    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        if (param.getParams().containsKey("hasContract")){
            //1 有合同 2 无合同
            String hasContract  = param.getParams().get("hasContract").getValue().toString();
            if (hasContract.equals("1")){
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is not null"));
            }
            if (hasContract.equals("2")){
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is  null"));
            }
            param.getParams().remove("hasContract");

        }

        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 甲供材对账单获取材料验收单参照
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refCheckToAccountData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckToAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("salaryBillCode");
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        JSONObject _con = JSONObject.parseObject(condition);

        String projectId = _con.getString("projectId");
        if(StringUtils.isBlank(projectId)) {
            return CommonResponse.error("查询失败，缺少参数项目id-projectId！");
        }
        String attrFlag = _con.getString("attrFlag");

        queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        if (StringUtils.isNotBlank(attrFlag)){
            queryParam.getParams().put("attr_flag", new Parameter(QueryParam.EQ, attrFlag));
        }
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));

        IPage<CheckEntity> page = service.queryPage(queryParam);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }




}
