package com.ejianc.business.promaterial.settlement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.ExportSettlementVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 结算单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlement")
@Api(value = "结算单主表", tags = {"结算单主表"})
public class SettlementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISettlementService service;

    @Autowired
    private ISupplierApi supplierApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SettlementVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementVO> queryDetail(@RequestParam Long id) {
    	SettlementEntity entity = service.selectById(id);
    	SettlementVO vo = BeanMapper.map(entity, SettlementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("获取最近一次结算日期和结算金额，结算次数")
    @RequestMapping(value = "/getDateMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return service.getDateMny(contractId);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementVO> vos) {
        return service.delete(vos);
    }

    /**
     * @param id 合同id
     */
    @ApiOperation("根据合同id查询结算记录")
    @RequestMapping(value = "/querySettleRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementRecordVO> querySettleRecord(@RequestParam Long id) {
        SettlementRecordVO vo = service.querySettleRecord(id);
        return CommonResponse.success("查询结算单成功",vo);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<String> supState = new ArrayList<>();
        supState.add("checking");//供方状态--审核中
        supState.add("pass");//供方状态--已生效

        param.getComplexParams().add(getPageQueryParam(supState));

        IPage<SettlementEntity> page = service.queryPage(param,false);
        IPage<SettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public ComplexParam getPageQueryParam(List<String> supState) {
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c3.getParams().put("changState",new Parameter(QueryParam.IN,supState));//状态 in 审批中，已生效的数据
        c1.getComplexParams().add(c3);
        return c1;
    }

    @ApiOperation("供方查询列表")
    @RequestMapping(value = "/queryGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> queryGFList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        /** 租户隔离 */
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();
        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));

        param.getComplexParams().add(getGFPageQueryParam());

        IPage<SettlementEntity> page = service.queryPage(param,false);
        IPage<SettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public ComplexParam getGFPageQueryParam() {
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));//审批通过
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c1.getComplexParams().add(c3);
        return c1;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void ConcreteExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        //1 采购端数据 - - 租户主键是自己的 or  供方数据 - - 租户主键是自己的 并且 供应商状态 in （审核中、已生效）
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<String> supState = new ArrayList<>();
        supState.add("checking");//供方状态--审核中
        supState.add("pass");//供方状态--已生效
        param.getComplexParams().add(getPageQueryParam(supState));
        List<SettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        ArrayList<ExportSettlementVO> settlementVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for (SettlementEntity entity : list) {
                ExportSettlementVO map = BeanMapper.map(entity, ExportSettlementVO.class);
                if(entity.getSettlementDate()!=null){
                    map.setSettlementDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getSettlementDate()));
                }
                switch (entity.getBillState()){
                    case 0: map.setBillState("自由态");break;
                    case 1: map.setBillState("已提交");break;
                    case 2: map.setBillState("审批中");break;
                    case 3: map.setBillState("审批通过");break;
                    case 4: map.setBillState("审批驳回");break;
                    case 5: map.setBillState("审批中");break;
                }
                settlementVOS.add(map);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("Settlement-export.xlsx", beans, response);
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refSettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> refSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementEntity> page = service.queryPage(param,false);
        IPage<SettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 查询合同结算记录
     *
     * @return
     */
    @GetMapping(value = "/queryDetailRecord")
    @ResponseBody
    public CommonResponse<ContractSettlementRecordVO> queryDetailRecord(Long id) {
        ContractSettlementRecordVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询合同结算记录
     *
     * @return
     */
    @PostMapping(value = "/querySettlementByContractId")
    @ResponseBody
    public CommonResponse<List<SettlementVO>> querySettlementByContractId(@RequestBody SettlementVO settlementVO) {
        List<SettlementVO> list = service.querySettlementByContractId(settlementVO);
        return CommonResponse.success("查询详情数据成功！", list);
    }


}
