/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.business.promaterial.returnGoods.bean.ReturnGoodsEntity;
import com.ejianc.business.promaterial.returnGoods.service.IReturnGoodsService;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reconciliation"})
@Api(value="\u5bf9\u8d26\u5355\u4e3b\u8868", tags={"\u5bf9\u8d26\u5355\u4e3b\u8868"})
public class ReconciliationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DZ_CODE";
    @Autowired
    private IReconciliationService service;
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IReturnGoodsService returnGoodsService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReconciliationVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ReconciliationVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper;
        ReconciliationEntity entity = (ReconciliationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReconciliationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.checkContract(entity);
        List list = null == saveOrUpdateVO.getId() || saveOrUpdateVO.getId() == 0L ? this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId())).in((Object)"bill_state", new Object[]{0, 2, 4, 5})).eq((Object)"dr", (Object)0)) : this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId())).in((Object)"bill_state", new Object[]{0, 2, 4, 5})).eq((Object)"dr", (Object)0)).ne((Object)"id", (Object)saveOrUpdateVO.getId()));
        if (list.size() > 0) {
            throw new BusinessException(" \u4e00\u4e2a\u5408\u540c\u4e0b\u53ea\u80fd\u6709\u4e00\u5f20\u672a\u751f\u6548\u7684\u5bf9\u8d26\u5355");
        }
        HashSet<Long> CheckDelSet = new HashSet<Long>();
        HashSet<Long> CheckAddSet = new HashSet<Long>();
        HashSet<Long> returnDelSet = new HashSet<Long>();
        HashSet<Long> returnAddSet = new HashSet<Long>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDetailList())) {
            for (ReconciliationDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if ("del".equals(detailVO.getRowState())) {
                    if (0 == detailVO.getSourceType()) {
                        CheckDelSet.add(detailVO.getSourceId());
                        continue;
                    }
                    returnDelSet.add(detailVO.getSourceId());
                    continue;
                }
                if (0 == detailVO.getSourceType()) {
                    CheckAddSet.add(detailVO.getSourceId());
                    continue;
                }
                returnAddSet.add(detailVO.getSourceId());
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(CheckDelSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, CheckDelSet);
            updateWrapper.set(CheckEntity::getAccountFlag, (Object)0);
            this.checkService.update((Wrapper)updateWrapper);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(CheckAddSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, CheckAddSet);
            updateWrapper.set(CheckEntity::getAccountFlag, (Object)1);
            this.checkService.update((Wrapper)updateWrapper);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnDelSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, returnDelSet);
            updateWrapper.set(ReturnGoodsEntity::getAccountFlag, (Object)0);
            this.returnGoodsService.update((Wrapper)updateWrapper);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnAddSet)) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, returnAddSet);
            updateWrapper.set(ReturnGoodsEntity::getAccountFlag, (Object)1);
            this.returnGoodsService.update((Wrapper)updateWrapper);
        }
        entity.setMaterialName(entity.getDetailList().stream().map(ReconciliationDetailEntity::getMaterialName).collect(Collectors.joining(",")));
        this.service.saveOrUpdate((Object)entity, false);
        ReconciliationVO vo = (ReconciliationVO)BeanMapper.map((Object)((Object)entity), ReconciliationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryDetail(@RequestParam Long id) {
        ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(id));
        ReconciliationVO vo = (ReconciliationVO)BeanMapper.map((Object)((Object)entity), ReconciliationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u4f9b\u65b9\u63d0\u4ea4\u6216\u8005\u91c7\u8d2d\u65b9\u9a73\u56de")
    @RequestMapping(value={"/submitGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody ReconciliationVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        updateWrapper.set(ReconciliationEntity::getChangState, (Object)saveOrUpdateVO.getChangState());
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getReturnReason())) {
            updateWrapper.set(ReconciliationEntity::getReturnReason, (Object)saveOrUpdateVO.getReturnReason());
        }
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReconciliationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReconciliationVO vo : vos) {
                LambdaUpdateWrapper updateWrapper;
                ReconciliationEntity entity = (ReconciliationEntity)((Object)this.service.selectById(vo.getId()));
                HashSet<Long> CheckDelSet = new HashSet<Long>();
                HashSet<Long> returnDelSet = new HashSet<Long>();
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    for (ReconciliationDetailEntity detailVO : entity.getDetailList()) {
                        if (0 == detailVO.getSourceType()) {
                            CheckDelSet.add(detailVO.getSourceId());
                            continue;
                        }
                        returnDelSet.add(detailVO.getSourceId());
                    }
                }
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(CheckDelSet)) {
                    updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.in(BaseEntity::getId, CheckDelSet);
                    updateWrapper.set(CheckEntity::getAccountFlag, (Object)0);
                    this.checkService.update((Wrapper)updateWrapper);
                }
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(returnDelSet)) continue;
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, returnDelSet);
                updateWrapper.set(ReturnGoodsEntity::getAccountFlag, (Object)0);
                this.returnGoodsService.update((Wrapper)updateWrapper);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReconciliationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(List<String> supState) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c3.getParams().put("changState", new Parameter("in", supState));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @ApiOperation(value="\u4f9b\u65b9\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryGFList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReconciliationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getGFPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c3);
        return c1;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, ReconciliationVO.class);
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refReconciliationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> refReconciliationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        if (StringUtils.isNotEmpty((CharSequence)condition) && JSONObject.parseObject((String)condition).containsKey((Object)"gfSupplierId")) {
            CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        } else {
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("contract_id", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.containsKey((Object)"settleFlag")) {
                param.getParams().put("settle_flag", new Parameter("eq", _con.get((Object)"settleFlag")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        Map<Object, Object> map = new HashMap();
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resList = BeanMapper.mapList((Iterable)page.getRecords(), ReconciliationVO.class);
            List ids = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(ReconciliationDetailEntity::getReconciliationId, ids);
            List listRes = this.reconciliationDetailService.list((Wrapper)lambda);
            map = listRes.stream().collect(Collectors.groupingBy(ReconciliationDetailEntity::getReconciliationId));
            for (ReconciliationVO e : resList) {
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)map.get(e.getId())))) continue;
                e.setDetailList(BeanMapper.mapList((Iterable)((Iterable)map.get(e.getId())), ReconciliationDetailVO.class));
            }
        }
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u5408\u540c\u7d2f\u8ba1\u5bf9\u8d26\u6570\u91cf")
    @RequestMapping(value={"/queryReconciliationNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryReconciliationNum(@RequestParam Long id) {
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        Integer size = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"dr", (Object)0)).size();
        reconciliationVO.setTotalReconciliationNum(size);
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(SettlementEntity::getContractId, (Object)id);
        List list = this.settlementService.list((Wrapper)wrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliationVO.setSumSettlementMny(currentMny);
            reconciliationVO.setSumSettlementTaxMny(currentTaxMny);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)reconciliationVO);
    }
}

