package com.ejianc.business.promaterial.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("check") 
public class CheckBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
	@Autowired
	private IAttachmentApi attachmentApi;
	private final String OPERATE = "XHC_CHECK_SYNC";
	@Autowired
	private IContractService contractService;
	@Autowired
	private IDeliveryService deliveryService;
	@Autowired
	private ICheckDetailService checkDetailService;
	@Autowired
	private IDeliveryDetailService deliveryDetailService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/materialCheck/deleteCheck";
	private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";
	@Value("${contract.generateBillCodeType:common}")
	private String GenerateBillCodeType;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
//		CheckEntity e = checkService.selectById(billId);
////		//获取项目电子开启状态
////		ElectronicFenceConfigEntity electronicFenceConfig = electronicFenceConfigService.getOneByProjectId(e.getProjectId(), true);
////		if(null != electronicFenceConfig && Integer.valueOf(1).equals(electronicFenceConfig.getEnable())) {
////			String checkRs = checkHasAbnormalImg(e);
////			if(StringUtils.isNotBlank(checkRs)) {
////				return CommonResponse.error(checkRs);
////			}
////		}
		return CommonResponse.success();
	}


	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){


		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		CheckEntity entity = checkService.selectById(billId);
		entity.setChangState("pass");
		checkService.saveOrUpdate(entity, false);

		//回写发货单数据
        if (null != entity.getDeliveryType() && entity.getDeliveryType() == 1) {
            Integer checkStatus = 0;
            DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryId());
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<CheckDetailEntity> lambdaCheckDetail = Wrappers.<CheckDetailEntity>lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getDeliveryId, entity.getDeliveryId());
            List<CheckDetailEntity> checkDetailEntityList = checkDetailService.list(lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty(checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper<DeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, entity.getDeliveryId());
                List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailService.list(lambdaDeliveryDetail);

                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null == deliveryDetailEntity.getCheckNum()) {
                        deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                    }
                }

                //判断发货单的验收状态
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliverNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNum().compareTo(e.getDeliverNum()) == -1));

                if (allCheck) {
                    checkStatus = 2;
                }
                if (anyCheck) {
                    checkStatus = 1;
                }
                //更新发货验收状态和验收数量

                deliveryEntity.setCheckState(checkStatus);
                deliveryService.updateById(deliveryEntity);
                deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
        }

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//是否被其他单据引用
//		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(!res.isSuccess()) {
//			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
//		}

		return CommonResponse.error("验收单不支持撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

}
