package com.ejianc.business.promaterial.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.bean.*;
import com.ejianc.business.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.mapper.ContractChangeMapper;
import com.ejianc.business.promaterial.contract.service.*;
import com.ejianc.business.promaterial.contract.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 变更-合同实体
 *
 * @author generator
 */
@Service("contractChangeService")
public class ContractChangeServiceImpl extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity> implements IContractChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String CONTRACT_ATTACH_SOURCE_TYPE = "proMaterialContractBill";

    /**
     * 消耗材主合同单据类型
     */
    private static final String CONTRACT_MATERIAL = "BT211227000000003";
    private static final String CONTRACT_MATERIAL_RECORD = "BT220105000000028";

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IContractRecordService contractRecordService;
    @Autowired
    private IContractClauseService contractClauseService;

    @Autowired
    private IContractFeeService contractFeeService;

    @Autowired
    private IContractStageService contractStageService;

    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public ContractChangeVO insertOrUpdate(ContractChangeVO contractChangeVO, Boolean isControl) {
        ContractEntity contract = contractService.selectById(contractChangeVO.getContractId());

        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractChangeEntity entity = null;
        List<ContractEntity> entitiesc = null;
        List<ContractChangeEntity> entities = null;
        // 合同变更保存前校验
        contractService.checkContract(contractChangeVO.getContractId(), contractChangeVO.getId());

        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<ContractChangeEntity> lambdachange = Wrappers.<ContractChangeEntity>lambdaQuery();
        lambdachange.eq(ContractChangeEntity::getTenantId, tenantId);
        lambdachange.eq(ContractChangeEntity::getContractId, contractChangeVO.getContractId());
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0) {
            lambdachange.ne(ContractChangeEntity::getId, contractChangeVO.getId());
        }
        lambdachange.and((c -> c.notIn(ContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        //补充协议与变更合同只能存在一条未生效的
        LambdaQueryWrapper<ContractEntity> lambdaQuery2 = Wrappers.<ContractEntity>lambdaQuery();
        lambdaQuery2.eq(ContractEntity::getTenantId, tenantId);
        lambdaQuery2.eq(ContractEntity::getMainContractId, contractChangeVO.getContractId());
        lambdaQuery2.and((c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int nums = contractService.count(lambdaQuery2);
        if (nums > 0) {
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }

        ContractEntity pcentity = contractService.selectById(contractChangeVO.getContractId());
        if (!isControl) {
//            if (StringUtils.isEmpty(contractChangeVO.getBillCode())) {
//                String billCodeStr = CONTRACT_CHANGE;
//                if (CONTRACT_TYPE_1.equals(contractChangeVO.getContractType())) {
//                    billCodeStr = CONTRACT_CONCRETE_CHANGE;
//                }
//                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(billCodeStr, tenantId);
//                if (billCode.isSuccess()) {
//                    contractChangeVO.setBillCode(billCode.getData());
//                }
//                else {
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }
//            }
            if(StringUtils.isBlank(contractChangeVO.getBillCode())
                    || contract.getBillCode().equals(contractChangeVO.getBillCode())) {
                QueryParam billCodeParam = new QueryParam();
                billCodeParam.getParams().put("contract_id", new Parameter("eq", contractChangeVO.getContractId()));
                List<Integer> billStateList = new ArrayList<>();
                billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                billCodeParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
                List<ContractChangeEntity> billCodeChangeEntityList = super.queryList(billCodeParam, false);
                String changeNum = "";
                if (billCodeChangeEntityList.size() < 9) {
                    changeNum += "0" + (billCodeChangeEntityList.size() + 1);
                }else {
                    changeNum += (billCodeChangeEntityList.size() + 1);
                }
                String type = "-1-";
                contractChangeVO.setBillCode(contract.getBillCode() + type + changeNum);
//                if(contractChangeVO.getChangeVersion() < 10){
//                    contractChangeVO.setBillCode(contract.getBillCode() + type + "0" + contractChangeVO.getChangeVersion());
//                } else {
//                    contractChangeVO.setBillCode(contract.getBillCode() + type + contractChangeVO.getChangeVersion());
//                }
            }
        }

        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, contractChangeVO.getBillCode());
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.ne(ContractChangeEntity::getContractId, contractChangeVO.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
//            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, contractChangeVO.getContractId()));
            entitiesc = contractService.queryList(queryParam, false);

            pcentity.setId(contractChangeVO.getContractId());

        }
        else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, contractChangeVO.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId, contractChangeVO.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
//            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, contractChangeVO.getContractId()));
            entitiesc = contractService.queryList(queryParam, false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(contractChangeVO.getContractId());
            pcentity.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
            contractChangeVO.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
//            contractChangeVO.setMakeTime(new Date());
            if (isControl) {
                contractChangeVO.setId(IdWorker.getId());
            }
        }

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractChangeVO.getContractDetailList())) {
            contractChangeVO.getContractDetailList().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if ("add".equals(vo.getRowState())) {
//                        vo.setContractDetailId(vo.getId());
                    vo.setContractId(contractChangeVO.getContractId());
//                        vo.setChangeType(1);
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractChangeVO.getContractFeeList())) {
            contractChangeVO.getContractFeeList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractChangeVO.getContractClauseList())) {
            contractChangeVO.getContractClauseList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractChangeVO.getContractStageList())) {
            contractChangeVO.getContractStageList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(contractChangeVO, ContractChangeEntity.class);

        //目标成本删除之前数据
        //判断是否是第一次变更
        //集采时不推成本执行数据
        if (!isControl) {
//            if (entity.getId() == null && entity.getPurchaseType().equals("1")) {
//                QueryWrapper<ContractChangeEntity> wrapper = new QueryWrapper<>();
//                wrapper.eq("contract_id", entity.getContractId()).eq("dr", 0).orderByDesc("create_time");
//                List<ContractChangeEntity> list = contractChangeService.list(wrapper);
//                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//                ExecutionVO executionVO1;
//                int type;
//                //判断是否有过变更
//                if (list.size() > 0) {
//                    type = 1;
//                    executionVO1 = contractService.targetCost(BeanMapper.map(list.get(0), ContractVO.class), "", type, list.get(0).getContractType());
//                }
//                else {
//                    type = 0;
//                    ContractEntity contractEntity = contractService.selectById(entity.getContractId());
//                    executionVO1 = contractService.targetCost(BeanMapper.map(contractEntity, ContractVO.class), "", type, contractEntity.getContractType());
//                }
//                //目标成本推送
//                totalExecutionVOList.add(executionVO1.getTotalVO());
//                logger.info("目标成本推送数据" + JSON.toJSONString(totalExecutionVOList));
//                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
//                if (!response.isSuccess()) {
//                    throw new BusinessException("目标成本推送失败," + response.getMsg());
//                }
//            }
            super.saveOrUpdate(entity, false);
        }
        //回写合同表
        pcentity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingMnyWithTax(entity.getContractTaxMny());
        pcentity.setChangeDate(entity.getChangeDate());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        if (!isControl) {
            contractService.update(pcentity, new QueryWrapper<ContractEntity>().eq("id", pcentity.getId()), false);
        }
        ContractChangeVO res = BeanMapper.map(entity, ContractChangeVO.class);
        return res;
    }

    /**
     * 是否合同变更新增
     *
     * @param contractChangeVO 合同变更数据
     * @return 是否新增
     */
    private boolean isInsertContractChange(ContractChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0;
    }

    @Override
    public ContractChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        ContractChangeVO changeVO = new ContractChangeVO();
        BigDecimal baseTaxMoney = contractEntity.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : contractEntity.getBaseMoneyWithTax();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        changeVO.setId(id);
        changeVO.setContractId(id);
        changeVO.setBaseMoneyWithTax(baseTaxMoney);
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractTaxMny);
        changeVO.setAllChangeAmt(contractTaxMny.subtract(baseTaxMoney));
        changeVO.setOrgId(contractEntity.getParentOrgId());

        if (changeVO.getAllChangeAmt().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setChangeAmtRate(new BigDecimal(100).multiply(changeVO.getAllChangeAmt().divide(baseTaxMoney, 8, ROUND_HALF_DOWN)));
        }
        else {
            changeVO.setChangeAmtRate(BigDecimal.ZERO);
        }

        //合同版本号>0说明会有变更记录
        LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
        lambda.eq(ContractChangeEntity::getContractId, id);
        lambda.in(ContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ContractChangeEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            changeVO.setChangeList(BeanMapper.mapList(entities, ContractChangeVO.class));
            changeVO.setChangeNum(entities.size());
        }
        else {
            changeVO.setChangeNum(0);
        }
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());

        //判断能否新增变更
        if ((BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public ContractChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = contractService.selectById(contractId);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, changeId));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<ContractRecordEntity> recordList = contractRecordService.queryList(queryParam);
        ContractChangeVO changeVO = new ContractChangeVO();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(recordList)) {
            changeVO = BeanMapper.map(recordList.get(0), ContractChangeVO.class);
        }

//        if (changeVO !=null){contractChange/addConvertByConId
//            resetSub(changeVO);
//        }

        return changeVO;
    }

    @Override
    public ContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        ContractEntity entity = contractService.selectById(contractId);
        ContractChangeVO purchaseChangeVo = BeanMapper.map(entity, ContractChangeVO.class);
        //新增逻辑处理
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseChangeVo.setId(null);
//        purchaseChangeVo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeMnyWithTax(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());
        purchaseChangeVo.setBeforeChangeTax(entity.getContractTax());
        purchaseChangeVo.setContractType(entity.getContractType());

        List<ContractDetailEntity> details = null;
        LambdaQueryWrapper<ContractDetailEntity> lambda = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, contractId);
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.中止项);
        details = contractDetailService.list(lambda);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details)) {
            purchaseChangeVo.setContractDetailList(BeanMapper.mapList(details, ContractChangeDetailVO.class));
            purchaseChangeVo.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("0");
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
//                vo.setId(null);
            });
        }
        else {
            purchaseChangeVo.setContractDetailList(null);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(purchaseChangeVo.getContractFeeList())) {
            purchaseChangeVo.getContractFeeList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setChangeType(ChangeTypeEnum.未变更.getCode().toString());
                vo.setSrcTblId(vo.getId());
//                vo.setId(null);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(purchaseChangeVo.getContractClauseList())) {
            purchaseChangeVo.getContractClauseList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
//                vo.setId(null);
            });
        }

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(purchaseChangeVo.getContractStageList())) {
            purchaseChangeVo.getContractStageList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
//                vo.setId(null);
            });
        }
//        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(purchaseChangeVo.getContractAdmixtureList())) {
//            purchaseChangeVo.getContractAdmixtureList().forEach(vo -> {
//                vo.setContractId(purchaseChangeVo.getContractId());
//                vo.setRowState("add");
//                vo.setSrcTblId(vo.getId());
////                vo.setId(null);
//            });
//        }
        return purchaseChangeVo;
    }


    /**
     * 查询能否变更
     *
     * @param contractId
     * @return
     */
    public Boolean editChangeFlag(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        // 非履约中合同不允许变更
        if (!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractChangeEntity::getContractId, contractId);
        lambda.and((c -> c.notIn(ContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ContractChangeEntity> changeList = super.list(lambda);

        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    /**
     * 查询变更对比
     *
     * @param id
     * @param
     * @return
     */
    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
/*
            当前变更合同如果未签章，则和主合同对比
            如果签章，则和合同记录表对比
         */
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<>();
        orderByParams.put("treeIndex", QueryParam.ASC);
        Map<String, LinkedHashMap<String, String>> orders = new HashMap<>();
        orders.put("detailList", orderByParams);
        ContractChangeEntity changeEntity = super.selectById(id, orders);
        ContractChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ContractChangeCompareVO.class);
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
        ContractChangeCompareVO beforeChangeVO = new ContractChangeCompareVO();
        Map<Long, ContractChangeDetailVO> beforeDetailMap = new HashMap<>();
        Map<Long, ContractChangeFeeVO> beforeFeeMap = new HashMap<>();
        Map<Long, ContractChangeClauseVO> beforeClauseMap = new HashMap<>();
        Map<Long, ContractChangeStageVO> beforeStageMap = new HashMap<>();
//        Map<Long, ContractChangeAdmixtureVO> beforAdminxtureMap = new HashMap<>();
//        if (SignatureStatusEnum.已签章.getCode().equals(changeEntity.getSignatureStatus())) {
//            //若变更单已审批通过，则查询最新的合同记录
//            LambdaQueryWrapper<ContractRecordEntity> lambda = Wrappers.<ContractRecordEntity>lambdaQuery();
//            lambda.eq(ContractRecordEntity::getChangeId, id)
//                    .eq(ContractRecordEntity::getContractId, changeEntity.getContractId())
//                    .orderByDesc(ContractRecordEntity::getCreateTime);
//            List<ContractRecordEntity> recordList = contractRecordService.list(lambda);
//            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
//                // 列表查询没有子表数据，需要重新查子表数据
//                Long recordId = recordList.get(0).getId();
//                ContractRecordEntity recordEntity = contractRecordService.selectById(recordId);
//                beforeChangeVO = BeanMapper.map(recordEntity, ContractChangeCompareVO.class);
////                beforeChangeVO = BeanMapper.map(recordList.get(0), ContractChangeCompareVO.class);
//                //如果提交key为记录子表来源id
//                beforeDetailMap = beforeChangeVO.getContractDetailList().stream().collect(Collectors
//                        .toMap(ContractChangeDetailVO::getSrcTblId, detail -> detail, (v1, v2) -> v2));
//                beforeFeeMap = beforeChangeVO.getContractFeeList().stream()
//                        .collect(Collectors.toMap(ContractChangeFeeVO::getSrcTblId, fee -> fee, (v1, v2) -> v2));
//                beforeClauseMap = beforeChangeVO.getContractClauseList().stream().collect(Collectors
//                        .toMap(ContractChangeClauseVO::getSrcTblId, clause -> clause, (v1, v2) -> v2));
//                beforeStageMap = beforeChangeVO.getContractStageList().stream()
//                        .collect(Collectors.toMap(ContractChangeStageVO::getSrcTblId, item -> item, (v1, v2) -> v2));
////                // 混凝土合同需要处理外加剂
////                if (MaterialContractTypeEnum.混凝土.getCode().equals(recordList.get(0).getContractType())
////                        && CollectionUtils.isNotEmpty(beforeChangeVO.getContractAdmixtureList())) {
////                    beforAdminxtureMap = beforeChangeVO.getContractAdmixtureList().stream()
////                            .collect(Collectors.toMap(ContractChangeAdmixtureVO::getSrcTblId, item -> item, (v1, v2) -> v2));
////                }
//            }
//        }
//        else {
//            beforeChangeVO = BeanMapper.map(contractEntity, ContractChangeCompareVO.class);
//            //如果提交key为主合同子表id
//            beforeDetailMap = beforeChangeVO.getContractDetailList().stream().collect(Collectors.toMap(ContractChangeDetailVO::getId, detail -> detail, (v1, v2) -> v2));
//            beforeFeeMap = beforeChangeVO.getContractFeeList().stream().collect(Collectors.toMap(ContractChangeFeeVO::getId, fee -> fee, (v1, v2) -> v2));
//            beforeClauseMap = beforeChangeVO.getContractClauseList().stream().collect(Collectors.toMap(ContractChangeClauseVO::getId, clause -> clause, (v1, v2) -> v2));
//            beforeStageMap = beforeChangeVO.getContractStageList().stream().collect(Collectors.toMap(ContractChangeStageVO::getId, item -> item, (v1, v2) -> v2));
//        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            //设置明细内容
            List<ContractChangeDetailVO> newDetail = new ArrayList<>();
            Map<Long, ContractChangeDetailVO> finalBeforeDetailMap = beforeDetailMap;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeCompareVO.getContractDetailList())) {
                changeCompareVO.getContractDetailList().stream().forEach(detail -> {
                    if (!detail.getChangeType().equals(String.valueOf(ChangeTypeEnum.未变更.getCode()))) {
                        if (detail.getSrcTblId() == null) {//新增项
                            newDetail.add(detail);
                        }
                        if (finalBeforeDetailMap.containsKey(detail.getSrcTblId())) {
                            detail.setBeforeChangeRate(finalBeforeDetailMap.get(detail.getSrcTblId()).getDetailTaxRate());
                            detail.setBeforeChangePrice(finalBeforeDetailMap.get(detail.getSrcTblId()).getPrice());
                            detail.setBeforeChangeNum(finalBeforeDetailMap.get(detail.getSrcTblId()).getNum());
                            newDetail.add(detail);
                            finalBeforeDetailMap.remove(detail.getSrcTblId());
                        }
                    }
                });

            }
            changeCompareVO.setContractDetailList(newDetail);
            //设置其他花费内容
            List<ContractChangeFeeVO> newFee = new ArrayList<>();
            Map<Long, ContractChangeFeeVO> finalBeforeFeeMap = beforeFeeMap;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeCompareVO.getContractFeeList())) {
                changeCompareVO.getContractFeeList().stream().forEach(fee -> {
                    if (!String.valueOf(ChangeTypeEnum.未变更.getCode()).equals(fee.getChangeType())) {
                        if (fee.getSrcTblId() == null) {//新增项
                            newFee.add(fee);
                        }
                        if (finalBeforeFeeMap.containsKey(fee.getSrcTblId())) {
                            fee.setBeforeChangeCostRate(finalBeforeFeeMap.get(fee.getSrcTblId()).getFreeTaxRate());
                            fee.setBeforeChangeCostPrice(finalBeforeFeeMap.get(fee.getSrcTblId()).getFreePrice());
                            fee.setBeforeChangeCostNum(finalBeforeFeeMap.get(fee.getSrcTblId()).getFreeNum());
                            newFee.add(fee);
                            finalBeforeFeeMap.remove(fee.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractFeeList(newFee);
            //设置合同条款
            List<ContractChangeClauseVO> newClauses = new ArrayList<>();
            Map<Long, ContractChangeClauseVO> finalBeforeClauseMap = beforeClauseMap;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeCompareVO.getContractClauseList())) {
                changeCompareVO.getContractClauseList().stream().forEach(clause -> {
                    if (clause.getSrcTblId() == null) {
                        //没有来源则说明为新增项
                        clause.setChangeType("增补项");
                        newClauses.add(clause);
                    }
                    else if (finalBeforeClauseMap.containsKey(clause.getSrcTblId())) {
                        if (!finalBeforeClauseMap.get(clause.getSrcTblId()).getClauseContent().equals(clause.getClauseContent())) {
                            //若内容有变更
                            clause.setBeforeChangeClauseContent((finalBeforeClauseMap.get(clause.getSrcTblId()).getClauseContent()));
                            clause.setChangeType("内容变更");
                            newClauses.add(clause);
                        }
                        finalBeforeClauseMap.remove(clause.getSrcTblId());
                    }
                });
            }

            if (MapUtils.isNotEmpty(finalBeforeClauseMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                finalBeforeClauseMap.values().forEach(c -> {
                    c.setChangeType("删除项");
                    newClauses.add(c);
                });
            }
            changeCompareVO.setContractClauseList(newClauses);

            //设置合同付款阶段
            List<ContractChangeStageVO> newStageList = new ArrayList<>();
            Map<Long, ContractChangeStageVO> finalBeforeStageMap = beforeStageMap;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeCompareVO.getContractStageList())) {
                ContractChangeStageVO beforeItem = null;
                for (ContractChangeStageVO curItem : changeCompareVO.getContractStageList()) {
                    if (curItem.getSrcTblId() == null) {
                        //没有来源则说明为新增项
                        curItem.setChangeType("增补项");
                        newStageList.add(curItem);
                    }
                    else if (finalBeforeStageMap.containsKey(curItem.getSrcTblId())) {
                        beforeItem = finalBeforeStageMap.get(curItem.getSrcTblId());
                        if (!beforeItem.getStageName().equals(curItem.getStageName()) || !beforeItem.getStageScale().equals(curItem.getStageScale())) {
                            curItem.setBeforePaymentName(beforeItem.getStageName());
                            curItem.setBeforePaymentScale(beforeItem.getStageScale());
                            curItem.setChangeType("内容变更");
                            newStageList.add(curItem);
                        }
                        finalBeforeStageMap.remove(curItem.getSrcTblId());
                    }
                }
            }

            if (MapUtils.isNotEmpty(finalBeforeStageMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                finalBeforeStageMap.values().forEach(c -> {
                    c.setChangeType("删除项");
                    newStageList.add(c);
                });
            }
            changeCompareVO.setContractStageList(newStageList);

            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ContractChangeEntity entity = super.selectById(changeBillId);
        //合同变更只有详情页有删除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<ContractChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingMnyWithTax(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<ContractEntity>().eq("id", contractEntity.getId()), false);

        super.removeById(changeBillId, false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 文件复制
     *
     * @param srcBillId           源单据Id
     * @param srcBillTypeCode     源单据类型
     * @param targetBillId        目标单据Id
     * @param targetBillTypeCode  目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
        if (!copyContractAttachResp.isSuccess()) {
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    , srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }
        return null;
    }

    @Override
    public ContractChangeVO queryDetail(Long id) {
        ContractChangeEntity entity = contractChangeService.selectById(id);
        ContractChangeVO vo = BeanMapper.map(entity, ContractChangeVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState,Boolean filingFlag) {
        ContractChangeEntity changeEntity = super.selectById(billId);
        CommonResponse<String> resp = null;
        //1，先复制合同表到合同历史表
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
        ContractRecordEntity recordEntity = BeanMapper.map(contractEntity, ContractRecordEntity.class);
        logger.info("进入审批同意后回写--- changeEntity:" + changeEntity + "  contractEntity:" + contractEntity);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(recordEntity.getContractDetailList())) {
            recordEntity.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(recordEntity.getContractFeeList())) {
            recordEntity.getContractFeeList().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(recordEntity.getContractClauseList())) {
            recordEntity.getContractClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(recordEntity.getContractStageList())) {
            recordEntity.getContractStageList().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        contractRecordService.saveOrUpdate(recordEntity, false);
        //根据实体RefCode查询实体单据类型
//        CommonResponse<BillTypeVO> contractBillTypeResp = billTypeApi.getByRefCode(CONTRACT_REFCODE);
//        if (!contractBillTypeResp.isSuccess()) {
//            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", CONTRACT_REFCODE, contractBillTypeResp.getMsg());
//            return CommonResponse.error("查询元数据信息失败");
//        }
//        CommonResponse<BillTypeVO> contractRBillTypeResp = billTypeApi.getByRefCode(CONTRACT_RECORD_REFCODE);
//        if (!contractRBillTypeResp.isSuccess()) {
//            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", CONTRACT_RECORD_REFCODE, contractRBillTypeResp.getMsg());
//            return CommonResponse.error("查询元数据信息失败");
//        }
        String contractBillType = "";
        if(0==contractEntity.getFrameFlag()){
            //合同同步附件信息
            contractBillType = CONTRACT_MATERIAL;
            String contractRecordBillType = CONTRACT_MATERIAL_RECORD;
            //原合同附件同步
            resp = copyFile(contractEntity.getId().toString(), contractBillType,
                    recordEntity.getId().toString(), contractRecordBillType, CONTRACT_ATTACH_SOURCE_TYPE);
            if (resp != null) {
                return resp;
            }
        }

        //2，回写合同，变更状态改为已变更，并回写字段
//		contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
//        contractEntity.setContractMny(contractEntity.getChangingMny());
//        contractEntity.setContractTaxMny(contractEntity.getChangingMnyWithTax());
        // 合同金额
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        contractEntity.setDetailMny(changeEntity.getDetailMny());
        contractEntity.setDetailTax(changeEntity.getDetailTax());
        contractEntity.setFreeTaxMny(changeEntity.getFreeTaxMny());
        contractEntity.setFreeMny(changeEntity.getFreeMny());
        contractEntity.setFreeTax(changeEntity.getFreeTax());

        contractEntity.setPurchaseId(changeEntity.getPurchaseId());
        contractEntity.setPurchaseName(changeEntity.getPurchaseName());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
//        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
//		contractEntity.setPerformanceStatus(changeEntity.getPerformanceStatus());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setPricingType(changeEntity.getPricingType());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierEmployeeMobile(changeEntity.getSupplierEmployeeMobile());
        contractEntity.setProjectPlace(changeEntity.getProjectPlace());
        contractEntity.setSignPlace(changeEntity.getSignPlace());

        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        //清空变更单信息
        contractEntity.setChangingMny(null);
        contractEntity.setChangingMnyWithTax(null);

        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());

        logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
        //设置变更合同生效状态
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());
        //同步变更单附件、合同文件到原合同
        if(0==contractEntity.getFrameFlag()){
            copyFile(billId.toString(), billTypeCode, contractEntity.getId().toString(), contractBillType, "materialChangeContractFile");
        }
        if (resp != null) {
            return resp;
        }
        changeEntity.setChangeDate(new Date());
        contractChangeService.saveOrUpdate(changeEntity);
        logger.info("进入审批同意后回写--2");

        contractClauseService.deleteByContractId(changeEntity.getContractId());
        contractFeeService.deleteByContractId(changeEntity.getContractId());
        contractStageService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setContractClauseList(null);
        contractEntity.setContractFeeList(null);
        contractEntity.setContractStageList(null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeEntity.getContractDetailList())) {
            logger.info("复制子表开始--" + changeEntity.getContractDetailList());
            changeEntity.getContractDetailList().forEach(vo -> {
                logger.info("复制子表--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getContractDetailList().stream().collect(Collectors.toMap(ContractDetailEntity::getId, ContractDetailEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setContractDetailList(BeanMapper.mapList(changeEntity.getContractDetailList(), ContractDetailEntity.class));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeEntity.getContractFeeList())) {
            changeEntity.getContractFeeList().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setContractFeeList(BeanMapper.mapList(changeEntity.getContractFeeList(), ContractFeeEntity.class));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeEntity.getContractClauseList())) {
            changeEntity.getContractClauseList().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setContractClauseList(BeanMapper.mapList(changeEntity.getContractClauseList(), ContractClauseEntity.class));
        }

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(changeEntity.getContractStageList())) {
            changeEntity.getContractStageList().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setContractStageList(BeanMapper.mapList(changeEntity.getContractStageList(), ContractStageEntity.class));
        }
        boolean flag = contractService.saveOrUpdate(contractEntity, false);
        logger.info("业务逻辑完成--返回" + flag);
        if (flag) {
            return CommonResponse.success();
        }
        else {
            return CommonResponse.error("审批回写异常!");
        }
    }
}
