package com.ejianc.business.promaterial.order.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderVO;

/**
 * 材料订单主表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("order")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC_ORDER";//此处需要根据实际修改

    @Autowired
    private IOrderService service;
    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveOrUpdateVO) {
    	OrderEntity entity = BeanMapper.map(saveOrUpdateVO, OrderEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OrderVO vo = BeanMapper.map(entity, OrderVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
    	OrderEntity entity = service.selectById(id);
    	OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        List<DeliveryEntity> deliveryEntityList = deliveryService.list(new QueryWrapper<DeliveryEntity>().eq("order_id", vo.getId()));
        vo.setDeliveryList(BeanMapper.mapList(deliveryEntityList, DeliveryVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OrderVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<OrderVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,OrderVO.class);
            voList.forEach(c -> {
                if(null!=c.getDeliverState()){
                    switch (c.getDeliverState()){
                        case  0:c.setDeliverStateName("待送货");break;
                        case  1:c.setDeliverStateName("部分送货");break;
                        case  2:c.setDeliverStateName("已送货");break;
                    }
                }
                if(null!=c.getOrderFlag()){
                    switch (c.getOrderFlag()){
                        case  0:c.setOrderFlagName("正常");break;
                        case  1:c.setOrderFlagName("已关闭");break;
                    }
                }
                //流程状态
                c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Order-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOrderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orderFlag", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(_con.get("contractId")))));
            }
        }

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @ApiOperation("修改发货状态")
    @RequestMapping(value = "/updateDeliver", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> updateDeliver(@RequestBody OrderVO orderVO) {
        return service.updateDeliver(orderVO.getId(), orderVO.getDeliverState());
    }

    @ApiOperation("关闭")
    @RequestMapping(value = "/close", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> close(@RequestParam Long id){
        service.update(new UpdateWrapper<OrderEntity>().eq("id", id).set("order_flag", 1));
        return CommonResponse.success("成功");
    }

    @ApiOperation("根据合同id查询订单累计金额")
    @RequestMapping(value = "/getOrderDataByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> getOrderDataByContractId(@RequestParam Long contractId, @RequestParam(value = "orderId", required = false) Long orderId){
        OrderVO orderVO = new OrderVO();
        QueryWrapper<OrderEntity> orderQueryWrapper = new QueryWrapper<>();
        orderQueryWrapper.eq("contract_id", contractId);
        orderQueryWrapper.in("bill_state", Arrays.asList(1,3));
        if (null != orderId){
            orderQueryWrapper.ne("id", orderId);
        }
        List<OrderEntity> entityList = service.list(orderQueryWrapper);
        if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 0){
            orderVO.setContractNoOrderTaxMny(entityList.stream().map(e -> e.getOrderTaxMny() == null ? BigDecimal.ZERO : e.getOrderTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add));
            orderVO.setContractNoOrderMny(entityList.stream().map(e -> e.getOrderMny() == null ? BigDecimal.ZERO : e.getOrderMny()).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return CommonResponse.success("查询成功", orderVO);
    }



    @RequestMapping(value = "/pageGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageGFList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}",systemIdList);
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        IPage<OrderEntity> pageData= service.queryPage(param,false);

       JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OrderVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelGFExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelGFExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> cooperResponse = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",cooperResponse.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = cooperResponse.getData();
        logger.info("合作企业信息：{}",systemIdList);
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        List<OrderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<OrderVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,OrderVO.class);
            voList.forEach(c -> {
                if(null!=c.getDeliverState()){
                    switch (c.getDeliverState()){
                        case  0:c.setDeliverStateName("待送货");break;
                        case  1:c.setDeliverStateName("部分送货");break;
                        case  2:c.setDeliverStateName("已送货");break;
                    }
                }
                if(null!=c.getOrderFlag()){
                    switch (c.getOrderFlag()){
                        case  0:c.setOrderFlagName("正常");break;
                        case  1:c.setOrderFlagName("已关闭");break;
                    }
                }
                //流程状态
                c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("OrderGF-export.xlsx", beans, response);
    }
}
