package com.ejianc.business.promaterial.pricelib.controller.api;

import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/MaterialPriceHistoryApi/")
public class MaterialPriceHistoryApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceHistoryService priceHistoryService;

    @ApiOperation("查询单个物资历史价格")
    @GetMapping("getMaterialPriceHistoryApiVO")
    public CommonResponse<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVO(@RequestParam("materialId") Long materialId) {
        logger.info("物资id-{}", materialId);
        MaterialPriceHistoryApiVO priceHistoryApiVO = priceHistoryService.getMaterialPriceHistoryApiVO(materialId);
        return CommonResponse.success("查询成功！",priceHistoryApiVO);
    }
    @ApiOperation("查询多个个物资历史价格")
    @PostMapping("getMaterialPriceHistoryApiVOS")
    public CommonResponse<List<MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOS(@RequestBody List<Long> materialIds){
        logger.info("物资id集合【{}】", materialIds);
        List<MaterialPriceHistoryApiVO> priceHistoryApiVOS = priceHistoryService.getMaterialPriceHistoryApiVOS(materialIds);
        return CommonResponse.success("查询成功！",priceHistoryApiVOS);
    }

    @ApiOperation("查询多个个物资历史价格")
    @PostMapping("getMaterialPriceHistoryApiVOMap")
    public CommonResponse<Map<Long,MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOMap(@RequestBody List<Long> materialIds){
        logger.info("物资id集合【{}】", materialIds);
        Map<Long,MaterialPriceHistoryApiVO> priceHistoryVOMap = priceHistoryService.getMaterialPriceHistoryApiVOMap(materialIds);
        return CommonResponse.success("查询成功！",priceHistoryVOMap);
    }
}
