package com.ejianc.business.promaterial.pricelib.service.impl;

import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.pricelib.bean.PriceCheckEntity;
import com.ejianc.business.promaterial.pricelib.mapper.PriceCheckMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceCheckService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 价格库-验收明细
 * 
 * @author generator
 * 
 */
@Service("priceCheckService")
public class PriceCheckServiceImpl extends BaseServiceImpl<PriceCheckMapper, PriceCheckEntity> implements IPriceCheckService{
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 定时处理合同价格库明细
     * 如果传入日期为空，则为初始化，处理全部合同（已提交、审批通过）明细
     *
     * @param date 日期
     */
    @Override
    public void savePriceCheckByTiming(Date date) {
//        QueryParam queryParam = new QueryParam();
//        List<CheckEntity> checkEntityList;
//        if (date != null) {
//            // 日期不为空，则取大于上日日期数据
//            Date qDate = DateUtils.calculationDay(date, -1);
//            checkEntityList = baseMapper.getCheckListByTime(qDate);
//        }
//        else {
//            // 日期为空，默认为初始化，取提交后的数据
//            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//            checkEntityList = checkService.queryList(queryParam, false);
//        }
//        // 合同列表为空，不处理
//        if (CollectionUtils.isEmpty(checkEntityList))
//        {
//            return;
//        }
//        // 查询验收明细
//        List<Long> checkIdList = checkEntityList.stream().map(CheckEntity::getId).collect(Collectors.toList());
//        List<CheckDetailEntity> detailEntityList = baseMapper.getCheckDetailListByContractId(checkIdList);
//        // 合同明细列表为空，不处理
//        if (CollectionUtils.isEmpty(detailEntityList))
//        {
//            return;
//        }
//        // 查询材料内码
//        List<Long> materialTypeIdList = detailEntityList.stream().map(CheckDetailEntity::getMaterialTypeId)
//                .distinct().collect(Collectors.toList());
////        CommonResponse<List<MaterialCategoryVO>> materialResponse = materialApi
////                .queryCategoryListByIds(materialTypeIdList);
//        Map<Long, String> materialCategoryMap = new HashMap<>();
////        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(materialResponse));
////        if (materialResponse.isSuccess()) {
////            List<MaterialCategoryVO> materialCategoryVOList = materialResponse.getData();
////            materialCategoryMap = materialCategoryVOList.stream()
////                    .collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode,
////                            (key1, key2) -> key2));
////        }
//        logger.info("查询材料内码转map，转换结果：{}", JSONObject.toJSONString(materialCategoryMap));
//        // 材料明细按合同id分组
//        Map<Long, List<CheckDetailEntity>> detailMap = detailEntityList.stream().filter(map -> map.getMaterialId() != null)
//                .collect(Collectors.groupingBy(CheckDetailEntity::getCheckId));
//
//        //查询合同数据,匹配字段
//        List<Long> contractIdList = checkEntityList.stream().filter(map -> map.getContractId() != null).map(CheckEntity::getContractId).distinct().collect(Collectors.toList());
//
//        // 查询项目信息
//        List<Long> projectIdList = checkEntityList.stream().map(CheckEntity::getProjectId)
//                .distinct().collect(Collectors.toList());
////        CommonResponse<List<ProjectPoolDTO>> projectResponse = projectSetApi.getProjectListIds(projectIdList);
////        logger.info("查询项目地址，查询结果：{}", JSONObject.toJSONString(projectResponse));
//        Map<Long, String> projectAreaMap = new HashMap<>();
//        Map<Long, String> projectAreaNameMap = new HashMap<>();
//        if (projectResponse.isSuccess()) {
//            List<ProjectPoolDTO> projectPoolList = projectResponse.getData();
//            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getArea()))
//                    .collect(Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
//            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getAreaName()))
//                    .collect(Collectors
//                            .toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
//        }
//        //根据合同查询数据
//        Map<Long, ContractEntity> contractMap = null;
//        if (CollectionUtils.isNotEmpty(contractIdList)){
//            QueryWrapper<ContractEntity> queryContractWrapper = new QueryWrapper<>();
//            queryContractWrapper.in("id",contractIdList);
//            List<ContractEntity> contractList = contractService.list(queryContractWrapper);
//            contractMap = contractList.stream().collect(Collectors.toMap(ContractEntity::getId, Function.identity()));
//        }
//
//        // 进行插入数据组装
//        List<PriceCheckEntity> saveEntityList = new ArrayList<>();
//        for (CheckEntity entity : checkEntityList) {
//            List<CheckDetailEntity> entityDetailList = detailMap.get(entity.getId());
//            if (CollectionUtils.isEmpty(entityDetailList))
//            {
//                continue;
//            }
//            for (CheckDetailEntity detailEntity : entityDetailList) {
//                PriceCheckEntity priceCheckEntity = new PriceCheckEntity();
//                priceCheckEntity.setArea(projectAreaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
//                priceCheckEntity.setAreaName(projectAreaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
//                priceCheckEntity.setCheckCode(entity.getBillCode());
//                priceCheckEntity.setBillState(entity.getBillState());
//                priceCheckEntity.setProjectId(entity.getProjectId());
//                priceCheckEntity.setProjectName(entity.getProjectName());
//                priceCheckEntity.setProjectCode(entity.getProjectCode());
//                priceCheckEntity.setOrgId(entity.getOrgId());
//                priceCheckEntity.setOrgName(entity.getOrgName());
//                priceCheckEntity.setParentOrgId(entity.getParentOrgId());
//                priceCheckEntity.setParentOrgName(entity.getParentOrgName());
//                priceCheckEntity.setParentOrgCode(entity.getParentOrgCode());
//                priceCheckEntity.setSupplierId(entity.getSupplierId());
//                priceCheckEntity.setSupplierName(entity.getSupplierName());
//                priceCheckEntity.setCheckDate(entity.getCheckDate());
//                priceCheckEntity.setCheckDate(entity.getCheckDate());
//                priceCheckEntity.setSourceId(entity.getId());
//                priceCheckEntity.setSourceDetailId(detailEntity.getId());
//                if (entity.getContractId() == null){
//                    priceCheckEntity.setCheckType(1);
//                }
//                if (entity.getContractId() != null){
//                    priceCheckEntity.setCheckType(0);
//                }
//                if ((entity.getContractId() != null && contractMap.containsKey(entity.getContractId()))){
//                    ContractEntity contractEntity = contractMap.get(entity.getContractId());
//                    priceCheckEntity.setContractName(contractEntity.getContractName());
//                }
//                // 子表信息
//                priceCheckEntity.setMaterialId(detailEntity.getMaterialId());
//                priceCheckEntity.setMaterialCode(detailEntity.getMaterialCode());
//                priceCheckEntity.setMaterialName(detailEntity.getMaterialName());
//                priceCheckEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
//                priceCheckEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
//                priceCheckEntity.setInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId())); // 分类内码，查询获取
//                priceCheckEntity.setSpec(detailEntity.getSpec());
//                priceCheckEntity.setUnitId(detailEntity.getUnitId());
//                priceCheckEntity.setUnitName(detailEntity.getUnit());
////                priceCheckEntity.setBrand(detailEntity.getBrand());
//                priceCheckEntity.setCheckNum(detailEntity.getCheckNum());
//                priceCheckEntity.setCheckPrice(detailEntity.getCheckPrice());
//                priceCheckEntity.setCheckMny(detailEntity.getCheckMny());
//                priceCheckEntity.setCheckTaxRate(detailEntity.getTaxRate());
//                priceCheckEntity.setCheckTaxMny(detailEntity.getCheckTaxMny());
//                priceCheckEntity.setCheckTaxPrice(detailEntity.getCheckTaxPrice());
//                priceCheckEntity.setMemo(detailEntity.getMemo());
//                priceCheckEntity.setId(null);
//                priceCheckEntity.setCreateTime(null);
//                priceCheckEntity.setCreateUserCode(null);
//                priceCheckEntity.setUpdateTime(null);
//                priceCheckEntity.setUpdateUserCode(null);
//                priceCheckEntity.setDr(detailEntity.getDr());
//                priceCheckEntity.setOutFlag(OutFlagEnum.未移除.getCode());
//
//                saveEntityList.add(priceCheckEntity);
//            }
//        }
//        // 查询是否为修改
//        if (CollectionUtils.isEmpty(saveEntityList)) {
//            return;
//        }
//        List<Long> sourceDetailIdList = saveEntityList.stream().map(PriceCheckEntity::getSourceDetailId)
//                .collect(Collectors.toList());
//        // 查询数据库
//        QueryParam priceParam = new QueryParam();
//        priceParam.getParams().put("sourceDetailId", new Parameter(QueryParam.IN, sourceDetailIdList));
//        List<PriceCheckEntity> queryPriceList = super.queryList(priceParam, false);
//        if (CollectionUtils.isNotEmpty(queryPriceList)) {
//            // sourceDetailId,id
//            Map<Long, PriceCheckEntity> queryPriceMap = queryPriceList.stream()
//                    .collect(Collectors.toMap(PriceCheckEntity::getSourceDetailId, Function.identity(),
//                            (key1, key2) -> key2));
//            for (PriceCheckEntity entity : saveEntityList) {
//                PriceCheckEntity queryEntity = queryPriceMap.get(entity.getSourceDetailId());
//                if (queryEntity != null) {
//                    entity.setId(queryEntity.getId());
//                }
//            }
//        }
//        // 批量变更保存数据
//        super.saveOrUpdateBatch(saveEntityList);
//        // 删除bill_state非1和3的数据
//        QueryWrapper<PriceCheckEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.notIn("bill_state",BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
//        baseMapper.delete(queryWrapper);
    }
}
