/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
@Api(value="\u6d88\u8017\u6750-\u9a8c\u6536\u4e3b\u8868", tags={"\u6d88\u8017\u6750-\u9a8c\u6536\u4e3b\u8868"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XHC-CHECK-CODE";
    private static final String BILL_TYPE = "BT220215000000006";
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/check/card";
    @Autowired
    private ICheckService service;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    ICommonBusinessService check;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckVO vo = this.service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        this.service.deletes(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private ComplexParam getPageQueryParam(List<String> supState) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c3.getParams().put("changState", new Parameter("in", supState));
        c1.getComplexParams().add(c3);
        return c1;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/refCheckData"})
    @ResponseBody
    public CommonResponse<JSONObject> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText) {
        QueryWrapper wrapper;
        Page page;
        List<CheckVO> list;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("materialName");
        fuzzyFields.add("specif");
        fuzzyFields.add("brand");
        fuzzyFields.add("unit");
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        if (StringUtils.isNotEmpty((CharSequence)condition) && JSONObject.parseObject((String)condition).containsKey((Object)"gfSupplierId")) {
            CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        } else {
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("contract_id", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.containsKey((Object)"accountFlag")) {
                param.getParams().put("account_flag", new Parameter("eq", _con.get((Object)"accountFlag")));
            }
            if (_con.containsKey((Object)"settleFlag")) {
                param.getParams().put("settle_flag", new Parameter("eq", _con.get((Object)"settleFlag")));
            }
        }
        if (CollectionUtils.isNotEmpty(list = this.service.getCheckReturns((Page<CheckVO>)(page = new Page((long)param.getPageIndex(), (long)param.getPageSize())), wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param)))) {
            ArrayList checkIds = new ArrayList();
            ArrayList<Long> returnIds = new ArrayList<Long>();
            list.forEach(e -> {
                if (0 == e.getReturnGoodsFlag()) {
                    checkIds.add(e.getId());
                } else {
                    returnIds.add(e.getId());
                }
            });
            Map<Object, Object> map = new HashMap();
            ArrayList<CheckDetailVO> listRes = new ArrayList<CheckDetailVO>();
            if (CollectionUtils.isNotEmpty(checkIds)) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(CheckDetailEntity::getCheckId, checkIds);
                List detailEntityList = this.checkDetailService.list((Wrapper)lambda);
                listRes.addAll(BeanMapper.mapList((Iterable)detailEntityList, CheckDetailVO.class));
            }
            if (CollectionUtils.isNotEmpty(returnIds)) {
                List<CheckDetailVO> details = this.service.getReturnDetails(returnIds);
                listRes.addAll(details);
            }
            if (CollectionUtils.isNotEmpty(listRes)) {
                map = listRes.stream().collect(Collectors.groupingBy(CheckDetailVO::getCheckId));
            }
            for (CheckVO e2 : list) {
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)map.get(e2.getId())))) continue;
                e2.setCheckDetailList(BeanMapper.mapList((Iterable)((Iterable)map.get(e2.getId())), CheckDetailVO.class));
            }
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @GetMapping(value={"/checkDetailsRef"})
    @ResponseBody
    public CommonResponse<JSONObject> checkDetailsRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("materialName");
        fuzzyFields.add("specif");
        fuzzyFields.add("brand");
        fuzzyFields.add("unit");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        queryParam.getParams().put("contractId", new Parameter("eq", conditionMap.get("contractId")));
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<CheckDetailVO> list = this.service.getCheckDetails((Page<CheckDetailVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/pageGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageGFList(@RequestBody QueryParam param) {
        CommonResponse commonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), CheckVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelGFExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelGFExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse commonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        CommonResponse cooperResponse = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)cooperResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)cooperResponse.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, CheckVO.class);
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("CheckGF-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u66f4\u65b0\u4f9b\u5e94\u5546\u81ea\u5df1\u72b6\u6001")
    @RequestMapping(value={"/updateChangState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> close(@RequestParam Long id, @RequestParam String changState) {
        this.service.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"id", (Object)id)).set((Object)"chang_state", (Object)changState));
        return CommonResponse.success((String)"\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/deleteGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteGF(@RequestBody List<CheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = (CheckEntity)((Object)this.service.selectById(checkVO.getId()));
        if ("1".equals(checkEntity.getSourceType())) {
            throw new BusinessException("\u91c7\u8d2d\u65b9\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        if (!"free".equals(checkEntity.getChangState()) && !"returned".equals(checkEntity.getChangState())) {
            throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u751f\u6548\u7684\u9a8c\u6536\u5355!");
        }
        this.service.deletes(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ComplexParam getGFPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @ApiOperation(value="\u4f9b\u65b9\u63d0\u4ea4\u6216\u8005\u91c7\u8d2d\u65b9\u9a73\u56de")
    @RequestMapping(value={"/submitGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody CheckVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        updateWrapper.set(CheckEntity::getChangState, (Object)saveOrUpdateVO.getChangState());
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getReturnReason())) {
            updateWrapper.set(CheckEntity::getReturnReason, (Object)saveOrUpdateVO.getReturnReason());
        }
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

