/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XHC-CHECK-CODE";

    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO) {
        List checkEntityList;
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"delivery_id", (Object)saveOrUpdateVO.getDeliveryId())).notIn((Object)"bill_state", Arrays.asList(1, 3));
        if (null != saveOrUpdateVO.getId()) {
            queryWrapper.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkEntityList = super.list((Wrapper)queryWrapper))) && checkEntityList.size() > 0) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u9001\u8d27\u5355\u6709\u672a\u751f\u6548\u7684\u9a8c\u6536\u5355");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSettleFlag(0);
        entity.setAccountFlag(0);
        super.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(CheckEntity::getProjectId, (Object)projectId)).eq(CheckEntity::getCheckDate, (Object)checkDate);
        int checkCount = super.count((Wrapper)lambdaQuery);
        resultMap.put("\u6d88\u8017\u6750", checkCount);
        return resultMap;
    }

    @Override
    public List<CheckDetailVO> getCheckDetails(Page<CheckDetailVO> page, QueryWrapper wrapper) {
        return ((CheckMapper)this.baseMapper).getCheckDetails(page, wrapper);
    }

    @Override
    public List<CheckVO> getCheckReturns(Page<CheckVO> page, QueryWrapper wrapper) {
        return ((CheckMapper)this.baseMapper).getCheckReturns(page, wrapper);
    }

    @Override
    public List<CheckDetailVO> getReturnDetails(List<Long> returnIds) {
        return ((CheckMapper)this.baseMapper).getReturnDetails(returnIds);
    }
}

