/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"delivery"})
@Api(value="\u6d88\u8017\u6750-\u53d1\u8d27\u5355", tags={"\u6d88\u8017\u6750-\u53d1\u8d27\u5355"})
public class DeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XHC-DELIVERY-CODE";
    @Autowired
    private IDeliveryService service;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(@RequestParam Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.service.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u53d1\u8d27\u5355\u5173\u95ed\u63a5\u53e3")
    @RequestMapping(value={"/closeDelivery"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> closeDelivery(@RequestParam Long id) {
        DeliveryVO vo = this.service.closeDelivery(id);
        return CommonResponse.success((String)"\u53d1\u8d27\u5355\u5173\u95ed\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO deliveryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u65b9\u5f85\u9a8c\u6536\u5217\u8868")
    @RequestMapping(value={"/queryCGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryCGFList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orderBillCode");
        fuzzyFields.add("deliverName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("deliveryNum");
        fuzzyFields.add("customerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List deliveryVOS = BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class);
        pageData.setRecords(deliveryVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        CommonResponse commonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orderBillCode");
        fuzzyFields.add("deliverName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("deliveryNum");
        fuzzyFields.add("customerName");
        CommonResponse response = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)response.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List deliveryVOS = BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class);
        pageData.setRecords(deliveryVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse commonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orderBillCode");
        fuzzyFields.add("deliverName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("deliveryNum");
        fuzzyFields.add("customerName");
        CommonResponse cooperResponse = this.cooperateEnterpriseApi.getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)cooperResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        List systemIdList = (List)cooperResponse.getData();
        this.logger.info("\u5408\u4f5c\u4f01\u4e1a\u4fe1\u606f\uff1a{}", (Object)systemIdList);
        if (CollectionUtils.isNotEmpty((Collection)systemIdList)) {
            param.getParams().put("tenant_id", new Parameter("in", (Object)systemIdList));
        }
        if (!(commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid())).isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, DeliveryVO.class);
            voList.forEach(c -> {
                if (null != c.getDeliverState()) {
                    switch (c.getDeliverState()) {
                        case 0: {
                            c.setDeliverStateName("\u5f85\u9001\u8d27");
                            break;
                        }
                        case 1: {
                            c.setDeliverStateName("\u90e8\u5206\u9001\u8d27");
                            break;
                        }
                        case 2: {
                            c.setDeliverStateName("\u5df2\u9001\u8d27");
                        }
                    }
                }
                if (null != c.getOrderFlag()) {
                    switch (c.getOrderFlag()) {
                        case 0: {
                            c.setOrderFlagName("\u6b63\u5e38");
                            break;
                        }
                        case 1: {
                            c.setOrderFlagName("\u5df2\u5173\u95ed");
                        }
                    }
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u9001\u8d27\u5355\u8be6\u60c5")
    @RequestMapping(value={"/queryInitDelivery"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryInitDelivery(@RequestBody OrderVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u6210\u529f\uff01", (Object)this.service.queryInitDelivery(saveOrUpdateVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5(\u9a8c\u6536\u7528)")
    @RequestMapping(value={"/queryDetailToCheck"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailToCheck(@RequestParam Long id) {
        CheckVO vo = this.service.queryDetailToCheck(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

