/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.pricelib.service.impl;

import com.ejianc.business.promaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.promaterial.pricelib.bean.PriceHistoryEntity;
import com.ejianc.business.promaterial.pricelib.mapper.PriceHistoryMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.promaterial.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.HistoryTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceHistoryVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceHistoryService")
public class PriceHistoryServiceImpl
extends BaseServiceImpl<PriceHistoryMapper, PriceHistoryEntity>
implements IPriceHistoryService {
    private static final String PRICE_CHECK_CODE = "";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initPriceHistory() {
        this.logger.info("---\u5386\u53f2\u4ef7\u683cinit\u5f00\u59cb---");
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u7ed3\u675f---");
    }

    public void duplicates(Map<String, PriceHistoryVO> oldMap, Map<String, PriceHistoryVO> nowMap) {
        if (!oldMap.isEmpty()) {
            for (String s : nowMap.keySet()) {
                if (!oldMap.containsKey(s)) continue;
                oldMap.remove(s);
            }
        }
        oldMap.putAll(nowMap);
    }

    public Date getMonthBefore(Date nowTime, BigDecimal num) {
        if (null == num) {
            num = new BigDecimal(0);
        }
        int month = num.intValue();
        Date beforeDate = DateUtil.subMonths((Date)nowTime, (int)month);
        return beforeDate;
    }

    @Override
    public MaterialPriceHistoryApiVO getMaterialPriceHistoryApiVO(Long materialId) {
        PriceHistoryEntity priceHistoryEntity = (PriceHistoryEntity)((Object)super.selectById((Serializable)materialId));
        if (priceHistoryEntity == null) {
            return new MaterialPriceHistoryApiVO();
        }
        MaterialPriceHistoryApiVO vo = (MaterialPriceHistoryApiVO)BeanMapper.map((Object)((Object)priceHistoryEntity), MaterialPriceHistoryApiVO.class);
        HashMap<Long, MaterialPriceHistoryApiVO> guidePriceMap = new HashMap<Long, MaterialPriceHistoryApiVO>();
        guidePriceMap.put(materialId, vo);
        this.queryPriceGuide(guidePriceMap);
        if (HistoryTypeEnum.\u5408\u540c\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
            vo.setHistoryPriceArea(vo.getContractPriceArea());
            vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
        } else if (HistoryTypeEnum.\u7ed3\u7b97\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
            vo.setHistoryPriceArea(vo.getSettlePriceArea());
            vo.setHistoryTaxPriceArea(vo.getSettleTaxPriceArea());
        } else if (HistoryTypeEnum.\u9a8c\u6536\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
            vo.setHistoryPriceArea(vo.getCheckPriceArea());
            vo.setHistoryTaxPriceArea(vo.getCheckTaxPriceArea());
        }
        String guidePriceArea = ((MaterialPriceHistoryApiVO)guidePriceMap.get(vo.getMaterialId())).getGuidePriceArea() == null ? PRICE_CHECK_CODE : ((MaterialPriceHistoryApiVO)guidePriceMap.get(vo.getMaterialId())).getGuidePriceArea();
        vo.setGuidePriceArea(guidePriceArea);
        vo.setGuideTaxPriceArea(guidePriceArea);
        return vo;
    }

    @Override
    public Map<Long, MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOMap(List<Long> materialIds) {
        Map<Long, Object> map = new HashMap<Long, MaterialPriceHistoryApiVO>();
        if (CollectionUtils.isEmpty(materialIds)) {
            return map;
        }
        List<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = this.getMaterialPriceHistoryApiVOS(materialIds);
        if (CollectionUtils.isEmpty(materialPriceHistoryApiVOS)) {
            return map;
        }
        map = materialPriceHistoryApiVOS.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity(), (key1, key2) -> key2));
        return map;
    }

    @Override
    public List<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOS(List<Long> materialIds) {
        if (CollectionUtils.isEmpty(materialIds)) {
            return new ArrayList<MaterialPriceHistoryApiVO>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", materialIds));
        List priceHistoryList = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)priceHistoryList)) {
            return new ArrayList<MaterialPriceHistoryApiVO>();
        }
        List historyApiVOS = BeanMapper.mapList((Iterable)priceHistoryList, MaterialPriceHistoryApiVO.class);
        if (CollectionUtils.isNotEmpty((Collection)priceHistoryList)) {
            Map<Long, MaterialPriceHistoryApiVO> guidePriceMap = historyApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
            this.queryPriceGuide(guidePriceMap);
            for (MaterialPriceHistoryApiVO vo : historyApiVOS) {
                if (HistoryTypeEnum.\u5408\u540c\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
                    vo.setHistoryPriceArea(vo.getContractPriceArea());
                    vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
                } else if (HistoryTypeEnum.\u7ed3\u7b97\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
                    vo.setHistoryPriceArea(vo.getSettlePriceArea());
                    vo.setHistoryTaxPriceArea(vo.getSettleTaxPriceArea());
                } else if (HistoryTypeEnum.\u9a8c\u6536\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
                    vo.setHistoryPriceArea(vo.getCheckPriceArea());
                    vo.setHistoryTaxPriceArea(vo.getCheckTaxPriceArea());
                }
                String guidePriceArea = guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea() == null ? PRICE_CHECK_CODE : guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea();
                vo.setGuidePriceArea(guidePriceArea);
                vo.setGuideTaxPriceArea(guidePriceArea);
            }
        }
        return historyApiVOS;
    }

    private void queryPriceGuide(Map<Long, MaterialPriceHistoryApiVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, MaterialPriceHistoryApiVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            MaterialPriceHistoryApiVO vo = entry.getValue();
            if (!guideMap.containsKey(materialId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(materialId));
            BigDecimal min = guide.getMinMny() == null ? BigDecimal.ZERO : guide.getMinMny();
            BigDecimal max = guide.getMaxMny() == null ? BigDecimal.ZERO : guide.getMaxMny();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }

    @Override
    public Boolean historyPriceShow(Integer priceCheckType) {
        Boolean flag = true;
        return flag;
    }
}

