/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.reconciliation.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.mapper.ReconciliationMapper;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

@Service(value="reconciliationService")
public class ReconciliationServiceImpl
extends BaseServiceImpl<ReconciliationMapper, ReconciliationEntity>
implements IReconciliationService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String OPERATE = "SETTLMENT_JS";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/reconciliation/saveReconciliation";
    private static final String XHC_BILL_TYPE = "BT220310000000001";
    private static final String HNT_BILL_TYPE = "BT220316000000003";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void checkContract(ReconciliationEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            if (CollectionUtils.isEmpty(contractDetailList)) {
                throw new BusinessException("\u5bf9\u8d26\u660e\u7ec6\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u5bf9\u8d26");
            }
            List materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialId().toString()).collect(Collectors.toList());
            List materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialTypeId().toString()).collect(Collectors.toList());
            for (ReconciliationDetailEntity detail : entity.getDetailList()) {
                String materialId;
                if ("del".equals(detail.getRowState())) continue;
                boolean flag = true;
                String materialTypeId = detail.getMaterialTypeId() == null ? "" : detail.getMaterialTypeId().toString();
                String string = materialId = detail.getMaterialId() == null ? "" : detail.getMaterialId().toString();
                if (materialTypeIds.contains(materialTypeId)) {
                    flag = false;
                }
                if (materialIds.contains(materialId)) {
                    flag = false;
                }
                if (!flag) continue;
                throw new BusinessException("\u6750\u6599\u3010" + detail.getMaterialName() + "\u3011\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u5bf9\u8d26");
            }
        }
    }

    @Override
    public IPage<ReconciliationVO> queryData(QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ReconciliationVO> list = ((ReconciliationMapper)this.baseMapper).queryData((QueryWrapper<Object>)ReconciliationServiceImpl.changeToQueryWrapper((QueryParam)param), (IPage<ReconciliationVO>)page);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }
}

