/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckDetailService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/check/"})
public class CheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IConcreteCheckService concreteCheckService;
    @Autowired
    private IConcreteCheckDetailService concreteCheckDetailService;

    @ApiOperation(value="\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u9a8c\u6536\u5355\u8be6\u60c5")
    @RequestMapping(value={"/queryCheckByDetailId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryCheckByDetailId(@RequestParam(value="detailId") Long detailId) {
        this.logger.info("\u7269\u8d44\u660e\u7ec6id\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)detailId);
        CheckEntity checkEntity = new CheckEntity();
        CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)this.checkDetailService.getById(detailId));
        if (null != checkDetailEntity) {
            checkEntity = (CheckEntity)((Object)this.checkService.selectById(checkDetailEntity.getCheckId()));
        }
        this.logger.info("\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u9a8c\u6536\u5355\u8be6\u60c5\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)checkEntity)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class));
    }

    @ApiOperation(value="\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u6df7\u51dd\u571f\u9a8c\u6536\u5355\u8be6\u60c5")
    @RequestMapping(value={"/queryConcreteCheckByDetailId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryConcreteCheckByDetailId(@RequestParam(value="detailId") Long detailId) {
        this.logger.info("\u7269\u8d44\u660e\u7ec6id\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)detailId);
        ConcreteCheckEntity concreteCheckEntity = new ConcreteCheckEntity();
        ConcreteCheckDetailEntity concreteCheckDetailEntity = (ConcreteCheckDetailEntity)((Object)this.concreteCheckDetailService.getById(detailId));
        if (null != concreteCheckDetailEntity) {
            concreteCheckEntity = (ConcreteCheckEntity)((Object)this.concreteCheckService.selectById(concreteCheckDetailEntity.getCheckId()));
        }
        this.logger.info("\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u9a8c\u6536\u5355\u8be6\u60c5\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)concreteCheckEntity)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.map((Object)((Object)concreteCheckEntity), ConcreteCheckVO.class));
    }

    @ApiOperation(value="\u6839\u636e \u9879\u76ee\u548c\u6536\u6b3e\u5355\u4f4d \u67e5\u8be2\u65e0\u5408\u540c \u5df2\u751f\u6548\u7684 \u6750\u6599\u9a8c\u6536\u5165\u5e93\u5355 \u9a8c\u6536\u91d1\u989d\u4e4b\u548c")
    @RequestMapping(value={"/querycheckMnyById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> querycheckMnyById(@RequestParam(value="projectId") Long projectId, @RequestParam(value="supplierId") Long supplierId) {
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u53c2\u6570\uff1a{} , \u6536\u6b3e\u5355\u4f4d", (Object)projectId, (Object)supplierId);
        List list = this.checkService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).eq((Object)"supplier_id", (Object)supplierId)).in((Object)"bill_state", new Object[]{1, 3})).isNull((Object)"contract_id"));
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            checkTaxMny = list.stream().map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("checkTaxMny", (Object)checkTaxMny);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)jsonObject);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }

    @ApiOperation(value="\u6839\u636e \u9879\u76ee\u65e0\u5408\u540c\u6240\u6709\u72b6\u6001\u4e0b\u6750\u6599\u3001\u6df7\u51dd\u571f\u9a8c\u6536 \u9a8c\u6536\u91d1\u989d\u4e4b\u548c")
    @RequestMapping(value={"/queryCheckMnyProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryCheckMnyProjectId(@RequestParam(value="projectId") Long projectId) {
        BigDecimal reduce;
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u53c2\u6570\uff1a{}", (Object)projectId);
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.isNull(CheckEntity::getContractId);
        wrapper.eq(CheckEntity::getProjectId, (Object)projectId);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.isNull(ConcreteCheckEntity::getContractId);
        wrapper2.eq(ConcreteCheckEntity::getProjectId, (Object)projectId);
        List list = this.checkService.list((Wrapper)wrapper);
        List list2 = this.concreteCheckService.list((Wrapper)wrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            reduce = list.stream().map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.logger.info("\u6d88\u8017\u6750\u91d1\u989d\uff1a{}", (Object)reduce);
            checkTaxMny = ComputeUtil.safeAdd((BigDecimal)reduce, (BigDecimal)checkTaxMny);
        }
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            reduce = list2.stream().map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.logger.info("\u6df7\u51dd\u571f\u91d1\u989d\uff1a{}", (Object)reduce);
            checkTaxMny = ComputeUtil.safeAdd((BigDecimal)reduce, (BigDecimal)checkTaxMny);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("checkTaxMny", (Object)checkTaxMny);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)jsonObject);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }

    @ApiOperation(value="\u6839\u636e\u9879\u76eeid\u3001\u9a8c\u6536\u65e5\u671f\u67e5\u8be2\u6d88\u8017\u6750\u3001\u6df7\u51dd\u571f\u5355\u636e\u6570\u91cf")
    @PostMapping(value={"/countBillNum"})
    public CommonResponse<Map<String, Integer>> countBillNum(@RequestBody JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"projectId")) {
            throw new BusinessException("\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!jsonObject.containsKey((Object)"fillDate")) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.checkService.countBillNum(jsonObject.getLong("projectId"), jsonObject.getDate("fillDate")));
    }

    @ApiOperation(value="\u6839\u636e \u9879\u76ee \u67e5\u8be2\u65e0\u5408\u540c \u5df2\u751f\u6548\u7684 \u6750\u6599\u9a8c\u6536\u5165\u5e93\u5355 ")
    @RequestMapping(value={"/querycheckListByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CheckVO>> querycheckListByProjectId(@RequestParam(value="projectId") Long projectId) {
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u53c2\u6570\uff1a{} ", (Object)projectId);
        List list = this.checkService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).in((Object)"bill_state", new Object[]{1, 3})).isNull((Object)"contract_id"));
        List checkVOS = BeanMapper.mapList((Iterable)list, CheckVO.class);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)checkVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)checkVOS);
    }

    @ApiOperation(value="\u6839\u636e \u9879\u76ee \u67e5\u8be2\u65e0\u5408\u540c \u5df2\u751f\u6548\u7684 \u6750\u6599\u9a8c\u6536\u5165\u5e93\u5355 \u9a8c\u6536\u91d1\u989d\u4e4b\u548c")
    @RequestMapping(value={"/querycheckMnyByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> querycheckMnyByProjectId(@RequestParam(value="projectId") Long projectId) {
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u53c2\u6570\uff1a{} ", (Object)projectId);
        List list = this.checkService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).in((Object)"bill_state", new Object[]{1, 3})).isNull((Object)"contract_id"));
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            checkTaxMny = list.stream().map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("checkTaxMny", (Object)checkTaxMny);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)jsonObject);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }
}

