/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckImgDetailEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.order.service.IConcreteOrderDetailService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="concreteCheck")
public class ConcreteCheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IConcreteCheckService concreteCheckService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IConcreteOrderDetailService concreteOrderDetailService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/concreteCheck/deleteCheck";
    private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/concreteCheck/saveCheck";
    private static final String BILL_TYPE = "BT220224000000004";
    private static final String BILL_CODE = "HNT-CHECK";
    private final String OPERATE = "HNT_CHECK_SYNC";
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        String checkRs;
        ConcreteCheckEntity e = (ConcreteCheckEntity)((Object)this.concreteCheckService.selectById(billId));
        ElectronicFenceConfigEntity electronicFenceConfig = this.electronicFenceConfigService.getOneByProjectId(e.getProjectId(), true);
        if (null != electronicFenceConfig && Integer.valueOf(1).equals(electronicFenceConfig.getEnable()) && StringUtils.isNotBlank((CharSequence)(checkRs = this.checkHasAbnormalImg(e)))) {
            return CommonResponse.error((String)checkRs);
        }
        return CommonResponse.success();
    }

    private String checkHasAbnormalImg(ConcreteCheckEntity e) {
        if (CollectionUtils.isNotEmpty((Collection)e.getConcreteCheckImgList().stream().filter(item -> Integer.valueOf(0).equals(item.getAbnormalImgFlag())).collect(Collectors.toList()))) {
            return "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9a8c\u6536\u5355\u5b58\u5728\u5f02\u5e38\u7167\u7247\uff01";
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(e.getId(), null, "sceneImgs", null);
        if (!fileResp.isSuccess()) {
            return "\u83b7\u53d6\u4e0a\u4f20\u56fe\u7247\u5217\u8868\u5931\u8d25\uff0c\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        List attachs = (List)fileResp.getData();
        if (!CollectionUtils.isNotEmpty((Collection)attachs)) {
            List imgIds = attachs.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            List<ConcreteCheckImgDetailEntity> imgList = e.getConcreteCheckImgList();
            if (CollectionUtils.isEmpty(imgList)) {
                return "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9a8c\u6536\u5355\u5b58\u5728\u5f02\u5e38\u7167\u7247\uff01";
            }
            List detailImgIds = imgList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            imgIds.removeAll(detailImgIds);
            if (CollectionUtils.isNotEmpty(imgIds)) {
                return "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9a8c\u6536\u5355\u5b58\u5728\u5f02\u5e38\u7167\u7247\uff01";
            }
        }
        return null;
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String checkRs;
        ElectronicFenceConfigEntity electronicFenceConfig;
        ConcreteCheckEntity concreteCheckEntity = (ConcreteCheckEntity)((Object)this.concreteCheckService.selectById(billId));
        concreteCheckEntity.setCheckState(1);
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && null != (electronicFenceConfig = this.electronicFenceConfigService.getOneByProjectId(concreteCheckEntity.getProjectId(), true)) && Integer.valueOf(1).equals(electronicFenceConfig.getEnable()) && StringUtils.isNotBlank((CharSequence)(checkRs = this.checkHasAbnormalImg(concreteCheckEntity)))) {
            return CommonResponse.error((String)checkRs);
        }
        SupplierPushCheckVO supplierPushCheckVO = (SupplierPushCheckVO)BeanMapper.map((Object)((Object)concreteCheckEntity), SupplierPushCheckVO.class);
        supplierPushCheckVO.setSourceId(concreteCheckEntity.getId());
        List<ConcreteCheckDetailEntity> concreteCheckDetailList = concreteCheckEntity.getConcreteCheckDetailList();
        List supplierPushCheckDetailVOS = BeanMapper.mapList(concreteCheckDetailList, SupplierPushCheckDetailVO.class);
        supplierPushCheckVO.setCheckDetailList(supplierPushCheckDetailVOS);
        List checkDetailList = supplierPushCheckVO.getConcreteCheckDetailList();
        for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
            supplierPushCheckDetailVO.setSourceId(concreteCheckEntity.getId());
            supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
            supplierPushCheckDetailVO.setId(null);
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        } else {
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE, (Object)cooperateResp.getMsg());
            } else {
                boolean b = this.checkService.pushBillToSupCenter(dataInfo, concreteCheckEntity.getSupplierId(), concreteCheckEntity.getId(), BILL_TYPE, (CooperateVO)cooperateResp.getData(), "/ejc-supbusiness-web/openapi/concreteCheck/saveCheck");
                if (!b) {
                    this.logger.error("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)dataInfo);
                } else {
                    concreteCheckEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                }
            }
        }
        this.concreteCheckService.updateById((Object)concreteCheckEntity);
        if (concreteCheckEntity.getAttrFlag().equals(1)) {
            this.logger.info("\u63a8\u9001\u6210\u672c---");
            this.concreteCheckService.costPush(concreteCheckEntity);
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(concreteCheckEntity.getStoreId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        storeManageVO.setSourceId(concreteCheckEntity.getId());
        ArrayList flowVOS = new ArrayList();
        concreteCheckEntity.getConcreteCheckDetailList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93, (Integer)0);
            this.getFlow(concreteCheckEntity, (ConcreteCheckDetailEntity)((Object)t), flowVO, "\u6df7\u51dd\u571f\u9a8c\u6536");
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        ArrayList flowOutS = new ArrayList();
        concreteCheckEntity.getConcreteCheckDetailList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u51fa\u5e93, (Integer)0);
            this.getFlow(concreteCheckEntity, (ConcreteCheckDetailEntity)((Object)t), flowVO, "\u6df7\u51dd\u571f\u51fa\u5e93");
            flowOutS.add(flowVO);
        });
        storeManageVO.setStraightOutFlowVOList(flowOutS);
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u6df7\u51dd\u571f\u76f4\u5165\u76f4\u51fa\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
        }
        return CommonResponse.success();
    }

    private void getFlow(ConcreteCheckEntity concreteCheckEntity, ConcreteCheckDetailEntity t, FlowVO flowVO, String type) {
        flowVO.setProjectId(concreteCheckEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(concreteCheckEntity.getProjectName());
        flowVO.setParentOrgId(concreteCheckEntity.getParentOrgId());
        flowVO.setParentOrgName(concreteCheckEntity.getParentOrgName());
        flowVO.setOrgId(concreteCheckEntity.getOrgId());
        flowVO.setOrgName(concreteCheckEntity.getOrgName());
        flowVO.setStoreId(concreteCheckEntity.getStoreId());
        flowVO.setStoreName(concreteCheckEntity.getStoreName());
        flowVO.setEmployeeId(concreteCheckEntity.getEmployeeId());
        flowVO.setEmployeeName(concreteCheckEntity.getEmployeeName());
        flowVO.setMaterialType(concreteCheckEntity.getCheckType());
        flowVO.setMaterialTypeName(concreteCheckEntity.getCheckType());
        flowVO.setSupplierId(concreteCheckEntity.getSupplierId());
        flowVO.setSupplierName(concreteCheckEntity.getSupplierName());
        flowVO.setPurchaseContractId(concreteCheckEntity.getContractId());
        flowVO.setPurchaseContractName(concreteCheckEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setTaxPrice(t.getCheckTaxPriceOverall() == null ? t.getCheckTaxPrice() : t.getCheckTaxPriceOverall());
        flowVO.setPrice(t.getCheckPriceOverall() == null ? t.getCheckPrice() : t.getCheckPriceOverall());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(concreteCheckEntity.getSubSupplierId());
        flowVO.setPickUnitName(concreteCheckEntity.getSubSupplierName());
        flowVO.setPickContractId(concreteCheckEntity.getSubContractId());
        flowVO.setPickContractName(concreteCheckEntity.getSubContractName());
        flowVO.setSourceId(concreteCheckEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(concreteCheckEntity.getBillCode());
        flowVO.setSourceBillDate(concreteCheckEntity.getCheckDate());
        flowVO.setSourceBillRemark(concreteCheckEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setRowState(t.getRowState());
        flowVO.setAdmixtureId(t.getAdmixtureId());
        flowVO.setAdmixtureName(t.getAdmixtureName());
        flowVO.setMaterialType("contractConcrete-1");
        flowVO.setMaterialTypeName("\u6df7\u51dd\u571f\u5408\u540c");
        flowVO.setSourceBillTypeName(type);
        flowVO.setSourceBillTypeCode(BILL_TYPE);
        flowVO.setSourceType(concreteCheckEntity.getSourceType());
        flowVO.setPickType(concreteCheckEntity.getSubOutType());
        if (concreteCheckEntity.getSubOutType() != null && concreteCheckEntity.getSubOutType() == 1) {
            flowVO.setPickTypeName("\u5185\u90e8\u9886\u6599");
        }
        if (concreteCheckEntity.getSubOutType() != null && concreteCheckEntity.getSubOutType() == 2) {
            flowVO.setPickTypeName("\u5206\u5305\u9886\u6599");
        }
        if (concreteCheckEntity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(concreteCheckEntity.getContractId()));
            Map DetailMaterialIdMap = contractEntity.getContractDetailList().stream().filter(e -> null != e.getMaterialId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity(), (k1, k2) -> k2));
            Map DetailMaterialIdTypeMap = contractEntity.getContractDetailList().stream().filter(e -> null == e.getMaterialId() && null != e.getMaterialTypeId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity(), (k1, k2) -> k2));
            if (MapUtils.isEmpty(DetailMaterialIdMap)) {
                DetailMaterialIdMap = new HashMap();
            }
            if (MapUtils.isEmpty(DetailMaterialIdTypeMap)) {
                DetailMaterialIdTypeMap = new HashMap();
            }
            ContractDetailEntity contractDetailEntity = new ContractDetailEntity();
            contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdMap.get(t.getMaterialId()));
            if (null != contractDetailEntity) {
                flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                flowVO.setContractPrice(contractDetailEntity.getPrice());
            } else {
                contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdTypeMap.get(t.getMaterialTypeId()));
                if (null != contractDetailEntity) {
                    flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    flowVO.setContractPrice(contractDetailEntity.getPrice());
                } else {
                    flowVO.setContractTaxPrice(BigDecimal.ZERO);
                    flowVO.setContractPrice(BigDecimal.ZERO);
                }
            }
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        ConcreteCheckEntity concreteCheckEntity = (ConcreteCheckEntity)((Object)this.concreteCheckService.selectById(billId));
        if (concreteCheckEntity.getSignStatus() == 1) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response;
        String stringInfo;
        StoreManageVO storeManageVO;
        ArrayList<Long> ids;
        ConcreteCheckEntity checkEntity = (ConcreteCheckEntity)((Object)this.concreteCheckService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9a8c\u6536\u5355Id---{}", (Object)checkEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.updateCostDetail(checkEntity.getId(), Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(ConcreteCheckEntity::getRelationFlag, (Object)"0");
        this.concreteCheckService.update((Wrapper)updateWrapper);
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(checkEntity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/concreteCheck/deleteCheck", RequestMethod.POST, checkEntity.getSupplierId().toString(), "HNT_CHECK_SYNC", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            checkEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.concreteCheckService.saveOrUpdate((Object)checkEntity, false);
        }
        if (checkEntity.getStoreType() == 0) {
            ids = new ArrayList<Long>();
            ids.add(billId);
            storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(checkEntity.getStoreId());
            storeManageVO.setSourceId(checkEntity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6df7\u51dd\u571f\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
            response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
            this.logger.info("hnt\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        }
        if (checkEntity.getStoreType() == 1) {
            ids = new ArrayList();
            ids.add(billId);
            storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(checkEntity.getStoreId());
            storeManageVO.setSourceId(checkEntity.getId());
            storeManageVO.setSourceIdsForRollBack(ids);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6df7\u51dd\u571f\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
            response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
            this.logger.info("hnt\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        }
        return CommonResponse.success();
    }
}

