/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractChangeAsyncService;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChange")
public class ContractChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IContractChangeAsyncService contractChangeAsyncService;
    @Autowired
    private IContractChangeService contractChangeService;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        Boolean commitState = false;
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType())) {
            CommonResponse<String> rsp = this.contractChangeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
            if (!rsp.isSuccess()) {
                throw new BusinessException("\u5ba1\u6279\u56de\u5199\u5931\u8d25!\u5931\u8d25\u539f\u56e0\uff1a" + rsp.getMsg());
            }
        } else {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
            contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.contractChangeService.asyncWatermarkById(billId);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractChangeEntity contractChangeEntity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractChangeEntity.getChangeDraftType()) && !statusList.contains(contractChangeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractChangeEntity.getChangeDraftType()) && SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractChangeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractChangeEntity.getSignatureStatus())) {
            contractChangeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        }
        contractChangeEntity.setCommitDate(null);
        contractChangeEntity.setCommitUserCode(null);
        contractChangeEntity.setCommitUserName(null);
        this.contractChangeService.saveOrUpdate((Object)contractChangeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractChangeEntity)));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractChangeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractChangeEntity contractChangeEntity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        this.contractChangeService.updateTotalChangeDataByContractId(contractChangeEntity, "back");
        return CommonResponse.success();
    }

    public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
        this.logger.info("\u81ea\u5b9a\u4e49\u63a5\u53e3\u5f00\u59cb-----");
        ContractChangeEntity e = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        ParamsCheckVO paramsCheckVO = this.contractChangeService.priceCheckParams((ContractChangeVO)BeanMapper.map((Object)((Object)e), ContractChangeVO.class));
        JSONObject object = new JSONObject();
        if (null != paramsCheckVO && CollectionUtils.isNotEmpty((Collection)paramsCheckVO.getDataSource())) {
            object.put("priceFlag", (Object)"\u662f");
            this.logger.info("\u5355\u4ef7\u5f02\u5e38-----" + JSONObject.toJSONString((Object)paramsCheckVO.getDataSource()));
        } else {
            object.put("priceFlag", (Object)"\u5426");
            this.logger.info("\u5355\u4ef7\u6b63\u5e38-----");
        }
        return CommonResponse.success((Object)object);
    }
}

