/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryAdmixtureService;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliverySaveVO;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliveryVO;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"concreteDelivery"})
@Api(value="\u6df7\u51dd\u571f-\u53d1\u8d27\u4e3b\u8868", tags={"\u6df7\u51dd\u571f-\u53d1\u8d27\u4e3b\u8868"})
public class ConcreteDeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "HNT-DELIVERY-CODE";
    @Autowired
    private IConcreteDeliveryService service;
    @Autowired
    private IConcreteDeliveryAdmixtureService concreteDeliveryAdmixtureService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteDeliverySaveVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ConcreteDeliverySaveVO saveOrUpdateVO) {
        ConcreteDeliverySaveVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u4f9b\u65b9\u63a8\u9001\u53d1\u8d27\u5355\u63a5\u53e3")
    @RequestMapping(value={"/supplierPushDelivery"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteDeliveryVO> supplierPushDelivery(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ConcreteDeliveryVO saveOrUpdateVO) {
        String dataInfo = JSONObject.toJSONString((Object)saveOrUpdateVO);
        this.logger.info("\u6df7\u51dd\u571f\u4f9b\u65b9\u63a8\u9001\u7684\u6570\u636e:" + dataInfo);
        ConcreteDeliveryVO vo = this.service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u91cd\u65b0\u63a8\u9001\u7b2c\u4e09\u65b9\u5931\u8d25\u6570\u636e\u63a5\u53e3")
    @RequestMapping(value={"/PushThirdData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConcreteDeliveryVO> savePushThirdData(@RequestParam Long id) {
        ConcreteDeliveryVO vo = this.service.savePushThirdData(id);
        return CommonResponse.success((Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConcreteDeliverySaveVO> queryDetail(@RequestParam Long id) {
        ConcreteDeliverySaveVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5(\u9a8c\u6536\u7528)")
    @RequestMapping(value={"/queryDetailToCheck"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryDetailToCheck(@RequestParam Long id) {
        ConcreteCheckVO vo = this.service.queryDetailToCheck(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u53d1\u8d27\u5355\u5173\u95ed\u63a5\u53e3")
    @RequestMapping(value={"/closeDelivery"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConcreteDeliveryVO> closeDelivery(@RequestParam Long id) {
        ConcreteDeliveryVO vo = this.service.closeDelivery(id);
        return CommonResponse.success((String)"\u53d1\u8d27\u5355\u5173\u95ed\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConcreteDeliverySaveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConcreteDeliverySaveVO concreteDeliverySaveVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConcreteDeliveryVO>> queryList(@RequestBody QueryParam param) {
        CommonResponse listCommonResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> checkStatusList = new ArrayList<Integer>();
        checkStatusList.add(0);
        checkStatusList.add(1);
        param.getParams().put("checkStatus", new Parameter("in", checkStatusList));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List deliveryVOS = BeanMapper.mapList((Iterable)page.getRecords(), ConcreteDeliveryVO.class);
        List collect = deliveryVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        Map<Object, Object> weighbillVOMap = new HashMap();
        if (CollectionUtils.isNotEmpty(collect) && (listCommonResponse = this.weighbillApi.queryWeighBydeliveryId(collect)).isSuccess()) {
            List data = (List)listCommonResponse.getData();
            this.logger.info("\u67e5\u8be2\u78c5\u5355\u6570\u91cf\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                weighbillVOMap = data.stream().collect(Collectors.toMap(WeighbillVO::getDeliveryId, Function.identity()));
            }
            for (ConcreteDeliveryVO deliveryVO : deliveryVOS) {
                WeighbillVO weighbillVOS = (WeighbillVO)weighbillVOMap.get(deliveryVO.getId());
                if (null != weighbillVOS) {
                    deliveryVO.setCheckWeighNum(weighbillVOS.getWeightCheckNum());
                    deliveryVO.setWeighNum(weighbillVOS.getWeightNum());
                    continue;
                }
                deliveryVO.setCheckWeighNum(Integer.valueOf(0));
                deliveryVO.setWeighNum(Integer.valueOf(0));
            }
        }
        pageData.setRecords(deliveryVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConcreteDelivery-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refConcreteDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConcreteDeliveryVO>> refConcreteDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConcreteDeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

