/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="concreteDelivery")
public class ConcreteDeliveryBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IConcreteDeliveryService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ConcreteDeliveryEntity entity = (ConcreteDeliveryEntity)((Object)this.service.selectById(billId));
        if (null != entity.getAutomaticWeigh() && 0 == entity.getAutomaticWeigh()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(entity.getContractId()));
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)entity), DeliveryThirdVO.class);
            thirdVO.setOrderAddress("/");
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("HNT");
            List<ConcreteDeliveryDetailEntity> detailList = entity.getConcreteDeliveryDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (!thirdRes.isSuccess()) {
                this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("unSucPush");
                entity.setUnSucReason(thirdRes.getMsg());
            } else {
                this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            }
            this.service.updateById((Object)entity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d1\u8d27\u5355\u6682\u65f6\u4e0d\u652f\u6301\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

