/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.mapper.DeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    @Autowired
    private IDeliveryService deliveryService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "XHC-DELIVERY-CODE";
    private final String OPERATE = "XHC_DELIVERY_SYNC";
    private static final String BILL_TYPE_CODE = "BT220223000000002";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Override
    public CheckVO queryDetailToCheck(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        CheckVO checkVO = new CheckVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(Integer.valueOf(0));
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
        checkVO.setContractCode(deliveryEntity.getContractCode());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setDepartmentId(deliveryEntity.getDepartmentId());
        checkVO.setDepartmentName(deliveryEntity.getDepartmentName());
        checkVO.setLicensePlate(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setCheckType(deliveryEntity.getCheckType());
        checkVO.setCheckTypeName(deliveryEntity.getCheckTypeName());
        checkVO.setSourceType(Integer.valueOf(1));
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(deliveryEntity.getContractId()));
        checkVO.setPricingType(contractEntity.getPricingType());
        checkVO.setAutomaticWeigh(deliveryEntity.getAutomaticWeigh());
        checkVO.setDeliveryType(deliveryEntity.getDeliveryType());
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        Map DetailMaterialIdMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
        Map DetailMaterialIdTypeMap = contractDetailList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)) {
            List<Long> materialIDS = deliveryDetailEntityList.stream().map(DeliveryDetailEntity::getMaterialId).distinct().collect(Collectors.toList());
            List<MaterialPriceHistoryApiVO> priceHistoryApiVOS = this.priceHistoryService.getMaterialPriceHistoryApiVOS(materialIDS);
            CommonResponse commonResponse = this.shareMaterialApi.queryMaterialItemByIds(materialIDS);
            this.logger.info("\u9a8c\u6536id\uff1a{}\uff0c\u67e5\u8be2\u6210\u672c\u79d1\u76ee\u4fe1\u606f\uff1a{}", (Object)id, (Object)JSONObject.toJSONString((Object)commonResponse));
            Map<Object, Object> materialVOMap = new HashMap();
            if (commonResponse.isSuccess()) {
                List materialVOList = (List)commonResponse.getData();
                materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            }
            Map materialPriceMap = priceHistoryApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity()));
            ArrayList<CheckDetailVO> checkDetailVOS = new ArrayList<CheckDetailVO>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                ContractDetailEntity contractDetailEntity;
                CheckDetailVO checkDetailVO = new CheckDetailVO();
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(deliveryDetailEntity.getId());
                checkDetailVO.setOrderId(deliveryEntity.getOrderId());
                checkDetailVO.setOrderDetailId(deliveryDetailEntity.getOrderDetailId());
                checkDetailVO.setMaterialId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setMaterialName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setMaterialTypeId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setMaterialTypeName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setMaterialCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setUnit(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpec(deliveryDetailEntity.getSpec());
                checkDetailVO.setDetailAutomaticWeigh(deliveryDetailEntity.getDetailAutomaticWeigh());
                checkDetailVO.setDeliverNum(deliveryDetailEntity.getDeliveryNum());
                checkDetailVO.setCheckNum(deliveryDetailEntity.getDeliveryNum().subtract(deliveryDetailEntity.getCheckNum() == null ? BigDecimal.ZERO : deliveryDetailEntity.getCheckNum()));
                if (deliveryDetailEntity.getMaterialId() != null && materialPriceMap.containsKey(deliveryDetailEntity.getMaterialId())) {
                    checkDetailVO.setHistoryPriceArea(((MaterialPriceHistoryApiVO)materialPriceMap.get(deliveryDetailEntity.getMaterialId())).getHistoryPriceArea());
                    checkDetailVO.setHistoryTaxPriceArea(((MaterialPriceHistoryApiVO)materialPriceMap.get(deliveryDetailEntity.getMaterialId())).getHistoryTaxPriceArea());
                }
                if (deliveryDetailEntity.getMaterialId() != null && materialVOMap.containsKey(checkDetailVO.getMaterialId())) {
                    MaterialVO materialVO = (MaterialVO)materialVOMap.get(checkDetailVO.getMaterialId());
                    checkDetailVO.setSubjectId(materialVO.getSubjectId());
                    checkDetailVO.setSubjectName(materialVO.getSubjectName());
                }
                checkDetailVO.setSourceId(deliveryDetailEntity.getSourceDetailId());
                if (DetailMaterialIdMap.containsKey(deliveryDetailEntity.getMaterialId())) {
                    contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdMap.get(deliveryDetailEntity.getMaterialId()));
                    checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                    checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                    checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    checkDetailVO.setMemo(contractDetailEntity.getMemo());
                }
                if (!DetailMaterialIdMap.containsKey(deliveryDetailEntity.getMaterialId())) {
                    if (DetailMaterialIdTypeMap.containsKey(deliveryDetailEntity.getMaterialTypeId())) {
                        contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdTypeMap.get(deliveryDetailEntity.getMaterialTypeId()));
                        checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                        checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                        checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        checkDetailVO.setMemo(contractDetailEntity.getMemo());
                    }
                    if (!DetailMaterialIdTypeMap.containsKey(deliveryDetailEntity.getMaterialTypeId())) {
                        checkDetailVO.setTaxRate(contractEntity.getTaxRate());
                    }
                }
                if (!DetailMaterialIdMap.containsKey(deliveryDetailEntity.getMaterialId()) && !DetailMaterialIdTypeMap.containsKey(deliveryDetailEntity.getMaterialTypeId())) {
                    checkDetailVO.setContractFlag(Integer.valueOf(2));
                } else {
                    checkDetailVO.setContractFlag(Integer.valueOf(1));
                }
                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setCheckDetailList(checkDetailVOS);
        }
        return checkVO;
    }

    @Override
    @Transactional
    public DeliveryVO closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.selectById((Serializable)id));
        deliveryEntity.setCloseFlag(1);
        super.updateById((Object)deliveryEntity);
        if (DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
            return (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", deliveryEntity.getSourceId());
        map.put("closeFlag", 1);
        map.put("systemId", ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = this.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "XHC_DELIVERY_SYNC", BILL_TYPE_CODE);
        if (!updateSupplierStatus.booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
        }
        return (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = this.jedisPool.getResource();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)operate, (int)600);
            if (!locked.booleanValue()) {
                this.releaseLock(jedis, false, key, operate);
                this.logger.error("\u5355\u636e{}\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25-{}\uff01", (Object)billId, (Object)locked);
                Boolean bl = false;
                return bl;
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u53d1\u8d27\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{billId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public DeliveryVO saveOrUpdates(DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        List materialDeliveryDetailList = saveOrUpdateVO.getMaterialDeliveryDetailList();
        List deliveryDetailEntityList = BeanMapper.mapList((Iterable)materialDeliveryDetailList, DeliveryDetailEntity.class);
        entity.setDeliveryDetailList(deliveryDetailEntityList);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCloseFlag(0);
        entity.setSourceType(1);
        entity.setDeliveryType(2);
        super.saveOrUpdate((Object)entity, false);
        if (null != entity.getAutomaticWeigh() && 0 == entity.getAutomaticWeigh()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(saveOrUpdateVO.getContractId()));
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getById(saveOrUpdateVO.getOrderId()));
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)entity), DeliveryThirdVO.class);
            thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
            thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("CL");
            List<DeliveryDetailEntity> detailList = entity.getDeliveryDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (!thirdRes.isSuccess()) {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("unSucPush");
                entity.setUnSucReason(thirdRes.getMsg());
            } else {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            }
            super.updateById((Object)entity);
        }
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return vo;
    }

    @Override
    public DeliveryVO savePushThirdData(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)super.selectById((Serializable)id));
        if (null != entity.getAutomaticWeigh() && 0 == entity.getAutomaticWeigh()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(entity.getContractId()));
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)entity), DeliveryThirdVO.class);
            if (DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(entity.getDeliveryType())) {
                thirdVO.setOrderAddress("/");
            } else {
                OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getById(entity.getOrderId()));
                thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
                thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            }
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("CL");
            List<DeliveryDetailEntity> detailList = entity.getDeliveryDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (thirdRes.isSuccess()) {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            } else {
                entity.setUnSucReason(thirdRes.getMsg());
            }
            super.updateById((Object)entity);
        }
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

