/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.electronicFence.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigChangeEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigChangeService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"electronicFenceConfigChange"})
public class ElectronicFenceConfigChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IElectronicFenceConfigChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ElectronicFenceConfigChangeVO> saveOrUpdate(@RequestBody ElectronicFenceConfigChangeVO saveOrUpdateVO) {
        ElectronicFenceConfigChangeVO resp = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ElectronicFenceConfigChangeVO> queryDetail(Long id) {
        ElectronicFenceConfigChangeEntity entity = (ElectronicFenceConfigChangeEntity)((Object)this.service.selectById(id));
        ElectronicFenceConfigChangeVO vo = (ElectronicFenceConfigChangeVO)BeanMapper.map((Object)((Object)entity), ElectronicFenceConfigChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ElectronicFenceConfigChangeVO> vos) {
        this.service.removeConfigByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ElectronicFenceConfigChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ElectronicFenceConfigChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"newChange"})
    public CommonResponse<ElectronicFenceConfigChangeVO> newChange(@RequestParam Long sourceConfigId) {
        ElectronicFenceConfigChangeVO resp = null;
        ElectronicFenceConfigEntity sourceEntity = (ElectronicFenceConfigEntity)((Object)this.electronicFenceConfigService.selectById(sourceConfigId));
        resp = (ElectronicFenceConfigChangeVO)BeanMapper.map((Object)((Object)sourceEntity), ElectronicFenceConfigChangeVO.class);
        resp.setSourceConfigId(sourceConfigId);
        this.clearBaseField((BaseVO)resp);
        resp.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        resp.setBillCode(null);
        resp.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        resp.setChangeDate(new Date());
        resp.setId(null);
        resp.setChangeVersion(Integer.valueOf(sourceEntity.getChangeVersion() + 1));
        UserContext user = this.sessionManager.getUserContext();
        resp.setEmployeeName(user.getEmployeeName());
        if (CollectionUtils.isNotEmpty((Collection)resp.getDetailList())) {
            resp.getDetailList().forEach(item -> {
                item.setSourcePid(sourceConfigId);
                item.setSourceSubId(item.getId());
                this.clearBaseField((BaseVO)item);
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resp);
    }

    private void clearBaseField(BaseVO baseVO) {
        baseVO.setId(Long.valueOf(IdWorker.getId()));
        baseVO.setCreateTime(null);
        baseVO.setCreateUserCode(null);
        baseVO.setUpdateTime(null);
        baseVO.setUpdateUserCode(null);
        baseVO.setVersion(Integer.valueOf(0));
        baseVO.setRowState("add");
    }
}

