/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.electronicFence.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigChangeEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.mapper.ElectronicFenceConfigChangeMapper;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigChangeService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="electronicFenceConfigChangeService")
public class ElectronicFenceConfigChangeServiceImpl
extends BaseServiceImpl<ElectronicFenceConfigChangeMapper, ElectronicFenceConfigChangeEntity>
implements IElectronicFenceConfigChangeService {
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    @Override
    public ElectronicFenceConfigChangeVO insertOrUpdate(ElectronicFenceConfigChangeVO saveOrUpdateVO) {
        int num;
        ElectronicFenceConfigEntity sourceEntity = (ElectronicFenceConfigEntity)((Object)this.electronicFenceConfigService.selectById(saveOrUpdateVO.getSourceConfigId()));
        ElectronicFenceConfigChangeEntity changeEntity = (ElectronicFenceConfigChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ElectronicFenceConfigChangeEntity.class));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_config_id", (Object)saveOrUpdateVO.getSourceConfigId());
        query.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if ((num = super.count((Wrapper)query)) > 0) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u7535\u5b50\u56f4\u680f\u8bbe\u7f6e\u5355\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355");
        }
        if (null == changeEntity.getId()) {
            changeEntity.setId(IdWorker.getId());
            if (changeEntity.getChangeVersion() < 10) {
                changeEntity.setChangeCode(sourceEntity.getBillCode() + "-0" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setChangeCode(sourceEntity.getBillCode() + "-" + changeEntity.getChangeVersion());
            }
            if (CollectionUtils.isNotEmpty(changeEntity.getDetailList())) {
                changeEntity.getDetailList().forEach(item -> item.setPid(changeEntity.getId()));
            }
            sourceEntity.setChangeDate(changeEntity.getChangeDate());
            sourceEntity.setChangeCode(changeEntity.getChangeCode());
            sourceEntity.setChangeId(changeEntity.getId());
            sourceEntity.setBeforeChangeStatus(sourceEntity.getChangeStatus());
            sourceEntity.setChangeStatus(FenceConfigChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        }
        this.electronicFenceConfigService.saveOrUpdate((Object)sourceEntity, false);
        super.saveOrUpdate((Object)changeEntity, false);
        return (ElectronicFenceConfigChangeVO)BeanMapper.map((Object)((Object)changeEntity), ElectronicFenceConfigChangeVO.class);
    }

    @Override
    public void removeConfigByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List changeList = super.list((Wrapper)query);
        List sourceConfigIds = changeList.stream().map(ElectronicFenceConfigChangeEntity::getSourceConfigId).collect(Collectors.toList());
        QueryWrapper sourceQuery = new QueryWrapper();
        sourceQuery.in((Object)"id", sourceConfigIds);
        List sourceList = this.electronicFenceConfigService.list((Wrapper)sourceQuery);
        sourceList.stream().forEach(sourceConfig -> {
            sourceConfig.setChangeId(null);
            sourceConfig.setChangeCode(null);
            sourceConfig.setChangeDate(null);
            sourceConfig.setChangeStatus(sourceConfig.getBeforeChangeStatus());
        });
        this.electronicFenceConfigService.saveOrUpdateBatch(sourceList, sourceList.size(), false);
        for (Long id : ids) {
            super.removeById((Serializable)id, false);
        }
    }
}

