/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.SubOutStoreDetailEntity;
import com.ejianc.business.promaterial.out.bean.SubOutStoreEntity;
import com.ejianc.business.promaterial.out.mapper.SubOutStoreMapper;
import com.ejianc.business.promaterial.out.service.ISubOutStoreService;
import com.ejianc.business.promaterial.out.vo.ClaimTypeEnum;
import com.ejianc.business.promaterial.out.vo.SubOutStoreDetailVO;
import com.ejianc.business.promaterial.out.vo.SubOutStoreVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subOutStoreService")
public class SubOutStoreServiceImpl
extends BaseServiceImpl<SubOutStoreMapper, SubOutStoreEntity>
implements ISubOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    private static final String BILL_CODE = "SUB_OUT_STORE_CODE";
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<SubOutStoreVO> saveOrUpdate(SubOutStoreVO outStoreVO) {
        SubOutStoreEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (CollectionUtils.isEmpty((Collection)outStoreVO.getSubOutStoreDetailList())) {
            throw new BusinessException("\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList list = new ArrayList();
        outStoreVO.getSubOutStoreDetailList().forEach(e -> {
            if (!"del".equals(e.getRowState())) {
                list.add(e);
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)outStoreVO.getParentOrgCode()) && outStoreVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outStoreVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            outStoreVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)outStoreVO.getOrgCode()) && outStoreVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outStoreVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            outStoreVO.setOrgCode(orgVO.getCode());
        }
        if ((entity = (SubOutStoreEntity)((Object)BeanMapper.map((Object)outStoreVO, SubOutStoreEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outStoreVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSignStatus(0);
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        super.saveOrUpdate((Object)entity, false);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreVO.getStoreId());
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
        ArrayList flowVOS = new ArrayList();
        outStoreVO.getSubOutStoreDetailList().forEach(t -> {
            if ("del".equals(t.getRowState())) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(outStoreVO.getStoreId());
                flowVO.setStoreName(outStoreVO.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(outStoreVO.getEmployeeId());
                flowVO.setEmployeeName(outStoreVO.getEmployeeName());
                flowVO.setSupplierId(entity.getSubSupplierId());
                flowVO.setSupplierName(entity.getSubSupplierName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                flowVO.setTaxMny(t.getTaxMoney());
                flowVO.setMny(t.getMoney());
                flowVO.setTax(t.getOutTax());
                flowVO.setUseFor(outStoreVO.getUseFor());
                flowVO.setSubEmployeeName(outStoreVO.getSubEmployeeName());
                flowVO.setPickUnitId(entity.getSubSupplierId());
                flowVO.setPickUnitName(entity.getSubSupplierName());
                flowVO.setPickContractId(entity.getSubContractId());
                flowVO.setPickContractName(entity.getSubContractName());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode("BT220215000000004");
                flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
                flowVO.setSourceType(Integer.valueOf(1));
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPickType(entity.getClaimType());
                flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode((Integer)entity.getClaimType()).getDescription());
                flowVOS.add(flowVO);
            }
        });
        entity.getSubOutStoreDetailList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
            flowVO.setStoreId(outStoreVO.getStoreId());
            flowVO.setStoreName(outStoreVO.getStoreName());
            flowVO.setProjectId(entity.getProjectId());
            flowVO.setProjectName(entity.getProjectName());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setParentOrgId(entity.getParentOrgId());
            flowVO.setParentOrgName(entity.getParentOrgName());
            flowVO.setEmployeeId(outStoreVO.getEmployeeId());
            flowVO.setEmployeeName(outStoreVO.getEmployeeName());
            flowVO.setSupplierId(entity.getSubSupplierId());
            flowVO.setSupplierName(entity.getSubSupplierName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialCode(t.getMaterialCode());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getSpec());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setTaxPrice(t.getTaxPrice());
            flowVO.setPrice(t.getPrice());
            flowVO.setNum(t.getNum());
            flowVO.setTaxMny(t.getTaxMoney());
            flowVO.setMny(t.getMoney());
            flowVO.setTax(t.getOutTax());
            flowVO.setUseFor(entity.getUseFor());
            flowVO.setSubEmployeeName(entity.getSubEmployeeName());
            flowVO.setPickUnitId(entity.getSubSupplierId());
            flowVO.setPickUnitName(entity.getSubSupplierName());
            flowVO.setPickContractId(entity.getSubContractId());
            flowVO.setPickContractName(entity.getSubContractName());
            flowVO.setSourceId(entity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(entity.getBillCode());
            flowVO.setSourceBillTypeCode("BT220215000000004");
            flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
            flowVO.setSourceType(Integer.valueOf(1));
            flowVO.setSourceBillDate(entity.getOutDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(entity.getMemo());
            flowVO.setPickType(entity.getClaimType());
            flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode((Integer)entity.getClaimType()).getDescription());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        this.logger.debug("\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        SubOutStoreVO vo = (SubOutStoreVO)BeanMapper.map((Object)((Object)entity), SubOutStoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<String> del(List<SubOutStoreVO> vos) {
        Collection list = super.listByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        HashMap<Long, List> map = new HashMap<Long, List>();
        list.forEach(e -> {
            if (map.containsKey(e.getStoreId())) {
                ((List)map.get(e.getStoreId())).add(e.getId());
            } else {
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(e.getId());
                map.put(e.getStoreId(), idList);
            }
            if (e.getAttrFlag() != null && e.getAttrFlag() != 2) {
                CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(e.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
                if (!stringCommonResponse.isSuccess()) {
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
        });
        map.forEach((key, value) -> {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(key);
            storeManageVO.setSourceIdsForRollBack(value);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        });
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void costPush(SubOutStoreEntity outStoreEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<SubOutStoreDetailEntity> outStoreSubList = outStoreEntity.getSubOutStoreDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (SubOutStoreDetailEntity storeSubEntity : outStoreSubList) {
                if (null != storeSubEntity.getSubjectId() && null != storeSubEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(outStoreSubList)) {
            newRelationFlag = "0";
        }
        this.saveCost(outStoreEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{outStoreEntity.getId()});
        updateWrapper.set(SubOutStoreEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        outStoreEntity.setRelationFlag(newRelationFlag);
    }

    public CostCtrlVO sjCost(SubOutStoreVO vo) {
        List outStoreSubList = vo.getSubOutStoreDetailList();
        if (CollectionUtils.isNotEmpty((Collection)outStoreSubList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (SubOutStoreDetailVO outStoreSubVO : outStoreSubList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal taxMoney;
                if (null == outStoreSubVO.getSubjectId() || "del".equals(outStoreSubVO.getRowState())) continue;
                BigDecimal money = outStoreSubVO.getMoney() == null ? BigDecimal.ZERO : outStoreSubVO.getMoney();
                BigDecimal bigDecimal = taxMoney = outStoreSubVO.getTaxMoney() == null ? BigDecimal.ZERO : outStoreSubVO.getTaxMoney();
                if (map.containsKey(outStoreSubVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(outStoreSubVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(money));
                    costCtrlDetailVO.setTaxMny(taxMny.add(taxMoney));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(outStoreSubVO.getSubjectId());
                costCtrlDetailVO.setMny(money);
                costCtrlDetailVO.setTaxMny(taxMoney);
                map.put(outStoreSubVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    private void saveCost(SubOutStoreEntity outStoreEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SubOutStoreDetailEntity> outStoreSubList = outStoreEntity.getSubOutStoreDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (SubOutStoreDetailEntity outStoreSubEntity : outStoreSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setMaterialId(outStoreSubEntity.getMaterialId());
                costDetailVO.setMaterialName(outStoreSubEntity.getMaterialName());
                costDetailVO.setMaterialCode(outStoreSubEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(outStoreSubEntity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(outStoreSubEntity.getMaterialCategoryName());
                costDetailVO.setSpec(outStoreSubEntity.getSpec());
                costDetailVO.setUnit(outStoreSubEntity.getUnit());
                costDetailVO.setUnitId(outStoreSubEntity.getUnitId());
                costDetailVO.setSourceBillCode(outStoreEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u9886\u6599\u51fa\u5e93.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-promaterial-frontend/#/outStore/card?id=" + outStoreEntity.getId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectCode(outStoreSubEntity.getSubjectCode());
                costDetailVO.setSubjectName(outStoreSubEntity.getSubjectName());
                costDetailVO.setNum(outStoreSubEntity.getNum());
                costDetailVO.setWbsId(outStoreSubEntity.getWbsId());
                costDetailVO.setWbsCode(outStoreSubEntity.getWbsCode());
                costDetailVO.setWbsName(outStoreSubEntity.getWbsName());
                costDetailVO.setSourceId(outStoreSubEntity.getOutStoreId());
                costDetailVO.setSourceDetailId(outStoreSubEntity.getId());
                costDetailVO.setHappenTaxMny(outStoreSubEntity.getTaxMoney());
                costDetailVO.setHappenMny(outStoreSubEntity.getMoney());
                costDetailVO.setHappenDate(outStoreEntity.getOutDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("OUT_STORE");
                costDetailVO.setSourceTabType("OUT_STORE_SUB");
                costDetailVO.setProjectId(outStoreEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

