/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.controller.api;

import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.vo.SourceBliVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/batPlan/"})
public class BatPlanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBatPlanService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private CheckMapper checkMapper;

    @ApiOperation(value="\u5f15\u7528/\u91ca\u653e/\u5f15\u7528\u5b8c\u6210\u91c7\u8d2d\u8ba1\u5212")
    @RequestMapping(value={"/updateBatPlanQuote"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateBatPlanQuote(@RequestParam(value="idList") List<String> idList, @RequestParam(value="planState") Integer planState) {
        this.logger.info("\u4fee\u6539\u91c7\u8d2d\u8ba1\u5212\u3010{}\u3011\u72b6\u6001\u4e3a\uff1a[{}](\u8ba1\u5212\u72b6\u6001\uff080-\u5f85\u91c7\u8d2d\uff1b1-\u91c7\u8d2d\u4e2d\uff1b2-\u91c7\u8d2d\u5b8c\u6210\uff09)", (Object)(idList == null ? null : idList.toString()), (Object)planState);
        this.service.updateBatPlanByQuoteType(idList, planState);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"getSourceBliVO"})
    public CommonResponse<List<SourceBliVO>> getSourceBliVO(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="dateIn", required=false) String dateIn) {
        ArrayList<SourceBliVO> list = new ArrayList<SourceBliVO>();
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        SourceBliVO vo = this.checkMapper.getSourceBliVO(supplierId, orgIds, dateIn);
        SourceBliVO concreteSourceBliVO = this.checkMapper.getConcreteSourceBliVO(supplierId, orgIds, dateIn);
        list.add(vo);
        list.add(concreteSourceBliVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }
}

