/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeHisEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeHisEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeHisService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailChangeHisService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="masterPlanChange")
public class MasterPlanChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;
    @Autowired
    private IMasterPlanChangeHisService masterPlanChangeHisService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMasterPlanDetailChangeHisService masterPlanDetailChangeHisService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03--billId:{}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity entity = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.masterPlanChangeService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity planChange = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        this.masterPlanChangeService.saveOrUpdate((Object)planChange, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse;
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity planChange = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        MasterPlanEntity newPlanEntity = null;
        MasterPlanEntity oldPlan = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planChange.getSourcePlanId()));
        if (oldPlan.getPlanType() == 0) {
            stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211224000000004", "materPlan001", String.valueOf(oldPlan.getId()), "BT211224000000003", "materPlan001");
            if (!stringCommonResponse.isSuccess()) {
                this.logger.info("\u6d88\u8017\u6750\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            } else {
                this.logger.info("\u6d88\u8017\u6750\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            }
        } else if (oldPlan.getPlanType() == 1) {
            stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT220211000000003", "materPlan001", String.valueOf(oldPlan.getId()), "BT220211000000002", "materPlan001");
            if (!stringCommonResponse.isSuccess()) {
                this.logger.info("\u6df7\u6ce5\u571f\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6\u5931\u8d25------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            } else {
                this.logger.info("\u6df7\u6ce5\u571f\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6\u6210\u529f------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            }
        }
        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            UserContext userContext = this.sessionManager.getUserContext();
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        planChange.setEffectiveDate(new Date());
        MasterPlanChangeHisEntity recordEntity = (MasterPlanChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), MasterPlanChangeHisEntity.class));
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u603b\u8ba1\u5212\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u603b\u8ba1\u5212\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)planChange)), (Object)JSON.toJSONString((Object)((Object)oldPlan)));
        recordEntity.setSourcePlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getMasterPlanDetailList())) {
            recordEntity.getMasterPlanDetailList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(planChange.getId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if (null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if (recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0.0);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, 4).multiply(new BigDecimal(100)).setScale(2, 4).doubleValue());
        }
        this.masterPlanChangeHisService.saveOrUpdate((Object)recordEntity, false);
        recordEntity.getMasterPlanDetailList().forEach(item -> {
            if (item.getLeafFlag().booleanValue() && item.getParentId() != null) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"target_id", (Object)item.getParentId());
                query.eq((Object)"material_master_plan_id", (Object)item.getMaterialMasterPlanId());
                MasterPlanDetailChangeHisEntity one = (MasterPlanDetailChangeHisEntity)((Object)((Object)this.masterPlanDetailChangeHisService.getOne((Wrapper)query)));
                if (one != null) {
                    item.setParentId(one.getId());
                }
            }
        });
        this.masterPlanChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.masterPlanChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (MasterPlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), MasterPlanEntity.class));
        newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setCurChangingPlanId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        ArrayList<MasterPlanDetailEntity> updatePlanDetail = new ArrayList<MasterPlanDetailEntity>();
        this.logger.info("\u56de\u663e\u539f\u8ba1\u5212\u5b50\u8868\u5f00\u59cb\uff01");
        List<MasterPlanDetailEntity> oldList = oldPlan.getMasterPlanDetailList();
        Map<Long, MasterPlanDetailEntity> map1 = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(BaseEntity::getId, item -> item, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(newPlanEntity.getMasterPlanDetailList())) {
            for (MasterPlanDetailEntity detail2 : newPlanEntity.getMasterPlanDetailList()) {
                if (detail2.getChangeType() == 2) {
                    delDetailIds.add(detail2.getTargetId());
                    continue;
                }
                if (null != detail2.getTargetId()) {
                    if (!map1.containsKey(detail2.getTargetId())) continue;
                    MasterPlanDetailEntity masterPlanDetail = map1.get(detail2.getTargetId());
                    masterPlanDetail.setChangeType(detail2.getChangeType());
                    masterPlanDetail.setNum(detail2.getNum());
                    masterPlanDetail.setPrice(detail2.getPrice());
                    masterPlanDetail.setAmount(detail2.getAmount());
                    masterPlanDetail.setSurplusNums(detail2.getSurplusNums());
                    updatePlanDetail.add(masterPlanDetail);
                    continue;
                }
                detail2.setId(null);
                updatePlanDetail.add(detail2);
            }
        }
        if (CollectionUtils.isNotEmpty(updatePlanDetail)) {
            this.masterPlanDetailService.saveOrUpdateBatch(updatePlanDetail);
        }
        newPlanEntity.setMasterPlanDetailList(updatePlanDetail);
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.masterPlanDetailService.removeByIds(delDetailIds);
        }
        this.logger.info("\u56de\u663e\u539f\u8ba1\u5212\u5b50\u8868\u7ed3\u675f\uff01");
        this.masterPlanService.saveOrUpdate((Object)newPlanEntity, false);
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"material_master_plan_id", (Object)oldPlan.getId());
        List list = this.masterPlanDetailService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("\u539f\u8ba1\u5212\u5b50\u8868\u6811\u5f62\u6784\u9020\uff0c\u5e8f\u53f7\u8bbe\u7f6e\u5f00\u59cb\uff01");
            for (MasterPlanDetailEntity masterPlanDetail : list) {
                if (masterPlanDetail.getMaterialId() != null) continue;
                map.put(masterPlanDetail.getMaterialCategoryId(), masterPlanDetail.getId());
            }
            for (MasterPlanDetailEntity masterPlanDetail : list) {
                masterPlanDetail.setTargetId(masterPlanDetail.getId());
                if (masterPlanDetail.getMaterialId() == null) continue;
                if (map.containsKey(masterPlanDetail.getMaterialCategoryId())) {
                    masterPlanDetail.setParentId((Long)map.get(masterPlanDetail.getMaterialCategoryId()));
                    continue;
                }
                masterPlanDetail.setParentId(null);
            }
            HashMap<Long, MasterPlanDetailEntity> map2 = new HashMap<Long, MasterPlanDetailEntity>();
            HashMap<Long, Integer> map3 = new HashMap<Long, Integer>();
            Integer index = 1;
            for (MasterPlanDetailEntity masterPlanDetail : list) {
                if (masterPlanDetail.getParentId() != null) continue;
                masterPlanDetail.setTreeIndex(index.toString());
                map2.put(masterPlanDetail.getId(), masterPlanDetail);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                map3.put(masterPlanDetail.getId(), 1);
            }
            for (MasterPlanDetailEntity masterPlanDetail : list) {
                if (masterPlanDetail.getParentId() == null || !map2.containsKey(masterPlanDetail.getParentId())) continue;
                String treeIndex = ((MasterPlanDetailEntity)((Object)map2.get(masterPlanDetail.getParentId()))).getTreeIndex();
                Integer integer = (Integer)map3.get(masterPlanDetail.getParentId());
                masterPlanDetail.setTreeIndex(treeIndex + "." + integer);
                Integer n = integer;
                Integer n3 = integer = Integer.valueOf(integer + 1);
                map3.put(masterPlanDetail.getParentId(), integer);
            }
            this.logger.info("\u539f\u8ba1\u5212\u5b50\u8868\u6811\u5f62\u6784\u9020\uff0c\u5e8f\u53f7\u8bbe\u7f6e\u7ed3\u675f\uff01");
            if (this.masterPlanDetailService.saveOrUpdateBatch(list)) {
                return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
            }
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u901a\u8fc7\u540e\u56de\u8c03\u5b8c\u6210\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u603b\u8ba1\u5212\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity planChange = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_plan_id", (Object)billId);
        MasterPlanChangeHisEntity hisEntity = (MasterPlanChangeHisEntity)((Object)this.masterPlanChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            MasterPlanEntity newPlanEntity = null;
            MasterPlanEntity oldPlan = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planChange.getSourcePlanId()));
            this.logger.info("\u603b\u8ba1\u5212\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldPlan, (Object)hisEntity);
            newPlanEntity = (MasterPlanEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), MasterPlanEntity.class));
            newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
            newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion());
            newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGING);
            newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(planChange.getMasterPlanDetailList())) {
                ArrayList<MasterPlanDetailEntity> list = new ArrayList<MasterPlanDetailEntity>();
                MasterPlanDetailEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getMasterPlanDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (MasterPlanDetailChangeEntity detail : planChange.getMasterPlanDetailList()) {
                    tmp = (MasterPlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), MasterPlanDetailEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newPlanEntity.setMasterPlanDetailList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.masterPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }
            this.masterPlanChangeHisService.removeById(hisEntity.getId(), false);
            this.masterPlanService.saveOrUpdate((Object)newPlanEntity, false);
        }
        if (this.masterPlanChangeService.saveOrUpdate((Object)planChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
        MasterPlanChangeEntity entity = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        ParamsCheckVO paramsCheckVO = this.masterPlanChangeService.priceCheckParams((MasterPlanChangeVO)BeanMapper.map((Object)((Object)entity), MasterPlanChangeVO.class));
        JSONObject object = new JSONObject();
        if (null != paramsCheckVO && CollectionUtils.isNotEmpty((Collection)paramsCheckVO.getDataSource())) {
            object.put("priceFlag", (Object)"\u662f");
        } else {
            object.put("priceFlag", (Object)"\u5426");
        }
        return CommonResponse.success((Object)object);
    }
}

