/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanChangeHisMapper;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanChangeMapper;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanDetailChangeMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeHisVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailChangeVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckCodeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="masterPlanChangeService")
public class MasterPlanChangeServiceImpl
extends BaseServiceImpl<MasterPlanChangeMapper, MasterPlanChangeEntity>
implements IMasterPlanChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private MasterPlanChangeMapper planChangeMapper;
    @Autowired
    private MasterPlanDetailChangeMapper masterPlanDetailChangeMapper;
    @Autowired
    private MasterPlanChangeHisMapper masterPlanChangeHisMapper;
    @Autowired
    private IMasterPlanDetailChangeService masterPlanDetailChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IMasterPlanChangeService service;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    @Override
    public MasterPlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_plan_id", (Object)sourcePlanId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (MasterPlanChangeEntity)((Object)this.planChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MasterPlanChangeEntity saveOrUpdatePlanChange(MasterPlanChangeEntity saveEntity) {
        if (CollectionUtils.isNotEmpty(saveEntity.getMasterPlanDetailList())) {
            // empty if block
        }
        super.saveOrUpdate((Object)saveEntity, false);
        MasterPlanEntity planEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(saveEntity.getSourcePlanId()));
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            this.masterPlanService.saveOrUpdate((Object)planEntity, false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = this.planChangeMapper.selectBatchIds(changeIds);
        List planIds = changeList.stream().map(MasterPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", planIds);
        List planList = this.masterPlanService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_plan_id as planId"});
        query.in((Object)"source_plan_id", planIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_plan_id"});
        List queryResult = this.masterPlanChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = planList.iterator();
        while (iterator.hasNext()) {
            MasterPlanEntity plan;
            plan.setChangeState(null != hisCountNumMap.get((plan = (MasterPlanEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(plan.getId()) > 0 ? 2 : 0);
            plan.setCurChangingPlanId(null);
        }
        this.masterPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<MasterPlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MasterPlanChangeEntity::getSourcePlanId, (Object)id);
        lambda.in(MasterPlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, MasterPlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
            }
        });
        return recordVOList;
    }

    @Override
    public MasterPlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        MasterPlanChangeEntity masterPlanChangeEntity = (MasterPlanChangeEntity)((Object)super.selectById((Serializable)id));
        MasterPlanChangeVO masterPlanChangeVO = (MasterPlanChangeVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), MasterPlanChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List masterPlanDetailChangeEntities = this.masterPlanDetailChangeService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailChangeEntities)) {
            masterPlanDetailChangeEntities.forEach(entity -> {
                if (null == entity.getChangeType() || 2 != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (MasterPlanDetailChangeEntity cdEntity : detailEntityList) {
                if (cdEntity.getMaterialId() == null) {
                    cdEntity.setTid(cdEntity.getMaterialCategoryId().toString());
                    cdEntity.setTpid("999");
                } else {
                    cdEntity.setTid(cdEntity.getMaterialId().toString());
                    cdEntity.setTpid(cdEntity.getMaterialCategoryId().toString());
                }
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailChangeVO.class);
            if (detailHasChildren) {
                masterPlanChangeVO.setMasterPlanDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                masterPlanChangeVO.setMasterPlanDetailList(resultMapList);
            }
        } else {
            masterPlanChangeVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailChangeVO.class));
        }
        return masterPlanChangeVO;
    }

    @Override
    public CommonResponse<MasterPlanChangeVO> saveOrUpdateMasterPlan(MasterPlanChangeVO planVo, Boolean isControl) {
        List<MasterPlanDetailChangeEntity> beforeDetails;
        MasterPlanChangeEntity planChangeEntity = this.service.getUnFinishedChange(planVo.getSourcePlanId());
        if (!(null == planChangeEntity || null != planVo.getId() && planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u8ba1\u5212\uff01");
        }
        MasterPlanEntity masterPlan = (MasterPlanEntity)((Object)this.masterPlanService.getById(planVo.getSourcePlanId()));
        UserContext userContext = this.sessionManager.getUserContext();
        MasterPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = (MasterPlanChangeEntity)((Object)BeanMapper.map((Object)planVo, MasterPlanChangeEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (MasterPlanChangeEntity)((Object)this.service.getById(planVo.getId()));
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setPlanCode(planVo.getPlanCode());
            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMasterPlanDetailList(BeanMapper.mapList((Iterable)planVo.getMasterPlanDetailList(), MasterPlanDetailChangeEntity.class));
        }
        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = saveEntity.getMasterPlanDetailList()) && null == saveEntity.getId()) {
            for (MasterPlanDetailChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        if (!isControl.booleanValue()) {
            List<MasterPlanDetailChangeEntity> changeDetailEntities;
            if (null == planVo.getId()) {
                ExecutionVO executionVO1;
                String billType;
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"source_plan_id", (Object)planVo.getSourcePlanId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"change_version");
                List list = this.service.list((Wrapper)wrapper);
                ArrayList totalExecutionVOList = new ArrayList();
                if (list.size() > 0) {
                    billType = ((MasterPlanChangeEntity)((Object)list.get(0))).getPlanType() == 0 ? BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode() : BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
                    executionVO1 = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map(list.get(0), MasterPlanVO.class), "", billType, ((MasterPlanChangeEntity)((Object)list.get(0))).getPlanType());
                } else {
                    MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(saveEntity.getSourcePlanId()));
                    billType = masterPlanEntity.getPlanType() == 0 ? BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode() : BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
                    executionVO1 = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), MasterPlanVO.class), "", billType, masterPlanEntity.getPlanType());
                }
                totalExecutionVOList.add(executionVO1.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString((Object)totalExecutionVOList));
                CommonResponse response1 = this.executionApi.aggDel((List)totalExecutionVOList);
                if (!response1.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response1.getMsg());
                }
            }
            if (CollectionUtils.isNotEmpty(changeDetailEntities = (saveEntity = this.service.saveOrUpdatePlanChange(saveEntity)).getMasterPlanDetailList())) {
                HashMap<String, Long> idMap = new HashMap<String, Long>();
                for (MasterPlanDetailChangeEntity cdEntity : changeDetailEntities) {
                    idMap.put(cdEntity.getTid(), cdEntity.getId());
                }
                for (MasterPlanDetailChangeEntity cdEntity : changeDetailEntities) {
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                List resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
                List treeData = ResultAsTree.createTreeData((List)resultMapList);
                List<Map<String, Object>> ListCodeDate = this.creatInnerCode(treeData, null);
                ArrayList<MasterPlanDetailChangeEntity> saveEntities = new ArrayList<MasterPlanDetailChangeEntity>();
                this.treeToList(ListCodeDate, saveEntities);
                this.masterPlanDetailChangeService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
            }
        }
        MasterPlanChangeVO masterPlanChangeVO = null;
        if (!isControl.booleanValue()) {
            String billType;
            String linkUrl;
            String frontendBaseHost = "";
            frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
            if (saveEntity.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + saveEntity.getId();
                billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + saveEntity.getId();
                billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
            }
            ExecutionVO executionVO = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map((Object)((Object)saveEntity), MasterPlanVO.class), linkUrl, billType, saveEntity.getPlanType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            masterPlanChangeVO = this.service.queryDetail(saveEntity.getId(), true);
        } else {
            masterPlanChangeVO = (MasterPlanChangeVO)BeanMapper.map((Object)((Object)saveEntity), MasterPlanChangeVO.class);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)masterPlanChangeVO);
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<MasterPlanDetailChangeEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((MasterPlanDetailChangeEntity)((Object)BeanMapper.map(ypd, MasterPlanDetailChangeEntity.class)));
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(MasterPlanChangeVO masterPlanVO) {
        String billType;
        String linkUrl;
        CommonResponse<MasterPlanChangeVO> masterPlanVOCommonResponse = this.saveOrUpdateMasterPlan(masterPlanVO, true);
        MasterPlanChangeVO planVO = (MasterPlanChangeVO)masterPlanVOCommonResponse.getData();
        String frontendBaseHost = "";
        frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        if (masterPlanVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
        }
        if (null == masterPlanVO.getId()) {
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"source_plan_id", (Object)planVO.getSourcePlanId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"change_version");
            List list = this.service.list((Wrapper)wrapper);
            if (list.size() > 0) {
                planVO.setSourcePlanId(((MasterPlanChangeEntity)((Object)list.get(0))).getId());
            }
        }
        MasterPlanVO masterPlanVO1 = (MasterPlanVO)BeanMapper.map((Object)planVO, MasterPlanVO.class);
        masterPlanVO1.setMasterPlanDetailList(BeanMapper.mapList((Iterable)planVO.getMasterPlanDetailList(), MasterPlanDetailVO.class));
        ExecutionVO executionVO = this.masterPlanService.targetCost(masterPlanVO1, linkUrl, billType, planVO.getPlanType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u6570\u636e" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.checkParams(planVO, (ParamsCheckVO)response.getData());
        return data;
    }

    public ParamsCheckVO checkParams(MasterPlanChangeVO masterPlanVO, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        ParamsCheckVO priceParam = this.priceCheckParams(masterPlanVO);
        if (priceParam != null) {
            paramsCheckVOS.add(priceParam);
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO priceCheckParams(MasterPlanChangeVO masterPlanVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)masterPlanVO.getMasterPlanDetailList())) {
            for (MasterPlanDetailChangeVO detailVO : masterPlanVO.getMasterPlanDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(masterPlanVO.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        String MAX_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u603b\u8ba1\u5212\u6700\u9ad8\u4ef7.getCode();
        String MIN_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u603b\u8ba1\u5212\u6700\u4f4e\u4ef7.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        CommonResponse minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE, orgId);
        if (!minParamByCode.isSuccess() && null == minParamByCode.getData()) {
            this.logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u6750\u6599\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u6750\u6599\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode()));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6750\u6599\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5355\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6750\u6599\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        String billType;
        String linkUrl;
        MasterPlanChangeVO planVO = this.queryDetail(id, true);
        String frontendBaseHost = "";
        frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        if (planVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
        }
        ExecutionVO executionVO = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map((Object)planVO, MasterPlanVO.class), linkUrl, billType, planVO.getPlanType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u6570\u636e" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }
}

