package com.ejianc.business.promaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.SubOutStoreEntity;
import com.ejianc.business.promaterial.out.bean.SubOutStoreDetailEntity;
import com.ejianc.business.promaterial.out.mapper.OutStoreMapper;
import com.ejianc.business.promaterial.out.mapper.SubOutStoreMapper;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.service.ISubOutStoreService;
import com.ejianc.business.promaterial.out.vo.*;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 *
 *
 * @author generator
 *
 */
@Service("subOutStoreService")
public class SubOutStoreServiceImpl extends BaseServiceImpl<SubOutStoreMapper, SubOutStoreEntity> implements ISubOutStoreService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IStoreManageApi storeManageApi;

    private static final String BILL_CODE = "SUB_OUT_STORE_CODE";//此处需要根据实际修改
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<SubOutStoreVO> saveOrUpdate(SubOutStoreVO outStoreVO) {

        if(CollectionUtils.isEmpty(outStoreVO.getSubOutStoreDetailList())) {
            throw new BusinessException("子表数据不能为空!");
        }else{
            List<SubOutStoreDetailVO> list = new ArrayList<>();
            outStoreVO.getSubOutStoreDetailList().forEach(e->{
                if(!"del".equals(e.getRowState())){
                    list.add(e);
                }
            });
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("子表数据不能为空!");
            }
        }

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outStoreVO.getParentOrgCode()) && outStoreVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outStoreVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                outStoreVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outStoreVO.getOrgCode()) && outStoreVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outStoreVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                outStoreVO.setOrgCode(orgVO.getCode());
            }
        }
        SubOutStoreEntity entity = BeanMapper.map(outStoreVO, SubOutStoreEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),outStoreVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setSignStatus(0);//签字信息初始化
        entity.setRelationFlag("0");//关联状态初始化
        entity.setProportionFlag("0");//分摊状态初始化
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        super.saveOrUpdate(entity, false);
        //调用库存逻辑
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreVO.getStoreId());
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
        storeManageVO.setOutEffectiveON(false);
        ArrayList<FlowVO> flowVOS = new ArrayList<>();
        //循环删除的数据
        outStoreVO.getSubOutStoreDetailList().forEach(t->{
            if("del".equals(t.getRowState())){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
                flowVO.setStoreId(outStoreVO.getStoreId());
                flowVO.setStoreName(outStoreVO.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(outStoreVO.getEmployeeId());
                flowVO.setEmployeeName(outStoreVO.getEmployeeName());
                flowVO.setSupplierId(entity.getSubSupplierId());
                flowVO.setSupplierName(entity.getSubSupplierName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                flowVO.setTaxMny(t.getTaxMoney());
                flowVO.setMny(t.getMoney());
                flowVO.setTax(t.getOutTax());
                flowVO.setUseFor(outStoreVO.getUseFor());
                flowVO.setSubEmployeeName(outStoreVO.getSubEmployeeName());
                flowVO.setPickUnitId(entity.getSubSupplierId());
                flowVO.setPickUnitName(entity.getSubSupplierName());
                flowVO.setPickContractId(entity.getSubContractId());
                flowVO.setPickContractName(entity.getSubContractName());

                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode("BT220215000000004");
                flowVO.setSourceBillTypeName("领料出库");
                flowVO.setSourceType(1);//  0-自制,1-订单
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPickType(entity.getClaimType());//claimType; // 领料方式，1-分包领料,2-内部领料
                flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
                flowVOS.add(flowVO);
            }
        });
        //循环新增修改的数据
        entity.getSubOutStoreDetailList().forEach(t->{
            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
            flowVO.setStoreId(outStoreVO.getStoreId());
            flowVO.setStoreName(outStoreVO.getStoreName());
            flowVO.setProjectId(entity.getProjectId());
            flowVO.setProjectName(entity.getProjectName());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setParentOrgId(entity.getParentOrgId());
            flowVO.setParentOrgName(entity.getParentOrgName());
            flowVO.setEmployeeId(outStoreVO.getEmployeeId());
            flowVO.setEmployeeName(outStoreVO.getEmployeeName());
            flowVO.setSupplierId(entity.getSubSupplierId());
            flowVO.setSupplierName(entity.getSubSupplierName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialCode(t.getMaterialCode());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getSpec());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setTaxPrice(t.getTaxPrice());
            flowVO.setPrice(t.getPrice());
            flowVO.setNum(t.getNum());
            flowVO.setTaxMny(t.getTaxMoney());
            flowVO.setMny(t.getMoney());
            flowVO.setTax(t.getOutTax());
            flowVO.setUseFor(entity.getUseFor());
            flowVO.setSubEmployeeName(entity.getSubEmployeeName());
            flowVO.setPickUnitId(entity.getSubSupplierId());
            flowVO.setPickUnitName(entity.getSubSupplierName());
            flowVO.setPickContractId(entity.getSubContractId());
            flowVO.setPickContractName(entity.getSubContractName());

            flowVO.setSourceId(entity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(entity.getBillCode());
            flowVO.setSourceBillTypeCode("BT220215000000004");
            flowVO.setSourceBillTypeName("领料出库");
            flowVO.setSourceType(1);//  0-自制,1-订单
            flowVO.setSourceBillDate(entity.getOutDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(entity.getMemo());
            flowVO.setPickType(entity.getClaimType());//claimType; // 领料方式，1-分包领料,2-内部领料
            flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        logger.debug("参数：————"+JSONObject.toJSONString(storeManageVO));
        CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
        if(!response.isSuccess()) {
            throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
        }
        SubOutStoreVO vo = BeanMapper.map(entity, SubOutStoreVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> del(List<SubOutStoreVO> vos) {

        Collection<SubOutStoreEntity> list = super.listByIds(vos.stream().map(SubOutStoreVO::getId).collect(Collectors.toList()));
        Map<Long,List<Long>> map = new HashMap<>();
        list.forEach(e->{
            if(map.containsKey(e.getStoreId())){
                map.get(e.getStoreId()).add(e.getId());
            }else{
                List<Long> idList = new ArrayList<>();
                idList.add(e.getId());
                map.put(e.getStoreId(),idList);
            }
            //删除实际成本
            if(e.getAttrFlag()!=null && e.getAttrFlag()!=2) {//仓库属性 1-自购材；2-甲供材
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(e.getId());
                logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
        });
        map.forEach((key, value) -> {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(key);
            storeManageVO.setSourceIdsForRollBack(value);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
            storeManageVO.setOutEffectiveON(false);
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        });
        super.removeByIds(vos.stream().map(SubOutStoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @Override
    public void costPush(SubOutStoreEntity outStoreEntity) {
        logger.info("开始costPush");
        List<SubOutStoreDetailEntity> outStoreSubList = outStoreEntity.getSubOutStoreDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (SubOutStoreDetailEntity storeSubEntity : outStoreSubList) {
                if (null == storeSubEntity.getSubjectId() || null == storeSubEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(outStoreSubList)) {
            newRelationFlag = "0";
        }
        //先删后增
        saveCost(outStoreEntity,1);//生效状态 0-未生效，1-生效
        //更新是否关联
        LambdaUpdateWrapper<SubOutStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SubOutStoreEntity::getId, outStoreEntity.getId());
        updateWrapper.set(SubOutStoreEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        outStoreEntity.setRelationFlag(newRelationFlag);
    }
    public CostCtrlVO sjCost(SubOutStoreVO vo){
        List<SubOutStoreDetailVO> outStoreSubList = vo.getSubOutStoreDetailList();
        if(CollectionUtils.isNotEmpty(outStoreSubList)){
            Map<Long,CostCtrlDetailVO> map = new HashMap<>();
            for(SubOutStoreDetailVO outStoreSubVO:outStoreSubList){
                if(null!=outStoreSubVO.getSubjectId()&&!"del".equals(outStoreSubVO.getRowState())){
                    BigDecimal money = outStoreSubVO.getMoney()==null?BigDecimal.ZERO:outStoreSubVO.getMoney();
                    BigDecimal taxMoney = outStoreSubVO.getTaxMoney()==null?BigDecimal.ZERO:outStoreSubVO.getTaxMoney();
                    if(map.containsKey(outStoreSubVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(outStoreSubVO.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(money));
                        costCtrlDetailVO.setTaxMny(taxMny.add(taxMoney));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(outStoreSubVO.getSubjectId());
                        costCtrlDetailVO.setMny(money);
                        costCtrlDetailVO.setTaxMny(taxMoney);
                        map.put(outStoreSubVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }
            if(null!=map&&map.size()>0){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if(null!=vo.getId()){
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }
    private void saveCost(SubOutStoreEntity outStoreEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<SubOutStoreDetailEntity> outStoreSubList = outStoreEntity.getSubOutStoreDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (SubOutStoreDetailEntity outStoreSubEntity : outStoreSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setMaterialId(outStoreSubEntity.getMaterialId());
                costDetailVO.setMaterialName(outStoreSubEntity.getMaterialName());
                costDetailVO.setMaterialCode(outStoreSubEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(outStoreSubEntity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(outStoreSubEntity.getMaterialCategoryName());
                costDetailVO.setSpec(outStoreSubEntity.getSpec());
                costDetailVO.setUnit(outStoreSubEntity.getUnit());
                costDetailVO.setUnitId(outStoreSubEntity.getUnitId());
                costDetailVO.setSourceBillCode(outStoreEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.领料出库.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-promaterial-frontend/#/outStore/card?id=" + outStoreEntity.getId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectCode(outStoreSubEntity.getSubjectCode());
                costDetailVO.setSubjectName(outStoreSubEntity.getSubjectName());
                costDetailVO.setNum(outStoreSubEntity.getNum());
                costDetailVO.setWbsId(outStoreSubEntity.getWbsId());
                costDetailVO.setWbsCode(outStoreSubEntity.getWbsCode());
                costDetailVO.setWbsName(outStoreSubEntity.getWbsName());
                costDetailVO.setSourceId(outStoreSubEntity.getOutStoreId());
                costDetailVO.setSourceDetailId(outStoreSubEntity.getId());
                costDetailVO.setHappenTaxMny(outStoreSubEntity.getTaxMoney());
                costDetailVO.setHappenMny(outStoreSubEntity.getMoney());
                costDetailVO.setHappenDate(outStoreEntity.getOutDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("OUT_STORE");
                costDetailVO.setSourceTabType("OUT_STORE_SUB");
                costDetailVO.setProjectId(outStoreEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
