package com.ejianc.business.promaterial.plan.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 消耗材总计划变更记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_master_plan_change_his")
public class MasterPlanChangeHisEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目名称
    @TableField(value="plan_code")
    private String planCode; // 计划编码
    @TableField(value="total_plan_amt")
    private java.math.BigDecimal totalPlanAmt; // 现计划金额
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_user_name")
    private String changeUserName; // 变更人
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="original_plan_amt")
    private java.math.BigDecimal originalPlanAmt; // 原计划金额
    @TableField(value="source_plan_id")
    private Long sourcePlanId; // 源计划数据Id
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="commit_date")
    private java.util.Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="effective_date")
    private java.util.Date effectiveDate; // 生效日期
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_amount")
    private java.math.BigDecimal changeAmount; // 变更金额
    @TableField(value="change_ratio")
    private Double changeRatio; // 本次变更比例
    @TableField(value="change_plan_id")
    private Long changePlanId; // 变更计划Id
    @TableField(value="plan_type")
    private java.lang.Integer planType; // 计划类型（0-消耗材，1-混泥土）
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="operator_id")
    private Long operatorId; // 编制人id
    @TableField(value="operator_name")
    private String operatorName; // 编制人名称
    @TableField(value="plan_date")
    private Date planDate; // 计划日期
    @TableField(value="org_code")
    private java.lang.String orgCode; // 所属项目部编码
    @TableField(exist = false)
    @SubEntity(serviceName = "masterPlanDetailChangeHisService", pidName = "materialMasterPlanId")
    private List<MasterPlanDetailChangeHisEntity> masterPlanDetailList = new ArrayList<>();

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    /**
     * 编制人
     */
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }


    /**
     * 上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 计划类型
     */
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }
    /**
     * 所属项目Id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 计划编码
     */
    public String getPlanCode() {
        return planCode;
    }

    /**
     * 计划编码
     */
    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    /**
     * 现计划金额
     */
    public java.math.BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    /**
     * 现计划金额
     */
    public void setTotalPlanAmt(java.math.BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 所属项目部Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更人
     */
    public String getChangeUserName() {
        return changeUserName;
    }

    /**
     * 变更人
     */
    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 原计划金额
     */
    public java.math.BigDecimal getOriginalPlanAmt() {
        return originalPlanAmt;
    }

    /**
     * 原计划金额
     */
    public void setOriginalPlanAmt(java.math.BigDecimal originalPlanAmt) {
        this.originalPlanAmt = originalPlanAmt;
    }
    /**
     * 源计划数据Id
     */
    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    /**
     * 源计划数据Id
     */
    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 修改人名称
     */
    public String getModifyUserName() {
        return modifyUserName;
    }

    /**
     * 修改人名称
     */
    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    /**
     * 提交日期
     */
    public java.util.Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(java.util.Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public java.util.Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(java.util.Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更金额
     */
    public java.math.BigDecimal getChangeAmount() {
        return changeAmount;
    }

    /**
     * 变更金额
     */
    public void setChangeAmount(java.math.BigDecimal changeAmount) {
        this.changeAmount = changeAmount;
    }
    /**
     * 本次变更比例
     */
    public Double getChangeRatio() {
        return changeRatio;
    }

    /**
     * 本次变更比例
     */
    public void setChangeRatio(Double changeRatio) {
        this.changeRatio = changeRatio;
    }
    /**
     * 变更计划Id
     */
    public Long getChangePlanId() {
        return changePlanId;
    }

    /**
     * 变更计划Id
     */
    public void setChangePlanId(Long changePlanId) {
        this.changePlanId = changePlanId;
    }

    public List<MasterPlanDetailChangeHisEntity> getMasterPlanDetailList() {
        return masterPlanDetailList;
    }

    public void setMasterPlanDetailList(List<MasterPlanDetailChangeHisEntity> masterPlanDetailList) {
        this.masterPlanDetailList = masterPlanDetailList;
    }
}
