package com.ejianc.business.promaterial.out.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.out.bean.MonthSumDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 月度消耗汇总
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_month_sum")
public class MonthSumEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 出库单号
    @TableField(value="sum_date")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date sumDate; // 汇总月份
    @TableField(value="project_out_mny")
    private BigDecimal projectOutMny; // 项目消耗金额（无税）
    @TableField(value="project_out_tax_mny")
    private BigDecimal projectOutTaxMny; // 项目消耗金额
    @TableField(value="out_mny")
    private BigDecimal outMny; // 本月消耗金额（无税）
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 本月消耗金额
    @TableField(value="sub_out_mny")
    private BigDecimal subOutMny; // 分包消耗金额（无税）
    @TableField(value="sub_out_tax_mny")
    private BigDecimal subOutTaxMny; // 分包消耗金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="business_type")
    private Long businessType; //业务类型
    @TableField(value="business_type_name")
    private String businessTypeName; //业务类型
    
    @TableField(exist=false)
    @SubEntity(serviceName="monthSumDetailService",pidName = "outStoreId")
    private List<MonthSumDetailEntity> monthSumDetailList = new ArrayList<>(); // 月度消耗汇总-详情

    public Long getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Long businessType) {
        this.businessType = businessType;
    }

    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getSumDate() {
        return sumDate;
    }

    public void setSumDate(Date sumDate) {
        this.sumDate = sumDate;
    }
    public BigDecimal getProjectOutMny() {
        return projectOutMny;
    }

    public void setProjectOutMny(BigDecimal projectOutMny) {
        this.projectOutMny = projectOutMny;
    }
    public BigDecimal getProjectOutTaxMny() {
        return projectOutTaxMny;
    }

    public void setProjectOutTaxMny(BigDecimal projectOutTaxMny) {
        this.projectOutTaxMny = projectOutTaxMny;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    public BigDecimal getSubOutMny() {
        return subOutMny;
    }

    public void setSubOutMny(BigDecimal subOutMny) {
        this.subOutMny = subOutMny;
    }
    public BigDecimal getSubOutTaxMny() {
        return subOutTaxMny;
    }

    public void setSubOutTaxMny(BigDecimal subOutTaxMny) {
        this.subOutTaxMny = subOutTaxMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    

    public List<MonthSumDetailEntity> getMonthSumDetailList() {
        return monthSumDetailList;
    }

    public void setMonthSumDetailList(List<MonthSumDetailEntity> monthSumDetailList) {
        this.monthSumDetailList = monthSumDetailList;
    }
}
