package com.ejianc.business.promaterial.out.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.promaterial.out.bean.SubOutStoreEntity;
import com.ejianc.business.promaterial.out.service.IOutStoreSubService;
import com.ejianc.business.promaterial.out.service.ISubOutStoreService;
import com.ejianc.business.promaterial.out.vo.ExportOutStoreVO;
import com.ejianc.business.promaterial.out.vo.OutStoreSubVO;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.vo.OutStoreVO;

/**
 * 领料出库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outStore")
@Api(value = "领料出库", tags = {"领料出库"})
public class OutStoreController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOutStoreService service;

    @Autowired
    private IOutStoreSubService detailService;

    @Autowired
    private ISubOutStoreService subOutStoreService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/outStore/card";

    private final String billTypeCode = "BT220215000000004";

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutStoreVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(@RequestParam Long id) {
    	OutStoreEntity entity = service.selectById(id);
    	OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> pushCost(@RequestBody OutStoreVO outStoreVO) {
        if(outStoreVO.getAttrFlag()!=null && outStoreVO.getAttrFlag()!=2){
            return service.pushCost(outStoreVO);
        }
        return CommonResponse.success(outStoreVO);
    }

    /**
     * 单据管控
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OutStoreVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        OutStoreEntity entity = service.selectById(id);

        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSubSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSubSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }
        if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity);
                logger.info("获取推送供方结果--"+pushResult);
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSubSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }


        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSubSupplierId().toString(), mobileBillShareFrontUrl,null);

    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        return service.del(vos);
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("useFor");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        //查询本下
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<OutStoreEntity> list = service.queryList(param);
        List<ExportOutStoreVO> listVO = new ArrayList<>();
        //todo:字段翻译等等
       if(CollectionUtils.isNotEmpty(list)){
           for (OutStoreEntity entity : list) {
               ExportOutStoreVO storeVO = BeanMapper.map(entity, ExportOutStoreVO.class);
               switch (entity.getBillState()){
                   case 0: storeVO.setBillState("自由态");break;
                   case 1: storeVO.setBillState("已提交");break;
                   case 2: storeVO.setBillState("审批中");break;
                   case 3: storeVO.setBillState("审批通过");break;
                   case 4: storeVO.setBillState("审批驳回");break;
                   case 5: storeVO.setBillState("审批中");break;
               }
               if(entity.getSignStatus()!=null){
                   switch (entity.getSignStatus()){
                       case 0: storeVO.setSignStatus("未签字");break;
                       case 1: storeVO.setSignStatus("已签字");break;
                   }
               }
               if(entity.getAttrFlag()!=null){
                   switch (entity.getAttrFlag()){
                       case 1: storeVO.setAttrFlag("自购材");break;
                       case 2: storeVO.setAttrFlag("甲供材");break;
                   }
               }
               if(entity.getManageType()!=null){
                   switch (entity.getManageType()){
                       case 1: storeVO.setManageTypeName("分包仓库");break;
                       case 2: storeVO.setManageTypeName("项目仓库");break;
                   }
               }
               if(entity.getOutDate()!=null){
                   storeVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
               }
               listVO.add(storeVO);
           }
       }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVO);
        ExcelExport.getInstance().export("OutStore-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOutStoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("消耗材月度汇总使用参照")
    @RequestMapping(value = "/refOutStoreData4MonSUm", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutStoreData4MonSUm(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> _con = JSONObject.parseObject(condition,Map.class);
            if (null != _con.get("monthFlag")){
                if (null==_con.get("projectId") || null==_con.get("businessType")|| null==_con.get("outDate")){
                    throw new BusinessException("请检查参数！");
                }
                param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                param.getParams().put("monthUseFlag", new Parameter(QueryParam.SQL,"(month_use_flag is null or month_use_flag != '2')" ));
                param.getParams().put("projectId", new Parameter(QueryParam.EQ,_con.get("projectId")));
                param.getParams().put("businessType", new Parameter(QueryParam.EQ,_con.get("businessType")));
                param.getParams().put("outDate", new Parameter(QueryParam.SQL,"DATE_FORMAT(out_date,'%Y-%m') = '"+_con.get("outDate")+"'"));
                param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(1,3)));
            }

        }
        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutStoreVO> list = BeanMapper.mapList(page.getRecords(), OutStoreVO.class);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> idS = list.stream().map(OutStoreVO::getId).collect(Collectors.toList());
            QueryWrapper<OutStoreSubEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("out_store_id", idS);
            queryWrapper.eq("dr", 0);
            List<OutStoreSubEntity> detailEntity = detailService.list(queryWrapper);
            List<OutStoreSubVO> detailList = BeanMapper.mapList(detailEntity, OutStoreSubVO.class);
            Map<Long, List<OutStoreSubVO>> map = new HashMap();
            if (CollectionUtils.isNotEmpty(detailList)) {
                map= detailList.stream().collect(Collectors.groupingBy(OutStoreSubVO::getOutStoreId));
            }

            QueryWrapper<SubOutStoreEntity> subOutQw = new QueryWrapper<>();
            queryWrapper.in("billState", Arrays.asList(1,3));
            queryWrapper.eq("dr", 0);

            List<SubOutStoreEntity> subOutStoreEntityList = subOutStoreService.list(subOutQw);
            List<Long> subOutList = new ArrayList();
            if (CollectionUtils.isNotEmpty(subOutList)) {
                subOutList=subOutStoreEntityList.stream().map(SubOutStoreEntity::getId).collect(Collectors.toList());
            }
            for (OutStoreVO outStoreVO : list) {
                outStoreVO.setOutStoreSubList(map.get(outStoreVO.getId()));
                if (subOutList.contains(outStoreVO.getId())){
                    outStoreVO.setOutStoreType("分包仓库盘点");
                }else {
                    outStoreVO.setOutStoreType("领料出库");
                }
            }
        }
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
