/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.doc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import com.ejianc.business.promaterial.doc.service.IWasteCategoryService;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import com.ejianc.business.promaterial.doc.vo.WasteMaterialImportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"wasteItem"})
public class WasteItemController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_BILL_CODE = "WASTE_MATERIAL_COMM";
    private static final String MATERIAL_CATEGORY_BILL_CODE = "WASTE_MATERIAL_CATEGORY";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Value(value="${common.env.base-host}")
    private String ENV_PROFILE;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IWasteItemService materialService;
    @Autowired
    private IWasteCategoryService materialCategoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String INDEX_NAME = "ejc_wj_org_material_relation_es";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody WasteItemVO materialVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (materialVo.getId() != null && materialVo.getId() > 0L) {
            if (StringUtils.isNotBlank((CharSequence)materialVo.getCode())) {
                WasteItemVO codeData = this.materialService.queryByCode(materialVo.getCode());
                if (codeData != null && !codeData.getId().equals(materialVo.getId())) {
                    throw new BusinessException("\u7269\u8d44\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            } else {
                BillCodeParam billCodeParam = new BillCodeParam();
                billCodeParam.setTenantId(tenantId);
                billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                billCodeParam.setBillDetail(JSONObject.parseObject((String)JSONObject.toJSONString((Object)materialVo)));
                CommonResponse codeBatchByRuleCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (codeBatchByRuleCode.isSuccess()) {
                    materialVo.setCode((String)codeBatchByRuleCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            WasteItemVO uniqueBean = this.materialService.queryDetail(materialVo.getId());
            uniqueBean.setCode(materialVo.getCode());
            uniqueBean.setName(materialVo.getName());
            uniqueBean.setSpec(materialVo.getSpec());
            uniqueBean.setUnitId(materialVo.getUnitId());
            uniqueBean.setUnitName(materialVo.getUnitName());
            uniqueBean.setSubjectId(materialVo.getSubjectId());
            uniqueBean.setSubjectName(materialVo.getSubjectName());
            uniqueBean.setDescription(materialVo.getDescription());
            uniqueBean.setSequence(materialVo.getSequence());
            uniqueBean.setProperty(materialVo.getProperty());
            uniqueBean.setPropertyName(materialVo.getPropertyName());
            uniqueBean.setParentUnitCode(materialVo.getParentUnitCode());
            uniqueBean.setQuality(materialVo.getQuality());
            uniqueBean.setOperativeNorm(materialVo.getOperativeNorm());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(new Date());
            uniqueBean.setTenantId(InvocationInfoProxy.getTenantid());
            uniqueBean.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            this.materialService.update(uniqueBean);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        if (StringUtils.isNotBlank((CharSequence)materialVo.getCode())) {
            WasteItemVO codeData = this.materialService.queryByCode(materialVo.getCode());
            if (codeData != null) {
                throw new BusinessException("\u7269\u8d44\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        } else {
            WasteCategoryVO category = this.materialCategoryService.queryDetail(materialVo.getCategoryId());
            materialVo.setCategoryCode(category.getCode());
            BillCodeParam billCodeParam = new BillCodeParam();
            billCodeParam.setTenantId(tenantId);
            billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
            billCodeParam.setBillDetail(JSONObject.parseObject((String)JSONObject.toJSONString((Object)materialVo)));
            CommonResponse codeBatchByRuleCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (codeBatchByRuleCode.isSuccess()) {
                materialVo.setCode((String)codeBatchByRuleCode.getData());
            }
        }
        if (null == materialVo.getSubjectId()) {
            Long categoryId = materialVo.getCategoryId();
            WasteCategoryVO materialCategoryVO = this.materialCategoryService.queryDetail(categoryId);
            materialVo.setSubjectId(materialCategoryVO.getSubjectId());
            materialVo.setSubjectName(materialCategoryVO.getSubjectName());
        }
        materialVo.setId(Long.valueOf(IdWorker.getId()));
        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
        materialVo.setCreateTime(new Date());
        materialVo.setTenantId(InvocationInfoProxy.getTenantid());
        materialVo.setEnabled(Integer.valueOf(1));
        materialVo.setOrgId(InvocationInfoProxy.getOrgId());
        materialVo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        this.materialService.save(materialVo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/amend"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> amend(@RequestBody List<WasteItemVO> materialVo) {
        if (ListUtil.isNotEmpty(materialVo)) {
            for (WasteItemVO e : materialVo) {
                this.materialService.amend(e.getId(), e.getProperty(), e.getPropertyName());
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/allowIn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> allowIn(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            this.materialService.allowIn(ids);
        }
        return CommonResponse.success((String)"\u6279\u91cf\u51c6\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WasteItemVO> queryDetail(@RequestParam Long id) {
        WasteItemVO materialVo = this.materialService.queryDetail(id);
        return CommonResponse.success((Object)materialVo);
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.materialService.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("BT200422000000025", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.materialService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage<WasteItemEntity> pageData = this.materialService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @Deprecated
    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                WasteItemVO materialVo = null;
                List<WasteCategoryEntity> materialCategoryVo = this.materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (materialCategoryVo != null) {
                    materialVo = new WasteItemVO();
                    materialVo.setId(Long.valueOf(IdWorker.getId()));
                    materialVo.setCategoryId(materialCategoryVo.get(0).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            materialVo.setCode((String)codeBatchByRuleCode.getData());
                        } else {
                            materialVo.setCode(new Date().getTime() + "");
                        }
                    } else {
                        materialVo.setCode((String)datas.get(1));
                    }
                    materialVo.setName((String)datas.get(2));
                    materialVo.setParentUnitCode((String)datas.get(3));
                    materialVo.setSpec((String)datas.get(4));
                    materialVo.setUnitName((String)datas.get(5));
                    WasteItemVO materialBean = this.materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId());
                    if (materialBean != null) continue;
                    materialVo.setQuality((String)datas.get(6));
                    materialVo.setOperativeNorm((String)datas.get(7));
                    materialVo.setDescription((String)datas.get(8));
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    materialVo.setEnabled(Integer.valueOf(1));
                    this.materialService.save(materialVo);
                    continue;
                }
                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7269\u6599\u5206\u7c7b\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelMaterialImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelMaterialImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<WasteMaterialImportVO> successList = new ArrayList<WasteMaterialImportVO>();
        ArrayList<WasteMaterialImportVO> errorList = new ArrayList<WasteMaterialImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u7269\u6599\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashMap<String, WasteItemVO> materialBeanMap = new HashMap<String, WasteItemVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                WasteMaterialImportVO materialVo = new WasteMaterialImportVO();
                materialVo.setId(Long.valueOf(IdWorker.getId()));
                materialVo.setCategoryCode((String)datas.get(0));
                materialVo.setCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                materialVo.setSpec((String)datas.get(4));
                materialVo.setUnitName((String)datas.get(5));
                materialVo.setBillState(Integer.valueOf(1));
                materialVo.setParentUnitCode((String)datas.get(3));
                materialVo.setQuality((String)datas.get(6));
                materialVo.setOperativeNorm((String)datas.get(7));
                materialVo.setDescription((String)datas.get(8));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u7269\u6599\u5206\u7c7b\u7f16\u53f7\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVo.setDescription("\u7269\u6599\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<WasteCategoryEntity> materialCategoryVo = (List<WasteCategoryEntity>)caListMap.get(datas.get(0));
                if (ListUtil.isEmpty((List)materialCategoryVo) && ListUtil.isNotEmpty(materialCategoryVo = this.materialCategoryService.queryByCode(String.valueOf(datas.get(0))))) {
                    caListMap.put(datas.get(0), materialCategoryVo);
                }
                if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                    materialVo.setCategoryId(((WasteCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        BillCodeParam billCodeParam = new BillCodeParam();
                        billCodeParam.setTenantId(tenantId);
                        billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                        billCodeParam.setBillDetail(JSONObject.parseObject((String)JSONObject.toJSONString((Object)materialVo)));
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.generateBillCode(billCodeParam);
                        if (codeBatchByRuleCode.isSuccess()) {
                            materialVo.setCode((String)codeBatchByRuleCode.getData());
                        } else {
                            materialVo.setCode(new Date().getTime() + "");
                        }
                    } else {
                        WasteItemVO vo = (WasteItemVO)materialMap.get(datas.get(1));
                        if (vo == null && (vo = this.materialService.queryByCode((String)datas.get(1))) != null) {
                            materialMap.put(datas.get(1), vo);
                        }
                        if (vo != null) {
                            materialVo.setDescription("\u7269\u6599\u7f16\u53f7\u91cd\u590d\uff01");
                            errorList.add(materialVo);
                            continue;
                        }
                    }
                    WasteItemVO materialBean = (WasteItemVO)materialBeanMap.get(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId());
                    if (materialBean == null && (materialBean = this.materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId())) != null) {
                        materialBeanMap.put(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId(), materialBean);
                    }
                    if (materialBean != null) {
                        materialVo.setDescription("\u91cd\u590d\u7269\u6599\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    materialVo.setEnabled(Integer.valueOf(1));
                    successList.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u7269\u6599\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                errorList.add(materialVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImportExcelMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterial(@RequestBody List<WasteMaterialImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<WasteItemVO> list = new ArrayList<WasteItemVO>();
        HashSet<String> unitNameList = new HashSet<String>();
        importVOS.forEach(importVO -> {
            if (StringUtils.isNotEmpty((CharSequence)importVO.getUnitName())) {
                unitNameList.add(importVO.getUnitName());
            }
        });
        this.logger.info("----\u67e5\u8be2\u8ba1\u91cf\u4fe1\u606funitNameList---" + JSONObject.toJSONString(unitNameList));
        List<Map<String, Object>> unitEntities = this.materialService.queryUnit(unitNameList);
        this.logger.info("----\u67e5\u8be2\u8ba1\u91cf\u4fe1\u606funitEntities---" + JSONObject.toJSONString(unitEntities));
        HashMap<String, Long> map = new HashMap<String, Long>();
        Map<String, Long> unitDataMap = unitEntities.stream().filter(UnitEntity -> UnitEntity != null && UnitEntity.get("unitName") != null).collect(Collectors.toMap(UnitEntity -> UnitEntity.get("unitName").toString(), UnitEntity -> Long.valueOf(UnitEntity.get("id").toString()), (key1, key2) -> key1));
        map.putAll(unitDataMap);
        importVOS.forEach(importVO -> {
            WasteItemVO vo = (WasteItemVO)BeanMapper.map((Object)importVO, WasteItemVO.class);
            if (null != map && map.containsKey(importVO.getUnitName())) {
                vo.setUnitId((Long)map.get(importVO.getUnitName()));
            }
            vo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            list.add(vo);
        });
        this.logger.info("----\u5bfc\u5165list---" + JSONObject.toJSONString(list));
        this.materialService.insertBatch(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("eq", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()));
        List<WasteItemEntity> resultList = this.materialService.queryList(queryParam);
        HashMap<String, List<WasteItemEntity>> beans = new HashMap<String, List<WasteItemEntity>>();
        resultList.stream().forEach(item -> item.setDef10(item.getEnabled() == 1 ? "\u542f\u7528" : "\u505c\u7528"));
        beans.put("records", resultList);
        ExcelExport.getInstance().export("material-export.xlsx", beans, response);
    }

    @RequestMapping(value={"refMaterialPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WasteItemVO>> refMaterialPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        JSONObject _con;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            WasteCategoryVO materialCategoryVo = this.materialCategoryService.queryDetail(categoryId);
            if (materialCategoryVo != null) {
                params.put("innerCode", materialCategoryVo.getInnerCode());
            } else {
                return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"categoryCode") != null) {
                params.put("categoryCode", search.get((Object)"categoryCode").toString());
            }
            if (search.get((Object)"categoryName") != null) {
                params.put("categoryName", search.get((Object)"categoryName").toString());
            }
            if (search.get((Object)"code") != null) {
                params.put("code", search.get((Object)"code").toString());
            }
            if (search.get((Object)"name") != null) {
                params.put("name", search.get((Object)"name").toString());
            }
            if (search.get((Object)"spec") != null) {
                params.put("spec", search.get((Object)"spec").toString());
            }
            if (search.get((Object)"unitName") != null) {
                params.put("unitName", search.get((Object)"unitName").toString());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"categoryId")) {
            params.put("categoryId", _con.getLong("categoryId"));
        }
        params.put("billState", 1);
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<WasteItemVO> pageData = this.materialService.queryRefMaterialPage(params);
        pageData.setCurrent((long)pageNumber);
        pageData.setSize((long)pageSize);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/changeMaterialEnableState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeMaterialEnableState(@RequestParam(value="id") Long id, @RequestParam(value="enabled") Integer enabled) {
        WasteItemVO vo = this.materialService.queryDetail(id);
        if (vo == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        vo.setEnabled(enabled);
        this.materialService.update(vo);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

