/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.ConcretePlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.ConcretePlanEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.ConcretePlanMapper;
import com.ejianc.business.promaterial.plan.service.IConcretePlanService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.ConcretePlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.ConcretePlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.ConcretePlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="concretePlanService")
public class ConcretePlanServiceImpl
extends BaseServiceImpl<ConcretePlanMapper, ConcretePlanEntity>
implements IConcretePlanService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "CONCRETE_PLAN01";
    private static final String CHECK_MASTER_CODE = "P-UTS4Bh0187";
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public CommonResponse<ConcretePlanVO> saveOrUpdate(ConcretePlanVO saveOrUpdateVO) {
        ConcretePlanEntity entity = (ConcretePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConcretePlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<ConcretePlanDetailEntity> planDetailList = entity.getPlanDetailList();
        String materialName = "";
        if (CollectionUtils.isNotEmpty(planDetailList)) {
            ArrayList<ConcretePlanDetailEntity> list = new ArrayList<ConcretePlanDetailEntity>();
            for (ConcretePlanDetailEntity planDetail : planDetailList) {
                if (!"del".equals(planDetail.getRowState())) {
                    if (StringUtils.isNotBlank((CharSequence)planDetail.getMaterialName())) {
                        materialName = StringUtils.isNotBlank((CharSequence)materialName) ? materialName + "," + planDetail.getMaterialName() : planDetail.getMaterialName();
                    }
                    list.add(planDetail);
                }
                BigDecimal nums = planDetail.getNums() == null ? BigDecimal.ZERO : planDetail.getNums();
                BigDecimal occupyNums = planDetail.getOccupyNums() == null ? BigDecimal.ZERO : planDetail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                planDetail.setSurplusNums(surplusNums);
                planDetail.setOccupyNums(occupyNums);
                planDetail.setNums(nums);
            }
            Integer planFlag = entity.getPlanFlag() == null ? 1 : entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
            }
        } else {
            throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
        }
        super.saveOrUpdate((Object)entity, false);
        ConcretePlanVO vo = (ConcretePlanVO)BeanMapper.map((Object)((Object)entity), ConcretePlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<ConcretePlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper wrapper) {
        List<ConcretePlanDetailRefVO> planVOList = ((ConcretePlanMapper)this.baseMapper).getPlanByMaterialId(materialListId, wrapper);
        return planVOList;
    }

    @Override
    public ParamsCheckVO checkParams(ConcretePlanVO concretePlanVO, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMasterNum(concretePlanVO));
        paramsCheckVOS.addAll(this.checkParamsByMasterPrice(concretePlanVO));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsByMasterNum(ConcretePlanVO concretePlanVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)concretePlanVO.getProjectId())).eq((Object)"plan_type", (Object)1)));
        Map<Long, BigDecimal> masterMap = masterPlanEntity.getMasterPlanDetailList().stream().collect(Collectors.groupingBy(MasterPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MASTER_CODE, concretePlanVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    for (ConcretePlanDetailVO detailVO : concretePlanVO.getPlanDetailList()) {
                        if (!masterMap.containsKey(detailVO.getMaterialId())) continue;
                        if (detailVO.getNums().compareTo(masterMap.get(detailVO.getMaterialId())) == 1) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6df7\u51dd\u571f\u9700\u7528\u8ba1\u5212\u91cf\u8d85\u8fc7\u603b\u8ba1\u5212\u91cf");
                            paramsCheckDsVO.setWarnName("\u6df7\u51dd\u571f\u9700\u7528\u8ba1\u5212\u91cf\u8d85\u8fc7\u603b\u8ba1\u5212\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u9700\u7528\u8ba1\u5212\u91cf\uff1a").append(detailVO.getNums().setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u9700\u7528\u8ba1\u5212\u91cf\uff1a").append(detailVO.getCheckNum().setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u91cf*X%").append(roleValue).append("%:").append(masterMap.get(detailVO.getMaterialId()).setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getNums(), (BigDecimal)masterMap.get(detailVO.getMaterialId())).setScale(2, 4)).append("\u5143");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsByMasterPrice(ConcretePlanVO concretePlanVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)concretePlanVO.getProjectId())).eq((Object)"plan_type", (Object)1)));
        Map<Long, BigDecimal> masterMap = masterPlanEntity.getMasterPlanDetailList().stream().collect(Collectors.groupingBy(MasterPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPrice()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MASTER_CODE, concretePlanVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    for (ConcretePlanDetailVO detailVO : concretePlanVO.getPlanDetailList()) {
                        if (!masterMap.containsKey(detailVO.getMaterialId())) continue;
                        if (detailVO.getPrice().compareTo(masterMap.get(detailVO.getMaterialId())) == 1) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6d88\u8017\u9700\u7528\u8ba1\u5212\u5355\u4ef7\u8d85\u8fc7\u603b\u8ba1\u5212\u5355\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6df7\u51dd\u571f\u9700\u7528\u8ba1\u5212\u5355\u4ef7\u8d85\u8fc7\u603b\u8ba1\u5212\u5355\u4ef7");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u9700\u7528\u8ba1\u5212\u5355\u4ef7\uff1a").append(detailVO.getPrice().setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*X%").append(roleValue).append("%:").append(masterMap.get(detailVO.getMaterialId()).setScale(2, 4)).append("\u3002\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getPrice(), (BigDecimal)masterMap.get(detailVO.getMaterialId())).setScale(2, 4)).append("\u5143");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }
}

