/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.pricelib.bean.PriceCheckEntity;
import com.ejianc.business.promaterial.pricelib.bean.PriceContractEntity;
import com.ejianc.business.promaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.promaterial.pricelib.bean.PriceSettlementEntity;
import com.ejianc.business.promaterial.pricelib.enums.OutFlagEnum;
import com.ejianc.business.promaterial.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceCheckService;
import com.ejianc.business.promaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.promaterial.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.promaterial.pricelib.service.IPriceSettlementService;
import com.ejianc.business.promaterial.pricelib.vo.PriceCheckVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceContractVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceSettlementVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceTrendVo;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceContractService")
public class PriceContractServiceImpl
extends BaseServiceImpl<PriceContractMapper, PriceContractEntity>
implements IPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceCheckService priceCheckService;
    @Autowired
    private IPriceSettlementService priceSettlementService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public void savePriceContractByTiming(Date date) {
        List<ContractEntity> contractEntityList;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            contractEntityList = ((PriceContractMapper)this.baseMapper).getContractListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            contractEntityList = this.contractService.queryList(queryParam, false);
        }
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (CollectionUtils.isEmpty(contractEntityList)) {
            return;
        }
        List<Long> contractIdList = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<ContractDetailEntity> detailEntityList = ((PriceContractMapper)this.baseMapper).getContractDetailListByContractId(contractIdList);
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return;
        }
        List materialTypeIdList = detailEntityList.stream().map(ContractDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        CommonResponse materialResponse = this.materialApi.queryCategoryListByIds(materialTypeIdList);
        Map<Object, Object> materialCategoryMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)materialResponse));
        if (materialResponse.isSuccess()) {
            List materialCategoryVOList = (List)materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        }
        List projectIdList = contractEntityList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter("in", contractIdList));
        settleParam.getParams().put("signature_type", new Parameter("eq", (Object)1));
        settleParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List settlementEntityList = this.settlementService.queryList(settleParam, false);
        Map<Object, Object> settlementDateMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settlementEntityList)) {
            settlementDateMap = settlementEntityList.stream().collect(Collectors.toMap(SettlementEntity::getContractId, SettlementEntity::getSettlementDate, (key1, key2) -> key2));
        }
        Map<Long, List<ContractDetailEntity>> detailMap = detailEntityList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getContractId));
        ArrayList<PriceContractEntity> saveEntityList = new ArrayList<PriceContractEntity>();
        for (ContractEntity entity : contractEntityList) {
            List<ContractDetailEntity> entityDetailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(entityDetailList)) continue;
            for (Object detailEntity : entityDetailList) {
                if (detailEntity.getMaterialId() == null) continue;
                PriceContractEntity priceContractEntity = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                priceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceContractEntity.setSourceId(entity.getId());
                priceContractEntity.setSourceDetailId(detailEntity.getId());
                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                priceContractEntity.setMaterialId(detailEntity.getMaterialId());
                priceContractEntity.setMaterialCode(detailEntity.getMaterialCode());
                priceContractEntity.setMaterialName(detailEntity.getMaterialName());
                priceContractEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
                priceContractEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
                priceContractEntity.setInnerCode((String)materialCategoryMap.get(detailEntity.getMaterialTypeId()));
                priceContractEntity.setSpec(detailEntity.getSpec());
                priceContractEntity.setUnitId(detailEntity.getUnitId());
                priceContractEntity.setUnitName(detailEntity.getUnitName());
                priceContractEntity.setBrand(detailEntity.getBrand());
                priceContractEntity.setContractNum(detailEntity.getNum());
                priceContractEntity.setContractPrice(detailEntity.getPrice());
                priceContractEntity.setContractMny(detailEntity.getMoney());
                priceContractEntity.setContractTaxRate(detailEntity.getDetailTaxRate());
                priceContractEntity.setContractTaxMny(detailEntity.getDetailTaxMny());
                priceContractEntity.setContractTaxPrice(detailEntity.getDetailTaxPrice());
                priceContractEntity.setMemo(detailEntity.getMemo());
                priceContractEntity.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                priceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                priceContractEntity.setId(null);
                priceContractEntity.setCreateTime(null);
                priceContractEntity.setCreateUserCode(null);
                priceContractEntity.setUpdateTime(null);
                priceContractEntity.setUpdateUserCode(null);
                priceContractEntity.setDr(detailEntity.getDr());
                saveEntityList.add(priceContractEntity);
            }
        }
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(PriceContractEntity::getSourceDetailId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceDetailId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(PriceContractEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveEntityList) {
                PriceContractEntity queryEntity = (PriceContractEntity)((Object)queryPriceMap.get(entity.getSourceDetailId()));
                if (queryEntity == null) continue;
                entity.setId(queryEntity.getId());
                entity.setOutFlag(queryEntity.getOutFlag());
                entity.setCreateTime(queryEntity.getCreateTime());
                entity.setCreateUserCode(queryEntity.getCreateUserCode());
            }
        }
        this.logger.info("\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(saveEntityList));
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove((Wrapper)wrapper, false);
        List delIdList = saveEntityList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        this.logger.info("\u5220\u9664\u6570\u636eid\uff1a{}", (Object)JSONObject.toJSONString(delIdList));
        if (CollectionUtils.isNotEmpty(delIdList)) {
            super.removeByIds(delIdList, false);
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString(priceLibList));
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceLibList.size());
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList;
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        List<Long> orgIdList;
        Date endDate;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate = checkMap.get("endDate"), orgIdList = this.queryOrgIdList(), param);
        if (CollectionUtils.isEmpty(priceLibList)) {
            throw new BusinessException("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return priceLibList.get(0);
    }

    @Override
    public List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId) {
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)materialTypeId)) {
            String[] materialTypeIdList = materialTypeId.split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            for (String str : materialTypeIdList) {
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("innerCode", new Parameter("like_right", (Object)str));
                c1.getComplexParams().add(c2);
            }
            queryParam.getComplexParams().add(c1);
        }
        return this.queryPriceLibListAll(startDate, endDate, null, queryParam);
    }

    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate", "desc");
            param.getOrderMap().put("contractMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            int targetType = vo.getTargetResultId() == null ? 1 : 0;
            String url = "/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id=" + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag() + "&performanceStatus=" + vo.getPerformanceStatus() + "&targetType=" + targetType;
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(vo.getContractType())) {
                url = "/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id=" + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag() + "&performanceStatus=" + vo.getPerformanceStatus() + "&targetType=" + targetType;
            }
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setContractUrl(url);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public IPage<PriceCheckVO> queryPriceCheckListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("checkDate", "desc");
            param.getOrderMap().put("checkMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceCheckEntity> list = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)list.size());
        if (CollectionUtils.isEmpty(list)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(list, PriceCheckVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceCheckVO vo : voList) {
            String url = null;
            if (vo.getCheckType() == 0) {
                url = "/ejc-promaterial-frontend/#/check/contractCard?id=" + vo.getSourceId();
            } else if (vo.getCheckType() == 1) {
                url = "/ejc-promaterial-frontend/#/check/card?id=" + vo.getSourceId();
            } else if (vo.getCheckType() == 2) {
                url = "/ejc-promaterial-frontend/#/concreteCheck/contractCard?id=" + vo.getSourceId();
            } else if (vo.getCheckType() == 3) {
                url = "/ejc-promaterial-frontend/#/concreteCheck/card?id=" + vo.getSourceId();
            }
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setCheckUrl(url);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public IPage<PriceSettlementVO> queryPriceSettleListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("settlementDate", "desc");
            param.getOrderMap().put("settleMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceSettlementEntity> list = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)list.size());
        if (CollectionUtils.isEmpty(list)) {
            return pageDate;
        }
        HashMap<String, PriceSettlementEntity> map = new HashMap<String, PriceSettlementEntity>();
        for (PriceSettlementEntity entity : list) {
            String key = String.valueOf(entity.getSourceId()) + entity.getMaterialId() + entity.getSettlePrice() + entity.getSettleTaxRate();
            if (map.containsKey(key)) {
                PriceSettlementEntity value = (PriceSettlementEntity)((Object)map.get(key));
                value.setSettleNum(value.getSettleNum().add(entity.getSettleNum()));
                value.setSettleMny(value.getSettleMny().add(entity.getSettleMny()));
                value.setSettleTaxMny(value.getSettleTaxMny().add(entity.getSettleTaxMny()));
                value.setMemo(value.getMemo() + "," + value.getMemo());
                continue;
            }
            map.put(key, entity);
        }
        List voList = BeanMapper.mapList(new ArrayList(map.values()), PriceSettlementVO.class);
        pageDate.setTotal((long)voList.size());
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceSettlementVO vo : voList) {
            String url = null;
            if (vo.getSettlementType() == 0) {
                url = vo.getContractId() == null ? "/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getSourceId() : "/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getSourceId();
            } else if (vo.getSettlementType() == 1) {
                url = vo.getContractId() == null ? "/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getSourceId() : "/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getSourceId();
            }
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setSettleUrl(url);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendCheckList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceCheckEntity> checkList = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(checkList)) {
            Map<Date, List<PriceCheckEntity>> priceCheckMap = checkList.stream().collect(Collectors.groupingBy(PriceCheckEntity::getCheckDate));
            for (Map.Entry<Date, List<PriceCheckEntity>> entry : priceCheckMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceCheckEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceCheckEntity priceCheckEntity = list.get(0);
                List priceList = list.stream().map(PriceCheckEntity::getCheckPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceCheckEntity::getCheckTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceCheckEntity entity : list) {
                    num = num.add(entity.getCheckNum());
                    mny = mny.add(entity.getCheckMny());
                    taxMny = taxMny.add(entity.getCheckTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setCheckPrice(priceCheckEntity.getCheckPrice());
                vo.setCheckTaxPrice(priceCheckEntity.getCheckTaxPrice());
                vo.setCheckNum(num);
                vo.setCheckAvgPrice(avgPrice);
                vo.setCheckMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setCheckMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setCheckTaxAvgPrice(taxAvgPrice);
                vo.setCheckTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setCheckTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(dateStr);
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendSettleList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceSettlementEntity> settleList = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(settleList)) {
            Map<Date, List<PriceSettlementEntity>> settleMap = settleList.stream().collect(Collectors.groupingBy(PriceSettlementEntity::getSettlementDate));
            for (Map.Entry<Date, List<PriceSettlementEntity>> entry : settleMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceSettlementEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceSettlementEntity settlementEntity = list.get(0);
                List priceList = list.stream().map(PriceSettlementEntity::getSettlePrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceSettlementEntity::getSettleTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceSettlementEntity entity : list) {
                    num = num.add(entity.getSettleNum());
                    mny = mny.add(entity.getSettleMny());
                    taxMny = taxMny.add(entity.getSettleTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setSettlePrice(settlementEntity.getSettlePrice());
                vo.setSettleTaxPrice(settlementEntity.getSettleTaxPrice());
                vo.setSettleNum(num);
                vo.setSettleAvgPrice(avgPrice);
                vo.setSettleMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setSettleMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setSettleTaxAvgPrice(taxAvgPrice);
                vo.setSettleTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setSettleTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(dateStr);
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = (PriceContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void removePriceCheckDetail(Long id) {
        PriceCheckEntity entity = (PriceCheckEntity)((Object)this.priceCheckService.selectById(id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        this.priceCheckService.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void removePriceSettleDetail(Long id) {
        PriceSettlementEntity entity = (PriceSettlementEntity)((Object)this.priceSettlementService.selectById(id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        this.priceSettlementService.saveOrUpdate((Object)entity, false);
    }

    private Map<String, Date> checkQueryParam(QueryParam param) {
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        if (!paramMap.containsKey("materialId")) {
            throw new BusinessException("\u67e5\u8be2\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Date> rtnMap = new HashMap<String, Date>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        HashMap<Long, PriceLibVO> map = new HashMap<Long, PriceLibVO>();
        this.queryPriceContractGroupByMaterialId(map, startDate, orgIdList, param);
        this.logger.info("\u67e5\u8be2\u5408\u540c\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        this.queryPriceCheckGroupByMaterialId(map, startDate, endDate, orgIdList, param);
        this.logger.info("\u67e5\u8be2\u9a8c\u6536\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        this.queryPriceSettlementGroupByMaterialId(map, startDate, endDate, orgIdList, param);
        this.logger.info("\u67e5\u8be2\u7ed3\u7b97\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        this.queryPriceGuide(map);
        this.logger.info("\u67e5\u8be2\u6307\u5bfc\u4ef7\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        ArrayList<PriceLibVO> priceLibList = new ArrayList<PriceLibVO>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
            priceLibList.sort(Comparator.comparing(PriceLibVO::getMaterialCode, Comparator.nullsLast(String::compareTo)));
        }
        this.logger.info("\u67e5\u8be2\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(priceLibList));
        return priceLibList;
    }

    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList, QueryParam param) {
        QueryParam contractParam = new QueryParam();
        List fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("performance_status", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("performance_status", new Parameter("in", Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter("ge", (Object)startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        this.logger.info("\u67e5\u8be2\u5408\u540c\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)contractParam));
        return super.queryList(contractParam, false);
    }

    private void queryPriceContractGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, List<Long> orgIdList, QueryParam param) {
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) {
            return;
        }
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceContractEntity entity : value) {
                num = num.add(entity.getContractNum());
                mny = mny.add(entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
        }
    }

    private List<PriceCheckEntity> queryPriceCheckList(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        queryParam.setSearchText(param.getSearchText());
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            queryParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                queryParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                queryParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        String sb = DateUtils.transformationDefaultDate(startDate) + "," + DateUtils.transformationDefaultDate(endDate);
        queryParam.getParams().put("checkDate", new Parameter("between", (Object)sb));
        this.logger.info("\u67e5\u8be2\u9a8c\u6536\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        return this.priceCheckService.queryList(queryParam, false);
    }

    private void queryPriceCheckGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        List<PriceCheckEntity> checkList = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(checkList)) {
            return;
        }
        Map<Long, List<PriceCheckEntity>> priceCheckMap = checkList.stream().collect(Collectors.groupingBy(PriceCheckEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceCheckEntity>> entry : priceCheckMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceCheckEntity> value = entry.getValue();
            List priceList = value.stream().filter(item -> null != item.getCheckPrice()).map(PriceCheckEntity::getCheckPrice).collect(Collectors.toList());
            List taxPriceList = value.stream().filter(item -> null != item.getCheckTaxPrice()).map(PriceCheckEntity::getCheckTaxPrice).collect(Collectors.toList());
            PriceCheckEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceCheckEntity entity : value) {
                num = num.add(entity.getCheckNum() == null ? BigDecimal.ZERO : entity.getCheckNum());
                mny = mny.add(entity.getCheckMny() == null ? BigDecimal.ZERO : entity.getCheckMny());
                taxMny = taxMny.add(entity.getCheckTaxMny() == null ? BigDecimal.ZERO : entity.getCheckTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setCheckNum(num);
            priceLibVO.setCheckMny(mny);
            priceLibVO.setCheckTaxRate(taxRate);
            priceLibVO.setCheckTaxMny(taxMny);
            priceLibVO.setCheckAvgPrice(avgPrice);
            priceLibVO.setCheckMaxPrice(maxPrice);
            priceLibVO.setCheckMinPrice(minPrice);
            priceLibVO.setCheckPriceArea(priceArea);
            priceLibVO.setCheckTaxAvgPrice(taxAvgPrice);
            priceLibVO.setCheckTaxMaxPrice(taxMaxPrice);
            priceLibVO.setCheckTaxMinPrice(taxMinPrice);
            priceLibVO.setCheckTaxPriceArea(taxPriceArea);
        }
    }

    private List<PriceSettlementEntity> queryPriceSettlementList(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        queryParam.setSearchText(param.getSearchText());
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            queryParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                queryParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                queryParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        String sb = DateUtils.transformationDefaultDate(startDate) + "," + DateUtils.transformationDefaultDate(endDate);
        queryParam.getParams().put("settlementDate", new Parameter("between", (Object)sb));
        this.logger.info("\u67e5\u8be2\u7ed3\u7b97\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        return this.priceSettlementService.queryList(queryParam, false);
    }

    private void queryPriceSettlementGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        List<PriceSettlementEntity> settleList = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(settleList)) {
            return;
        }
        Map<Long, List<PriceSettlementEntity>> priceCheckMap = settleList.stream().collect(Collectors.groupingBy(PriceSettlementEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceSettlementEntity>> entry : priceCheckMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceSettlementEntity> value = entry.getValue();
            List priceList = value.stream().map(PriceSettlementEntity::getSettlePrice).collect(Collectors.toList());
            List taxPriceList = value.stream().map(PriceSettlementEntity::getSettleTaxPrice).collect(Collectors.toList());
            PriceSettlementEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceSettlementEntity entity : value) {
                num = num.add(entity.getSettleNum());
                mny = mny.add(entity.getSettleMny());
                taxMny = taxMny.add(entity.getSettleTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setSettleNum(num);
            priceLibVO.setSettleMny(mny);
            priceLibVO.setSettleTaxRate(taxRate);
            priceLibVO.setSettleTaxMny(taxMny);
            priceLibVO.setSettleAvgPrice(avgPrice);
            priceLibVO.setSettleMaxPrice(maxPrice);
            priceLibVO.setSettleMinPrice(minPrice);
            priceLibVO.setSettlePriceArea(priceArea);
            priceLibVO.setSettleTaxAvgPrice(taxAvgPrice);
            priceLibVO.setSettleTaxMaxPrice(taxMaxPrice);
            priceLibVO.setSettleTaxMinPrice(taxMinPrice);
            priceLibVO.setSettleTaxPriceArea(taxPriceArea);
        }
    }

    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (!guideMap.containsKey(materialId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(materialId));
            BigDecimal min = guide.getMinMny() == null ? BigDecimal.ZERO : guide.getMinMny();
            BigDecimal max = guide.getMaxMny() == null ? BigDecimal.ZERO : guide.getMaxMny();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }

    private List<Long> queryOrgIdList() {
        CommonResponse orgIdListResponse = this.priceDepotPowerSetApi.queryOrgList(InvocationInfoProxy.getOrgId());
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\u5931\u8d25:" + orgIdListResponse.getMsg());
        }
        return (List)orgIdListResponse.getData();
    }

    private List<Long> getMyOrgList() {
        CommonResponse orgVOResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgVOResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            return orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, 4).subtract(BigDecimal.ONE).multiply(b);
    }
}

