package com.ejianc.business.promaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.different.bean.DifferentDetailEntity;
import com.ejianc.business.promaterial.different.bean.DifferentEntity;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.promaterial.out.vo.*;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementCollectVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementVO;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.out.mapper.OutStoreMapper;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import springfox.documentation.spring.web.json.Json;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 领料出库
 * 
 * @author generator
 * 
 */
@Service("outStoreService")
public class OutStoreServiceImpl extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private JedisPool jedisPool;
    private final String  OPERATE= "PROMATERIAL_OUT";
    @Value("${common.env.base-host}")
    private String BaseHost;

    private static final String BILL_TYPE = "BT220215000000004";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/outStore/saveOutStore";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/outStore/deleteOutStore";
    private static final String BILL_CODE = "PROMATERIAL_OUT";//此处需要根据实际修改
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<OutStoreVO> saveOrUpdate(OutStoreVO outStoreVO) {

        if(CollectionUtils.isEmpty(outStoreVO.getOutStoreSubList())) {
            throw new BusinessException("子表数据不能为空!");
        }else{
            List<OutStoreSubVO> list = new ArrayList<>();
            outStoreVO.getOutStoreSubList().forEach(e->{
                if(!"del".equals(e.getRowState())){
                    list.add(e);
                }
            });
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("子表数据不能为空!");
            }
        }

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outStoreVO.getParentOrgCode()) && outStoreVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outStoreVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                outStoreVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outStoreVO.getOrgCode()) && outStoreVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outStoreVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                outStoreVO.setOrgCode(orgVO.getCode());
            }
        }
        OutStoreEntity entity = BeanMapper.map(outStoreVO, OutStoreEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),outStoreVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setSignStatus(0);//签字信息初始化
        entity.setRelationFlag("0");//关联状态初始化
        entity.setProportionFlag("0");//分摊状态初始化
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        super.saveOrUpdate(entity, false);
        //调用库存逻辑
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreVO.getStoreId());
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
        storeManageVO.setOutEffectiveON(false);
        ArrayList<FlowVO> flowVOS = new ArrayList<>();
        //循环删除的数据
        outStoreVO.getOutStoreSubList().forEach(t->{
            if("del".equals(t.getRowState())){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
                flowVO.setStoreId(outStoreVO.getStoreId());
                flowVO.setStoreName(outStoreVO.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(outStoreVO.getEmployeeId());
                flowVO.setEmployeeName(outStoreVO.getEmployeeName());
                flowVO.setSupplierId(entity.getSubSupplierId());
                flowVO.setSupplierName(entity.getSubSupplierName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                flowVO.setTaxMny(t.getTaxMoney());
                flowVO.setMny(t.getMoney());
                flowVO.setTax(t.getOutTax());
                flowVO.setUseFor(outStoreVO.getUseFor());
                flowVO.setSubEmployeeName(outStoreVO.getSubEmployeeName());
                flowVO.setPickUnitId(entity.getSubSupplierId());
                flowVO.setPickUnitName(entity.getSubSupplierName());
                flowVO.setPickContractId(entity.getSubContractId());
                flowVO.setPickContractName(entity.getSubContractName());

                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode("BT220215000000004");
                flowVO.setSourceBillTypeName("领料出库");
                flowVO.setSourceType(1);//  0-自制,1-订单
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPickType(entity.getClaimType());//claimType; // 领料方式，1-分包领料,2-内部领料
                flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
                flowVOS.add(flowVO);
            }
        });
        //循环新增修改的数据
        entity.getOutStoreSubList().forEach(t->{
            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
            flowVO.setStoreId(outStoreVO.getStoreId());
            flowVO.setStoreName(outStoreVO.getStoreName());
            flowVO.setProjectId(entity.getProjectId());
            flowVO.setProjectName(entity.getProjectName());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setParentOrgId(entity.getParentOrgId());
            flowVO.setParentOrgName(entity.getParentOrgName());
            flowVO.setEmployeeId(outStoreVO.getEmployeeId());
            flowVO.setEmployeeName(outStoreVO.getEmployeeName());
            flowVO.setSupplierId(entity.getSubSupplierId());
            flowVO.setSupplierName(entity.getSubSupplierName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialCode(t.getMaterialCode());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getSpec());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setTaxPrice(t.getTaxPrice());
            flowVO.setPrice(t.getPrice());
            flowVO.setNum(t.getNum());
            flowVO.setTaxMny(t.getTaxMoney());
            flowVO.setMny(t.getMoney());
            flowVO.setTax(t.getOutTax());
            flowVO.setUseFor(entity.getUseFor());
            flowVO.setSubEmployeeName(entity.getSubEmployeeName());
            flowVO.setPickUnitId(entity.getSubSupplierId());
            flowVO.setPickUnitName(entity.getSubSupplierName());
            flowVO.setPickContractId(entity.getSubContractId());
            flowVO.setPickContractName(entity.getSubContractName());

            flowVO.setSourceId(entity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(entity.getBillCode());
            flowVO.setSourceBillTypeCode("BT220215000000004");
            flowVO.setSourceBillTypeName("领料出库");
            flowVO.setSourceType(1);//  0-自制,1-订单
            flowVO.setSourceBillDate(entity.getOutDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(entity.getMemo());
            flowVO.setPickType(entity.getClaimType());//claimType; // 领料方式，1-分包领料,2-内部领料
            flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        logger.debug("参数：————"+JSONObject.toJSONString(storeManageVO));
        CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
        if(!response.isSuccess()) {
            throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
        }
        OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> del(List<OutStoreVO> vos) {

        Collection<OutStoreEntity> list = super.listByIds(vos.stream().map(OutStoreVO::getId).collect(Collectors.toList()));
        Map<Long,List<Long>> map = new HashMap<>();
        list.forEach(e->{
            if(map.containsKey(e.getStoreId())){
                map.get(e.getStoreId()).add(e.getId());
            }else{
                List<Long> idList = new ArrayList<>();
                idList.add(e.getId());
                map.put(e.getStoreId(),idList);
            }
        });
        map.forEach((key, value) -> {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(key);
            storeManageVO.setSourceIdsForRollBack(value);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
            storeManageVO.setOutEffectiveON(false);
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        });
        super.removeByIds(vos.stream().map(OutStoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        OutStoreEntity outStoreEntity = super.selectById(billId);
        //设置供方签字信息
        outStoreEntity.setSupOperateTime(supOperateTime);
        outStoreEntity.setSupOperatorName(supOperatorName);
        outStoreEntity.setSupOperatorPhone(supOperatorPhone);
        outStoreEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + outStoreEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", outStoreEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, outStoreEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            outStoreEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            outStoreEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(outStoreEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", outStoreEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    /*推送供方*/
    @Override
    public boolean pushBillToSupCenter(OutStoreEntity entity) {
        if(null!=entity.getClaimType() && 2==entity.getClaimType()){//1-分包领料，2-内部领料   当领料方式为【内部领料】时，不推协同；历史数据的值都为【分包领料】；
            return false;
        }
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupOutStoreVO supOutStoreVO = BeanMapper.map(entity, SupOutStoreVO.class);
            List<SupOutStoreSubVO> subVOS = BeanMapper.mapList(entity.getOutStoreSubList(), SupOutStoreSubVO.class);
            supOutStoreVO.setOutStoreSubList(subVOS);
            paramMap.put("transData", JSONObject.toJSONString(supOutStoreVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }

                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSubSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSubSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSubSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSubSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取出库单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送出库单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSubSupplierId(), e);
//            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(OutStoreEntity entity) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSubSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DELPUSH_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSubSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSubSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSubSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    @Override
    public CommonResponse<OutStoreVO> pushCost(OutStoreVO outStoreVO) {
        OutStoreEntity entity = baseMapper.selectById(outStoreVO.getId());
        if (CollectionUtils.isNotEmpty(outStoreVO.getOutStoreSubList())) {
            List<OutStoreSubEntity> storeSubEntityList = BeanMapper.mapList(outStoreVO.getOutStoreSubList(), OutStoreSubEntity.class);
            entity.setOutStoreSubList(storeSubEntityList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, OutStoreVO.class));
    }
    @Override
    public void costPush(OutStoreEntity outStoreEntity) {
        logger.info("开始costPush");
        List<OutStoreSubEntity> outStoreSubList = outStoreEntity.getOutStoreSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (OutStoreSubEntity storeSubEntity : outStoreSubList) {
                if (null == storeSubEntity.getSubjectId() || null == storeSubEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(outStoreSubList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = outStoreEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(outStoreEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",outStoreEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(outStoreEntity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                //税率
                saveCost(outStoreEntity);
            }
        }
        //更新是否关联
        LambdaUpdateWrapper<OutStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OutStoreEntity::getId, outStoreEntity.getId());
        updateWrapper.set(OutStoreEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        outStoreEntity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(OutStoreEntity outStoreEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<OutStoreSubEntity> outStoreSubList = outStoreEntity.getOutStoreSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(outStoreSubList)) {
            for (OutStoreSubEntity outStoreSubEntity : outStoreSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setMaterialId(outStoreSubEntity.getMaterialId());
                costDetailVO.setMaterialName(outStoreSubEntity.getMaterialName());
                costDetailVO.setMaterialCode(outStoreSubEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(outStoreSubEntity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(outStoreSubEntity.getMaterialCategoryName());
                costDetailVO.setSpec(outStoreSubEntity.getSpec());
                costDetailVO.setUnit(outStoreSubEntity.getUnit());
                costDetailVO.setUnitId(outStoreSubEntity.getUnitId());
                costDetailVO.setSourceBillCode(outStoreEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.领料出库.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-promaterial-frontend/#/outStore/card?id=" + outStoreEntity.getId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectId(outStoreSubEntity.getSubjectId());
                costDetailVO.setSubjectCode(outStoreSubEntity.getSubjectCode());
                costDetailVO.setSubjectName(outStoreSubEntity.getSubjectName());
                costDetailVO.setNum(outStoreSubEntity.getNum());
                costDetailVO.setWbsId(outStoreSubEntity.getWbsId());
                costDetailVO.setWbsCode(outStoreSubEntity.getWbsCode());
                costDetailVO.setWbsName(outStoreSubEntity.getWbsName());
                costDetailVO.setSourceId(outStoreSubEntity.getOutStoreId());
                costDetailVO.setSourceDetailId(outStoreSubEntity.getId());
                costDetailVO.setHappenTaxMny(outStoreSubEntity.getTaxMoney());
                costDetailVO.setHappenMny(outStoreSubEntity.getMoney());
                costDetailVO.setHappenDate(outStoreEntity.getOutDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("OUT_STORE");
                costDetailVO.setSourceTabType("OUT_STORE_SUB");
                costDetailVO.setProjectId(outStoreEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
