/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckAdmixtureEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckWeighEntity;
import com.ejianc.business.promaterial.check.mapper.ConcreteCheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckAdmixtureService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckDetailService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckImgDetailService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckWeighService;
import com.ejianc.business.promaterial.check.vo.CheckWeighTypeEnum;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckAdmixtureVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckWeighVO;
import com.ejianc.business.promaterial.check.vo.WeighUnitEnum;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="concreteCheckService")
public class ConcreteCheckServiceImpl
extends BaseServiceImpl<ConcreteCheckMapper, ConcreteCheckEntity>
implements IConcreteCheckService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;
    private static final String BILL_CODE = "HNT-CHECK";
    private final String OPERATE = "HNT_CHECK_SYNC";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IConcreteDeliveryDetailService concreteDeliveryDetailService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IConcreteCheckDetailService concreteCheckDetailService;
    @Autowired
    private IConcreteDeliveryService concreteDeliveryService;
    @Autowired
    private IConcreteCheckAdmixtureService concreteCheckAdmixtureService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState";
    private static final String BILL_TYPE = "BT220224000000004";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IConcreteCheckWeighService concreteCheckWeighService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporaryUseRecordApi temporaryUseRecordApi;
    @Autowired
    private IConcreteCheckImgDetailService concreteCheckImgDetailService;
    private static final String CHECK_PARAM_CODE = "P-68U82Z74";
    private static final String CHECK_MNY_CON_CODE = "P-n01oAU0146";
    private static final String CHECK_MNY_CODE = "P-2dnh8V0139";
    private static final String CHECK_SUB_MNY_CODE = "P-Tl9Zyr0141";

    @Override
    public ConcreteCheckVO saveOrUpdates(ConcreteCheckVO saveOrUpdateVO, Boolean isControl) {
        OrgVO orgVO;
        CommonResponse orgResponse;
        ConcreteCheckEntity concreteCheckEntity;
        Integer attrFlag;
        if (!isControl.booleanValue() && saveOrUpdateVO.getId() != null && (attrFlag = (concreteCheckEntity = (ConcreteCheckEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()))).getAttrFlag()) == 1 && saveOrUpdateVO.getAttrFlag() == 2) {
            ArrayList totalExecutionVOList = new ArrayList();
            ExecutionVO executionDelVO = this.targetCost(concreteCheckEntity);
            totalExecutionVOList.add(executionDelVO.getTotalVO());
            CommonResponse responses = this.executionApi.aggDel((List)totalExecutionVOList);
            if (!responses.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25" + responses.getMsg());
            }
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
        }
        if (!(isControl.booleanValue() || saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() != 0L)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            saveOrUpdateVO.setBillCode((String)billCode.getData());
            if (null == saveOrUpdateVO.getCheckWeighType()) {
                saveOrUpdateVO.setCheckWeighType(CheckWeighTypeEnum.\u5426\u78c5\u5355\u9a8c\u6536.getCode());
            }
            if (null == saveOrUpdateVO.getAutomaticWeigh()) {
                saveOrUpdateVO.setAutomaticWeigh(Integer.valueOf(1));
            }
        }
        if (saveOrUpdateVO.getId() == null) {
            long id = IdWorker.getId();
            saveOrUpdateVO.setId(Long.valueOf(id));
        }
        List concreteCheckDetailList = saveOrUpdateVO.getConcreteCheckDetailList();
        ArrayList<ConcreteCheckAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteCheckAdmixtureEntity>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)concreteCheckDetailList)) {
            for (ConcreteCheckDetailVO concreteCheckDetailVO : concreteCheckDetailList) {
                List admixtureVOList;
                if (concreteCheckDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    concreteCheckDetailVO.setId(Long.valueOf(id));
                }
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(admixtureVOList = concreteCheckDetailVO.getAdmixtureVOList()))) continue;
                for (Object concreteCheckAdmixtureVO : admixtureVOList) {
                    concreteCheckAdmixtureVO.setDetailId(concreteCheckDetailVO.getId());
                    ConcreteCheckAdmixtureEntity concreteCheckAdmixtureEntity = (ConcreteCheckAdmixtureEntity)((Object)BeanMapper.map((Object)concreteCheckAdmixtureVO, ConcreteCheckAdmixtureEntity.class));
                    concreteCheckAdmixtureEntity.setId(null);
                    concreteCheckAdmixtureEntity.setCheckId(saveOrUpdateVO.getId());
                    admixtureArrayList.add(concreteCheckAdmixtureEntity);
                }
            }
        }
        List ids = concreteCheckDetailList.stream().map(BaseVO::getId).collect(Collectors.toList());
        ConcreteCheckEntity entity = (ConcreteCheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConcreteCheckEntity.class));
        entity.setConcreteCheckAdmixtureList(null);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ConcreteCheckAdmixtureEntity::getDetailId, ids);
        if (!isControl.booleanValue()) {
            this.concreteCheckAdmixtureService.remove((Wrapper)wrapper, false);
            this.concreteCheckAdmixtureService.saveBatch(admixtureArrayList);
        }
        entity.setStoreType(1);
        entity.setSignStatus(0);
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        entity.setCheckType("contractConcrete-1");
        entity.setCheckTypeName(" \u6df7\u51dd\u571f\u5408\u540c");
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        if (!isControl.booleanValue()) {
            if (null != entity.getId()) {
                this.concreteCheckImgDetailService.deleteByPid(entity.getId());
            }
            if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
                ArrayList<ConcreteCheckWeighEntity> checkWeighListDel = new ArrayList<ConcreteCheckWeighEntity>();
                for (ConcreteCheckWeighEntity checkWeighEntity : entity.getConcreteCheckWeighList()) {
                    if (!"del".equals(checkWeighEntity.getRowState())) continue;
                    checkWeighListDel.add(checkWeighEntity);
                }
                this.delWeighBill(checkWeighListDel);
            }
            super.saveOrUpdate((Object)entity, false);
            if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
                this.addOrUpdateWeighBill(entity.getConcreteCheckDetailList(), entity.getConcreteCheckWeighList());
            }
        }
        Integer checkStatus = 0;
        ConcreteDeliveryEntity concreteDeliveryEntity = (ConcreteDeliveryEntity)((Object)this.concreteDeliveryService.selectById(entity.getDeliveryId()));
        if (entity.getSourceType() == 1 && !isControl.booleanValue()) {
            LambdaQueryWrapper lambdaConcreteCheckDetail = Wrappers.lambdaQuery();
            lambdaConcreteCheckDetail.eq(ConcreteCheckDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List ConcreteCheckDetailEntityList = this.concreteCheckDetailService.list((Wrapper)lambdaConcreteCheckDetail);
            if (CollectionUtils.isNotEmpty((Collection)ConcreteCheckDetailEntityList)) {
                Map<Long, List<ConcreteCheckDetailEntity>> checkMap = ConcreteCheckDetailEntityList.stream().collect(Collectors.groupingBy(ConcreteCheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(ConcreteDeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.concreteDeliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (ConcreteDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<ConcreteCheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(ConcreteCheckDetailEntity::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null != deliveryDetailEntity.getCheckNum()) continue;
                    deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = 2;
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = 1;
                }
                concreteDeliveryEntity.setCheckStatus(checkStatus);
                this.concreteDeliveryService.updateById((Object)concreteDeliveryEntity);
                this.concreteDeliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(concreteDeliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", concreteDeliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(concreteDeliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState", RequestMethod.POST, concreteDeliveryEntity.getSupplierId().toString(), "HNT_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        if (!isControl.booleanValue() && entity.getAttrFlag() == 1) {
            ExecutionVO executionVO = this.targetCost(entity);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
            }
        }
        if (!isControl.booleanValue()) {
            return this.queryDetail(entity.getId());
        }
        return (ConcreteCheckVO)BeanMapper.map((Object)((Object)entity), ConcreteCheckVO.class);
    }

    private void delWeighBill(List<ConcreteCheckWeighEntity> concreteCheckWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(concreteCheckWeighList)) {
            for (ConcreteCheckWeighEntity concreteCheckWeighEntity : concreteCheckWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(concreteCheckWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(concreteCheckWeighEntity.getId());
                weighbillVO.setId(concreteCheckWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(0));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u4fdd\u5b58\u5220\u9664\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private void addOrUpdateWeighBill(List<ConcreteCheckDetailEntity> concreteCheckDetailList, List<ConcreteCheckWeighEntity> concreteCheckWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(concreteCheckWeighList)) {
            for (ConcreteCheckWeighEntity concreteCheckWeighEntity : concreteCheckWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(concreteCheckDetailList)) {
                    for (ConcreteCheckDetailEntity concreteCheckDetailEntity : concreteCheckDetailList) {
                        if (null == concreteCheckWeighEntity.getDeliveryDetailId() || !concreteCheckWeighEntity.getDeliveryDetailId().equals(concreteCheckDetailEntity.getDeliveryDetailId())) continue;
                        weighbillVO.setCheckId(concreteCheckDetailEntity.getCheckId());
                        weighbillVO.setCheckDetailId(concreteCheckDetailEntity.getId());
                        concreteCheckWeighEntity.setCheckDetailId(concreteCheckDetailEntity.getId());
                        concreteCheckWeighEntity.setCheckStatus(1);
                    }
                }
                weighbillVO.setId(concreteCheckWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(1));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(concreteCheckWeighList)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u66f4\u65b0\u9a8c\u6536\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(concreteCheckWeighList));
            this.concreteCheckWeighService.updateBatchById(concreteCheckWeighList);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private ExecutionVO targetCost(ConcreteCheckEntity checkEntity) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(checkEntity.getId());
        totalVO.setTenantId(checkEntity.getTenantId());
        totalVO.setBillCode(checkEntity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u9a8c\u6536\u5355.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5165\u5e93.getCode());
        totalVO.setProjectId(checkEntity.getProjectId());
        totalVO.setOrgId(checkEntity.getOrgId());
        String url = null;
        if (checkEntity.getContractId() == null) {
            url = this.baseHost + "ejc-promaterial-frontend/#/concreteCheck/card?id=" + checkEntity.getId();
        }
        if (checkEntity.getContractId() != null) {
            url = this.baseHost + "ejc-promaterial-frontend/#/concreteCheck/contractCard?id=" + checkEntity.getId();
        }
        totalVO.setLinkUrl(url);
        totalVO.setBillDate(checkEntity.getCheckDate() == null ? null : checkEntity.getCheckDate().toString());
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (ConcreteCheckDetailEntity checkDetailEntity : checkEntity.getConcreteCheckDetailList()) {
            if (checkDetailEntity.getRowState() != null && checkDetailEntity.getRowState().equals("del")) continue;
            checkMoney = checkMoney.add(checkDetailEntity.getCheckMny());
            checkTaxMoney = checkTaxMoney.add(checkDetailEntity.getCheckTaxMny());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(Long.valueOf(checkDetailEntity.getId() == null ? IdWorker.getId() : checkDetailEntity.getId()));
            detailExecutionVO.setSourceBillId(checkEntity.getId());
            detailExecutionVO.setCategoryId(checkDetailEntity.getMaterialTypeId());
            detailExecutionVO.setCategoryName(checkDetailEntity.getMaterialTypeName());
            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
            detailExecutionVO.setCode(checkDetailEntity.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(checkDetailEntity.getMaterialTypeId()).getData();
            if (categoryVO == null) {
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            } else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(checkDetailEntity.getMaterialId());
            detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
            detailExecutionVO.setName(checkDetailEntity.getMaterialName());
            detailExecutionVO.setUnitId(checkDetailEntity.getUnitId());
            detailExecutionVO.setUnitName(checkDetailEntity.getUnit());
            detailExecutionVO.setNum(checkDetailEntity.getCheckNum());
            detailExecutionVO.setMoney(checkDetailEntity.getCheckMny());
            detailExecutionVO.setTaxMoney(checkDetailEntity.getCheckTaxMny());
            detailExecutionVO.setPrice(checkDetailEntity.getCheckPrice());
            detailExecutionVO.setTaxPrice(checkDetailEntity.getCheckTaxPrice());
            detailExecutionVO.setTaxRate(checkDetailEntity.getTaxRate());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void deletes(List<ConcreteCheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        ConcreteCheckVO concreteCheckVO = vos.get(0);
        ConcreteCheckEntity concreteCheckEntity = (ConcreteCheckEntity)((Object)super.selectById((Serializable)concreteCheckVO.getId()));
        List<ConcreteCheckDetailEntity> checkDetailList = concreteCheckEntity.getConcreteCheckDetailList();
        List<ConcreteCheckWeighEntity> concreteCheckWeighList = concreteCheckEntity.getConcreteCheckWeighList();
        ConcreteDeliveryEntity deliveryEntity = (ConcreteDeliveryEntity)((Object)this.concreteDeliveryService.selectById(concreteCheckEntity.getDeliveryId()));
        if (deliveryEntity != null) {
            List<ConcreteDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getConcreteDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(ConcreteCheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (ConcreteDeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
                ConcreteCheckDetailEntity checkDetailEntity = (ConcreteCheckDetailEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
                deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
            }
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
            Integer checkStatus = 0;
            if (allCheck.booleanValue()) {
                checkStatus = 2;
            }
            if (anyCheck.booleanValue()) {
                checkStatus = 1;
            }
            deliveryEntity.setCheckStatus(checkStatus);
            this.concreteDeliveryService.updateById((Object)deliveryEntity);
            this.concreteDeliveryDetailService.updateBatchById(deliveryDetailList);
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "HNT_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vos)) {
            CommonResponse response;
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (ConcreteCheckVO checkVO1 : vos) {
                ConcreteCheckEntity checkEntity1 = (ConcreteCheckEntity)((Object)super.selectById((Serializable)checkVO1.getId()));
                ExecutionVO executionVO = this.targetCost(checkEntity1);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            if (concreteCheckEntity.getAttrFlag() == 1 && !(response = this.executionApi.aggDel(totalExecutionVOList)).isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25" + response.getMsg());
            }
        }
        this.delWeighBill(concreteCheckWeighList);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        ConcreteCheckEntity checkEntity = (ConcreteCheckEntity)((Object)super.selectById((Serializable)((Object)billId)));
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220224000000004::" + checkEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"HNT_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)checkEntity.getId());
                this.releaseLock(jedis, false, key, "HNT_CHECK_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, checkEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            checkEntity.setAttachIds(attchIdsList);
            checkEntity.setSignStatus(1);
            super.saveOrUpdate((Object)checkEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)checkEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "HNT_CHECK_SYNC");
        }
        return msg;
    }

    @Override
    public CommonResponse<ConcreteCheckVO> pushCost(ConcreteCheckVO checkVO) {
        ConcreteCheckEntity checkEntity = (ConcreteCheckEntity)((Object)((ConcreteCheckMapper)this.baseMapper).selectById(checkVO.getId()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)checkVO.getConcreteCheckDetailList())) {
            List checkDetailEntityList = BeanMapper.mapList((Iterable)checkVO.getConcreteCheckDetailList(), ConcreteCheckDetailEntity.class);
            checkEntity.setConcreteCheckDetailList(checkDetailEntityList);
        }
        super.saveOrUpdate((Object)checkEntity, false);
        if (checkEntity.getAttrFlag().equals(1)) {
            this.costPush(checkEntity);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)checkEntity), ConcreteCheckVO.class));
    }

    @Override
    public void costPush(ConcreteCheckEntity checkEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<ConcreteCheckDetailEntity> checkDetailList = checkEntity.getConcreteCheckDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailList)) {
            for (ConcreteCheckDetailEntity checkDetailEntity : checkDetailList) {
                if (null != checkDetailEntity.getSubjectId() && null != checkDetailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(checkDetailList)) {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(ConcreteCheckEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = checkEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(checkEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)checkEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(checkEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(checkEntity);
        }
    }

    @Override
    public ConcreteCheckVO getConcreteDetailListData(ConcreteCheckVO checkVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        List checkDetailListPC = checkVO.getConcreteCheckDetailList();
        Map contractDetailEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
        for (ConcreteCheckDetailVO checkDetailVO : checkDetailListPC) {
            if (contractDetailEntityMap.containsKey(checkDetailVO.getMaterialId())) {
                ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)contractDetailEntityMap.get(checkDetailVO.getMaterialId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            checkDetailVO.setTaxRate(contractEntity.getTaxRate());
        }
        return checkVO;
    }

    @Override
    public ConcreteCheckVO queryDetail(Long id) {
        ConcreteCheckEntity entity = (ConcreteCheckEntity)((Object)super.selectById((Serializable)id));
        ConcreteCheckVO vo = (ConcreteCheckVO)BeanMapper.map((Object)((Object)entity), ConcreteCheckVO.class);
        List concreteCheckDetailList = vo.getConcreteCheckDetailList();
        List concreteCheckAdmixtureList = vo.getConcreteCheckAdmixtureList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)concreteCheckAdmixtureList)) {
            Map<Long, List<ConcreteCheckAdmixtureVO>> bidderMap = concreteCheckAdmixtureList.stream().collect(Collectors.groupingBy(ConcreteCheckAdmixtureVO::getDetailId));
            if (CollectionUtils.isNotEmpty((Collection)concreteCheckDetailList)) {
                for (ConcreteCheckDetailVO concreteCheckDetailVO : concreteCheckDetailList) {
                    List<ConcreteCheckAdmixtureVO> admixtureVOList = bidderMap.get(concreteCheckDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(admixtureVOList)) continue;
                    concreteCheckDetailVO.setAdmixtureVOList(admixtureVOList);
                }
            }
        }
        return vo;
    }

    private void saveCost(ConcreteCheckEntity checkEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<ConcreteCheckDetailEntity> checkDetailList = checkEntity.getConcreteCheckDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailList)) {
            for (ConcreteCheckDetailEntity checkDetailEntity : checkDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(checkDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(checkDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(checkDetailEntity.getSubjectName());
                costDetailVO.setWbsId(checkDetailEntity.getWbsId());
                costDetailVO.setWbsCode(checkDetailEntity.getWbsCode());
                costDetailVO.setWbsName(checkDetailEntity.getWbsName());
                costDetailVO.setSourceId(checkEntity.getId());
                costDetailVO.setSourceDetailId(checkDetailEntity.getId());
                costDetailVO.setHappenTaxMny(checkDetailEntity.getCheckTaxMny());
                costDetailVO.setHappenMny(checkDetailEntity.getCheckMny());
                costDetailVO.setNum(checkDetailEntity.getCheckNum());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("CONCRETE_CHECK");
                costDetailVO.setSourceTabType("CONCRETE_CHECK_DETAIL");
                costDetailVO.setProjectId(checkEntity.getProjectId());
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6df7\u51dd\u571f\u9a8c\u6536\u5355.getTypeName());
                costDetailVO.setMaterialId(checkDetailEntity.getMaterialId());
                costDetailVO.setMaterialName(checkDetailEntity.getMaterialName());
                costDetailVO.setMaterialCode(checkDetailEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(checkDetailEntity.getMaterialTypeId());
                costDetailVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
                costDetailVO.setUnit(checkDetailEntity.getUnit());
                costDetailVO.setUnitId(checkDetailEntity.getUnitId());
                costDetailVO.setSpec(checkDetailEntity.getSpec());
                String url = null;
                if (checkEntity.getContractId() == null) {
                    url = "/ejc-promaterial-frontend/#/concreteCheck/card?id=" + checkEntity.getId();
                }
                if (checkEntity.getContractId() != null) {
                    url = "/ejc-promaterial-frontend/#/concreteCheck/contractCard?id=" + checkEntity.getId();
                }
                costDetailVO.setSourceBillUrl(url);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ConcreteCheckEntity concreteCheckEntity = (ConcreteCheckEntity)((Object)super.selectById((Serializable)id));
        ConcreteCheckVO concreteCheckVO = (ConcreteCheckVO)BeanMapper.map((Object)((Object)concreteCheckEntity), ConcreteCheckVO.class);
        CommonResponse response = new CommonResponse();
        if (concreteCheckVO.getAttrFlag() != null && concreteCheckVO.getAttrFlag() == 1) {
            ExecutionVO executionVO = this.targetCost(concreteCheckEntity);
            this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
            response = this.executionApi.ctrlCheckVO(executionVO);
        }
        ParamsCheckVO paramsCheckVO = this.checkParams(concreteCheckVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6d88\u8017\u6750-\u5355\u6b21\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u63a7\u5236\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u672c\u6b21\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5355\u6b21\u65e0\u5408\u540c\u6750\u6599\u9a8c\u6536\u91d1\u989d\u8d85\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(checkTaxMny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)checkTaxMny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUB_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6d88\u8017\u6750-\u5355\u4e2a\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMnyAll.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(currentMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u9a8c\u6536\u91d1\u989d\uff1a").append(checkTaxMnyAll.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)checkTaxMnyAll, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ConcreteCheckVO checkVO) {
        CommonResponse response = new CommonResponse();
        if (checkVO.getAttrFlag() != null && checkVO.getAttrFlag() == 1) {
            ConcreteCheckVO vo = this.saveOrUpdates(checkVO, true);
            ExecutionVO executionVO = this.targetCost((ConcreteCheckEntity)((Object)BeanMapper.map((Object)vo, ConcreteCheckEntity.class)));
            this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
            response = this.executionApi.ctrlCheckVO(executionVO);
        }
        ParamsCheckVO paramsCheckVO = this.checkParams(checkVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO checkParams(ConcreteCheckVO vo, ParamsCheckVO paramsCheckVO2) {
        List checkDetailList;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != vo.getContractId()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            paramsCheckVOS.addAll(this.checkParamsNum(contractEntity, vo));
        } else if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        if (vo.getContractId() == null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(checkDetailList = vo.getConcreteCheckDetailList()))) {
            BigDecimal checkTaxMny = checkDetailList.stream().map(ConcreteCheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paramsCheckVOS.addAll(this.checkParamsCheckNum(checkTaxMny, vo.getOrgId()));
        }
        if (vo.getContractId() == null) {
            checkDetailList = vo.getConcreteCheckDetailList();
            BigDecimal currentMny = BigDecimal.ZERO;
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)checkDetailList)) {
                currentMny = checkDetailList.stream().map(ConcreteCheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            LambdaQueryWrapper checkLambda = Wrappers.lambdaQuery();
            checkLambda.eq(ConcreteCheckEntity::getProjectId, (Object)vo.getProjectId());
            checkLambda.isNull(ConcreteCheckEntity::getContractId);
            checkLambda.eq(ConcreteCheckEntity::getSupplierId, (Object)vo.getSupplierId());
            List checkEntityList = super.list((Wrapper)checkLambda);
            BigDecimal checkAll = currentMny;
            if (CollectionUtils.isNotEmpty((Collection)checkEntityList)) {
                List checkIds = checkEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper checkDetailLambda = Wrappers.lambdaQuery();
                checkDetailLambda.in(ConcreteCheckDetailEntity::getCheckId, checkIds);
                List checkDetailEntityList = this.concreteCheckDetailService.list((Wrapper)checkDetailLambda);
                if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                    BigDecimal checkTaxMny = checkDetailEntityList.stream().map(ConcreteCheckDetailEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    checkAll = currentMny.add(checkTaxMny);
                }
            }
            paramsCheckVOS.addAll(this.checkParamsCheckSubNum(currentMny, checkAll, vo.getOrgId()));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        if (this.priceCheckParams(vo) != null) {
            paramsCheckVOS.add(this.priceCheckParams(vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ConcreteCheckVO vo) {
        CommonResponse billParamByCode;
        List list2;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = mny = null == vo.getCheckAllTaxMny() ? BigDecimal.ZERO : vo.getCheckAllTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CheckEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.isNull(CheckEntity::getContractId);
        List list = this.checkService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal totalTaxMny = list.stream().filter(e -> null != e.getCheckAllTaxMny()).map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalTaxMny);
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(ConcreteCheckEntity::getProjectId, (Object)vo.getProjectId());
        wrapper2.isNull(ConcreteCheckEntity::getContractId);
        if (null != vo.getId()) {
            wrapper2.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list2 = super.list((Wrapper)wrapper2)))) {
            BigDecimal totalTaxMny = list2.stream().filter(e -> null != e.getCheckAllTaxMny()).map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalTaxMny);
        }
        CommonResponse response = this.temporaryUseRecordApi.queryProTemporaryUseRecordMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee\uff1a{}-\u4e0b\u6240\u6709\u72b6\u6001\u7684\u3010\u4e34\u65f6\u8bbe\u5907\u4f7f\u7528\u8bb0\u5f55\u91d1\u989d\u3011\u91d1\u989d\u7ed3\u679c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal useMny = ((JSONObject)response.getData()).getBigDecimal("useMny");
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)useMny);
        }
        CommonResponse commonResponse = this.proincomeContrantApi.queryContranctMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee:{}-\u4e0b\u751f\u6548\u7684\u6700\u65b0\u6b63\u5f0f\u65bd\u5de5\u5408\u540c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)commonResponse));
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            BigDecimal bigDecimal = contractTaxMny = null == ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny() ? BigDecimal.ZERO : ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u65e0\u5408\u540c\u9a8c\u6536\u3001\u96f6\u661f\u673a\u68b0\u91d1\u989d\u3011\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u65e0\u5408\u540c\u9a8c\u6536\u3001\u4e34\u673a\u8d39\u7528\u8d85\u65bd\u5de5\u5408\u540c\u989d");
                        paramsCheckDsVO.setWarnName("\u65e0\u5408\u540c\u9a8c\u6536\u3001\u4e34\u673a\u8d39\u7528\u7d2f\u8ba1\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u96f6\u6750\u3001\u96f6\u673a\u53d1\u751f\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO priceCheckParams(ConcreteCheckVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6df7\u51dd\u571f\u9a8c\u6536.getCode());
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getConcreteCheckDetailList())) {
            for (ConcreteCheckDetailVO detailVO : vo.getConcreteCheckDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, ConcreteCheckVO vo) {
        String purchaseType = contractEntity.getPurchaseType();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(purchaseType)) {
            return paramsCheckVOS;
        }
        List<ConcreteCheckDetailVO> detail = ((ConcreteCheckMapper)this.baseMapper).getDetail(contractEntity.getId(), vo.getId());
        Map<Long, ConcreteCheckDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(ConcreteCheckDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        HashMap<Long, BigDecimal> detailTypeMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(detail)) {
            for (ConcreteCheckDetailVO concreteCheckDetailVO : detail) {
                if (map.containsKey(concreteCheckDetailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(concreteCheckDetailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(concreteCheckDetailVO.getMaterialTypeId())) {
                    detailTypeMap.put(concreteCheckDetailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)concreteCheckDetailVO.getCheckNum()));
                    continue;
                }
                detailTypeMap.put(concreteCheckDetailVO.getMaterialTypeId(), concreteCheckDetailVO.getCheckNum());
            }
        }
        HashMap<Long, ConcreteCheckDetailVO> detailMap = new HashMap<Long, ConcreteCheckDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getConcreteCheckDetailList())) {
            for (ConcreteCheckDetailVO detailVO : vo.getConcreteCheckDetailList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                ConcreteCheckDetailVO mapVO = (ConcreteCheckDetailVO)detailMap.get(detailVO.getMaterialId());
                if (Objects.nonNull(mapVO)) {
                    detailVO.setCheckNum(ComputeUtil.safeAdd((BigDecimal)mapVO.getCheckNum(), (BigDecimal)detailVO.getCheckNum()));
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                } else {
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                }
                if (map.containsKey(detailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {
                    detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()));
                    continue;
                }
                detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getCheckNum());
            }
        }
        ArrayList<ParamsCheckDsVO> arrayList = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5165\u5e93\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty(detailMap.values())) {
                        for (ConcreteCheckDetailVO detailVO : detailMap.values()) {
                            ContractDetailEntity detailEntity;
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId()) ? detailSettleMap.get(detailVO.getMaterialId()).getCheckNum() : BigDecimal.ZERO;
                            BigDecimal totalNum = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()).setScale(4, 4);
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId()) ? (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId()) : BigDecimal.ZERO;
                            BigDecimal comNum = BigDecimal.ZERO;
                            if (map.containsKey(detailVO.getMaterialId())) {
                                detailEntity = map.get(detailVO.getMaterialId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            } else {
                                if (!typeMap.containsKey(detailVO.getMaterialTypeId())) continue;
                                detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                totalNum = numType;
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            }
                            if (totalNum.compareTo(comNum) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(detailVO.getCheckNum().setScale(4, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff1a").append(totalNum.setScale(4, 4)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%:").append(comNum.setScale(4, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalNum, (BigDecimal)comNum).setScale(4, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            arrayList.add(paramsCheckDsVO);
                        }
                    }
                    paramsCheckVO.setDataSource(arrayList);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public CheckEntity syncCost(Long id) {
        ConcreteCheckEntity checkEntity = (ConcreteCheckEntity)((Object)super.selectById((Serializable)id));
        ExecutionVO executionVO = this.targetCost(checkEntity);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
        }
        return null;
    }

    @Override
    public ConcreteCheckVO getDetailListData(ConcreteCheckVO checkVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        List checkDetailListPC = checkVO.getConcreteCheckDetailList();
        List materialIds = checkDetailListPC.stream().map(ConcreteCheckDetailVO::getMaterialId).collect(Collectors.toList());
        CommonResponse commonResponse = this.materialApi.queryMaterialItemByIds(materialIds);
        if (commonResponse.isSuccess()) {
            List materialVOList = (List)commonResponse.getData();
            Map materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            for (ConcreteCheckDetailVO checkDetailVO : checkDetailListPC) {
                if (!materialVOMap.containsKey(checkDetailVO.getMaterialId())) continue;
                MaterialVO materialVO = (MaterialVO)materialVOMap.get(checkDetailVO.getMaterialId());
                checkDetailVO.setSubjectId(materialVO.getSubjectId());
                checkDetailVO.setSubjectName(materialVO.getSubjectName());
            }
        }
        return checkVO;
    }

    @Override
    public ConcreteCheckVO queryDetailWeigh(ConcreteCheckVO vo) {
        ConcreteCheckVO ConcreteCheckVO2 = this.concreteDeliveryService.queryDetailToCheck(vo.getDeliveryId());
        this.logger.info("----\u78c5\u5355\u9a8c\u6536\u539f\u6570\u636e \uff1a{}", (Object)JSONObject.toJSONString((Object)ConcreteCheckVO2));
        List concreteCheckDetailList = ConcreteCheckVO2.getConcreteCheckDetailList();
        List concreteCheckWeighList = vo.getConcreteCheckWeighList();
        ArrayList<ConcreteCheckWeighVO> checkWeighVOS = new ArrayList<ConcreteCheckWeighVO>();
        if (CollectionUtils.isNotEmpty((Collection)concreteCheckWeighList)) {
            List collect = concreteCheckWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.weighbillApi.queryWeighbills(ConcreteCheckVO2.getProjectId(), collect);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u78c5\u5355\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + listCommonResponse.getMsg());
            }
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (WeighbillVO weighbillVO : data) {
                    ConcreteCheckWeighVO checkWeighVO = (ConcreteCheckWeighVO)BeanMapper.map((Object)weighbillVO, ConcreteCheckWeighVO.class);
                    BigDecimal netWeight = weighbillVO.getNetWeight();
                    BigDecimal coefficient = weighbillVO.getCoefficient();
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = this.getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<ConcreteCheckWeighVO>> weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(ConcreteCheckWeighVO::getDeliveryDetailId));
                if (CollectionUtils.isNotEmpty((Collection)concreteCheckDetailList)) {
                    for (ConcreteCheckDetailVO checkDetailVO : concreteCheckDetailList) {
                        List<ConcreteCheckWeighVO> checkWeighS = weighMap.get(checkDetailVO.getDeliveryDetailId());
                        if (null != checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)) {
                            BigDecimal checkNum = checkWeighS.stream().map(ConcreteCheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(ConcreteCheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(ConcreteCheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)checkNum));
                            checkDetailVO.setCheckNum(checkNum);
                            continue;
                        }
                        checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                        checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setCheckNum(BigDecimal.ZERO);
                    }
                }
            }
        }
        ConcreteCheckVO2.setCheckWeighType(CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode());
        ConcreteCheckVO2.setConcreteCheckDetailList(concreteCheckDetailList);
        ConcreteCheckVO2.setConcreteCheckWeighList(checkWeighVOS);
        return ConcreteCheckVO2;
    }

    public Map<String, BigDecimal> getCheckNum(String weighUnit, BigDecimal netWeight, BigDecimal coefficient) {
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (null == coefficient) {
            coefficient = BigDecimal.ZERO;
        }
        if (null == netWeight) {
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if (StringUtils.isNotEmpty((CharSequence)weighUnit)) {
            billStateCode = WeighUnitEnum.getEnumByStateCode((String)weighUnit).getBillStateCode();
        }
        switch (billStateCode) {
            case 0: {
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
                break;
            }
            case 1: {
                detailNetWeightCoefficient = ComputeUtil.safeMultiply((BigDecimal)netWeight, (BigDecimal)new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
            }
        }
        map.put("checkNum", checkNum);
        map.put("detailNetWeightCoefficient", detailNetWeightCoefficient);
        return map;
    }
}

