/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanDetailMapper;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="masterPlanDetailService")
public class MasterPlanDetailServiceImpl
extends BaseServiceImpl<MasterPlanDetailMapper, MasterPlanDetailEntity>
implements IMasterPlanDetailService {
    @Autowired
    private MasterPlanDetailMapper masterPlanDetailMapper;
    @Autowired
    private MasterPlanMapper masterPlanMapper;

    @Override
    public void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId) {
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.masterPlanDetailMapper.delByPlanIdAndDetailIds(delDetailIds, planId);
        }
    }

    @Override
    public List<MasterPlanDetailEntity> getByProjectId(Long projectId, Integer planType) {
        QueryWrapper masterPlanQuery = new QueryWrapper();
        masterPlanQuery.eq((Object)"project_id", (Object)projectId);
        masterPlanQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        masterPlanQuery.eq((Object)"plan_type", (Object)planType);
        masterPlanQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanMapper.selectOne((Wrapper)masterPlanQuery));
        if (null == masterPlanEntity) {
            return new ArrayList<MasterPlanDetailEntity>();
        }
        QueryWrapper planDetailQuery = new QueryWrapper();
        planDetailQuery.eq((Object)"material_master_plan_id", (Object)masterPlanEntity.getId());
        planDetailQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return this.masterPlanDetailMapper.selectList((Wrapper)planDetailQuery);
    }
}

