package com.ejianc.business.promaterial.delivery.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckDetailService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliveryVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryDetailVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/delivery/")
public class DeliveryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Autowired
    private IConcreteDeliveryService concreteDeliveryService;
    @Autowired
    private IConcreteDeliveryDetailService concreteDeliveryDetailService;
    /**
     * 根据物资明细id 获取发货单详情
     *
     * @param detailId 明细id
     * @return
     */
    @ApiOperation("根据物资明细id 获取发货单详情")
    @RequestMapping(value = "/queryDeliveryByDetailId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDeliveryByDetailId(@RequestParam("detailId") Long detailId) {
        logger.info("物资明细id，查询参数：{}", detailId);
        DeliveryVO resVo = new DeliveryVO();
        DeliveryDetailEntity deliveryDetailEntity = deliveryDetailService.getById(detailId);
        if(null!=deliveryDetailEntity){
            DeliveryEntity deliveryEntity = deliveryService.getById(deliveryDetailEntity.getDeliveryId());
            resVo = BeanMapper.map(deliveryEntity,DeliveryVO.class);
            DeliveryDetailVO deliveryDetailVO = BeanMapper.map(deliveryDetailEntity,DeliveryDetailVO.class);
            List<DeliveryDetailVO> list = new ArrayList<>();
            list.add(deliveryDetailVO);
            resVo.setDeliveryDetailList(list);
        }
        logger.info("根据物资明细id 获取发货单详情，查询结果：{}", JSONObject.toJSONString(resVo));
        return CommonResponse.success("查询成功",resVo);
    }

    /**
     * 根据物资明细id 获取混凝土发货单详情
     *
     * @param detailId 明细id
     * @return
     */
    @ApiOperation("根据物资明细id 获取混凝土发货单详情")
    @RequestMapping(value = "/queryConcreteDeliveryByDetailId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryConcreteDeliveryByDetailId(@RequestParam("detailId") Long detailId) {
        logger.info("物资明细id，查询参数：{}", detailId);
        DeliveryVO resVo = new DeliveryVO();
        ConcreteDeliveryDetailEntity concreteDeliveryDetailEntity = concreteDeliveryDetailService.getById(detailId);
        if(null!=concreteDeliveryDetailEntity){
            ConcreteDeliveryEntity concreteDeliveryEntity = concreteDeliveryService.getById(concreteDeliveryDetailEntity.getDeliveryId());
            resVo = BeanMapper.map(concreteDeliveryEntity,DeliveryVO.class);
            DeliveryDetailVO deliveryDetailVO = BeanMapper.map(concreteDeliveryDetailEntity,DeliveryDetailVO.class);
            List<DeliveryDetailVO> list = new ArrayList<>();
            list.add(deliveryDetailVO);
            resVo.setDeliveryDetailList(list);
        }
        logger.info("根据物资明细id 获取发货单详情，查询结果：{}", JSONObject.toJSONString(resVo));
        return CommonResponse.success("查询成功", resVo);
    }
}
