package com.ejianc.business.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractRelieveVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.different.bean.DifferentEntity;
import com.ejianc.business.promaterial.different.service.IDifferentService;
import com.ejianc.business.promaterial.different.vo.DifferentDetailVO;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("settlement") 
public class SettlementBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private ISettlementService service;
	@Autowired
	private IReconciliationDetailService reconciliationDetailService;
	@Autowired
	private ICostDetailApi costDetailApi;
	@Autowired
	private IDifferentService differentService;//调差单
	@Autowired
	private IAccountSettleApi accountSettleApi;//结算状态更新api
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/delSettlement";
	@Autowired
	private IContractService contractService;//合同
	private static final String MDBILL_TYPE = "BT220315000000004";//调差消耗
	private static final String CDBILL_TYPE = "BT220316000000004";//调差混凝

	@Value("${common.env.base-host}")
	private String BaseHost;
	@Value("${refer.base-host:null}")
	private String BASE_HOST_FRONTEND;
	@Autowired
	private IExecutionApi executionApi;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IShareMaterialApi shareMaterialApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//结算单  根据 合同状态校验
		SettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			ContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getPerformanceStatus())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		//结算单  根据 合同状态校验
		SettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			ContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getPerformanceStatus())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},合同状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		SettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			ContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getPerformanceStatus())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},合同状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
				.getBillStateCode().equals(state)) {
			logger.info("审批通过业务开始！");
			//结算单
			SettlementEntity entity = service.selectById(billId);
			//推送结算池所用vo
			SettlementVO settlementVO = BeanMapper.map(entity, SettlementVO.class);
			//调差单
			StoreApiVO storeApiVO = new StoreApiVO();
			List<FlowVO> flowVOS = new ArrayList<>();
			//更新生成调差单主表信息
			storeApiVO.setSettleFlag(1);
			storeApiVO.setSettleId(entity.getId());
			storeApiVO.setSettleDate(entity.getSettlementDate());
			storeApiVO.setSettleCode(entity.getBillCode());
			//对账子表主键集合
			List<Long> ids = new ArrayList<>();
			//结算单是否为 大宗材 或者 零星材   proMaterial-1 - 大众   proMaterial-2-周转  proMaterial-3-零星   混凝土不走
			logger.info("该结算单状态---{}",entity.getSettlementType());
			Boolean flag = true;
			if(entity.getSettlementType()==0){//是否消耗材结算
				if(("proMaterial-2".equals(entity.getContractPropertyCode()))){
					flag = false;
				}
			}
			if(CollectionUtils.isNotEmpty(entity.getSettlementDetailList()) && flag){//是否有明细
					logger.info("子表信息处理开始！"+ JSONObject.toJSONString(entity.getSettlementDetailList()));
					for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
						//获取对账子表主键
						if(detail.getReconciliationDetailId()!=null){
							ids.add(detail.getReconciliationDetailId());
						}
						//生成调差单
						BigDecimal storeTaxPrice = detail.getStoreTaxPrice()==null?BigDecimal.ZERO:detail.getStoreTaxPrice();//入库单价
						BigDecimal taxPrice = detail.getTaxPrice()==null?BigDecimal.ZERO:detail.getTaxPrice();//结算单价
						if(storeTaxPrice.compareTo(taxPrice)!=0){//当入库单价！= 结算单价 生成调差单
							FlowVO flowVO = new FlowVO();
							flowVO.setSettleDetailId(detail.getId());
							flowVO.setSourceId(detail.getSourceId());
							flowVO.setSourceDetailId(detail.getSourceDetailId());
							flowVO.setSettlePrice(detail.getPrice());
							flowVO.setSettleTaxPrice(detail.getTaxPrice());
							flowVO.setSettleMny(detail.getMny());
							flowVO.setSettleTaxMny(detail.getTaxMny());
							flowVO.setSettleTax(detail.getTax());
							flowVOS.add(flowVO);
						}
					}
					if(CollectionUtils.isNotEmpty(flowVOS)){
						storeApiVO.setDetail(flowVOS);
						logger.info("生成调差金额和成本金额开始！"+ JSONObject.toJSONString(storeApiVO));
						CommonResponse<StoreApiVO> response = accountSettleApi.settlePass(storeApiVO);
						if(!response.isSuccess()){
							throw new BusinessException("提交生成调差金额和成本金额失败！失败原因："+response.getMsg());
						}else {
							StoreApiVO data = response.getData();
							logger.info("提交生成调差金额和成本金额成功！"+ JSONObject.toJSONString(data));
							DifferentVO differentVO = this.getDifferent(entity, data);
							CommonResponse<DifferentVO> differentVOCommonResponse = differentService.saveOrUpdate(differentVO);
							if(!differentVOCommonResponse.isSuccess()){
								throw new BusinessException("生成调差单失败！");
							}
							logger.info("生成调差单成功！"+ JSONObject.toJSONString(differentVOCommonResponse.getData()));
							logger.info("生成调差单子表成功！"+ JSONObject.toJSONString(differentVOCommonResponse.getData().getDifferentDetailList()));
						}
					}
				}
			//修改合同状态  结算类型，0-过程,1-最终
			if(entity.getContractId()!=null && entity.getSignatureType()==1){
				ContractEntity contractEntity = contractService.selectById(entity.getContractId());
				contractEntity.setPerformanceStatus(PerformanceStatusEnum.已封账.getCode());
				contractService.saveOrUpdate(contractEntity);
				logger.info("修改合同状态！"+JSONObject.toJSONString(contractEntity));
			}
			//推送合同池 type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
			service.updateContractPoolSettle(settlementVO, true);
			//推送结算池
			boolean pool = service.pushSettleToPool(settlementVO);
			if(!pool){
				throw new BusinessException("推送结算池失败");
			}

			// 最终结算推送目标成本
			if (entity.getSignatureType()!=null && entity.getSignatureType()==1 && entity.getContractId()!=null) {
				String linkUrl;
				String frontendBaseHost="";
				if(org.apache.commons.lang3.StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
					frontendBaseHost = BASE_HOST_FRONTEND;
				}else{
					frontendBaseHost = BaseHost;
				}
				if (entity.getSettlementType() == 0) {
					if (null == entity.getContractId() || 0==entity.getContractId()){
						linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId();
					}else {
						linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId();
					}
				}
				else {
					if (null == entity.getContractId() || 0==entity.getContractId()){
						linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId();
					}else {
						linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId();
					}
				}
				ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, SettlementVO.class),linkUrl,entity.getSettlementType());
				logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
				CommonResponse<String> response = executionApi.aggPush(executionVO);
				if (!response.isSuccess()) {
					throw new BusinessException("目标成本推送失败," + response.getMsg());
				}
			}
			//推送供方  推送供方放到最后
			Boolean pushFlag = service.pushBillToSupCenter(entity,billTypeCode);
			logger.info("获取推送供方结果--"+pushFlag);
			if(!pushFlag){
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}else{
				entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
			service.updateById(entity);
			//推送成本归集
			service.costPush(entity);
			return CommonResponse.success("审批通过逻辑操作完成");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 查询调差单  billTypeCode：调差单单据编号  billId：调差单id
		//结算单
		CommonResponse<String> res2 = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res2.isSuccess()+"----"+res2.getMsg());
		if(!res2.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		SettlementEntity entity = service.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}
		if(entity.getContractId()!=null){
			LambdaQueryWrapper<SettlementEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(SettlementEntity::getContractId, entity.getContractId());
			lambda.eq(SettlementEntity::getSettlementType, entity.getSettlementType());
			lambda.orderByDesc(SettlementEntity::getCreateTime);
			List<SettlementEntity> list = service.list(lambda);
			SettlementEntity settlementEntity = list.get(0);
			if(!entity.getId().equals(settlementEntity.getId())){
				throw new BusinessException("只能撤回最新的结算单！");
			}
		}
		LambdaQueryWrapper<DifferentEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(DifferentEntity::getSettlementId, billId);
		wrapper.eq(DifferentEntity::getDr, 0);
		List<DifferentEntity> list = differentService.list(wrapper);
		if(CollectionUtils.isNotEmpty(list)){
			DifferentEntity different = list.get(0);
			logger.info("该结算单状态---{}",entity.getSettlementType());
			String BILL_TYPE = "";
			if(entity.getSettlementType()==1){
				BILL_TYPE = CDBILL_TYPE;
			}else {
				BILL_TYPE = MDBILL_TYPE;
			}
			CommonResponse<String> res = billTypeApi.checkQuote(BILL_TYPE, different.getId());
			if (!res.isSuccess() || "1".equals(different.getProportionFlag())){
				throw new BusinessException("调差单被引用不能撤回！");
			}
		}
		// 删除目标成本 最终结算
		if(entity.getSignatureType()!=null && entity.getSignatureType()==1 && entity.getContractId()!=null){
			List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
			ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, SettlementVO.class),"",entity.getSettlementType());
			totalExecutionVOList.add(executionVO.getTotalVO());
			CommonResponse<String> response1 = executionApi.aggDel(totalExecutionVOList);
			if (!response1.isSuccess()){
				throw new BusinessException(response1.getMsg());
			}
		}
		logger.info("入库弃审校验---");
		StoreApiVO storeApiVO = new StoreApiVO();
		storeApiVO.setSettleId(billId);
		CommonResponse<StoreApiVO> response = accountSettleApi.settleRollback(storeApiVO);
		if(!response.isSuccess()){
			throw new BusinessException(response.getMsg());
		}else {
			logger.info("弃审校验成功！"+ JSONObject.toJSONString(response.getData()));
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		SettlementEntity entity = service.selectById(billId);
		//修改合同状态  结算类型，0-过程,1-最终
		if(entity.getContractId()!=null && entity.getSignatureType()==1){
			ContractEntity contractEntity = contractService.selectById(entity.getContractId());
			contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			contractService.saveOrUpdate(contractEntity);
			logger.info("修改合同状态！"+JSONObject.toJSONString(contractEntity));
		}
		//推送合同池  type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
		service.updateContractPoolSettle(BeanMapper.map(entity,SettlementVO.class), false);
		logger.info("删除调差单---");
		LambdaQueryWrapper<DifferentEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(DifferentEntity::getSettlementId, billId);
		differentService.remove(wrapper, false);
		//TODO 暂时注释 逻辑可能需要根据有无合同分别处理
		//结算池撤回
		boolean pool = service.delSettleFromPool(billId);
		if(!pool){
			throw new BusinessException("弃审推送结算池失败！");
		}
		//供方撤回
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
			logger.info("供方撤回---");
			logger.info("该结算单状态---{}",entity.getSettlementType());
			CommonResponse<String> response = service.updatePushBill(entity, billTypeCode, DEL_BILL_SERVER_URL);
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			service.updateById(entity);
			logger.info("供方撤回成功---"+JSONObject.toJSONString(entity));
		}
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-结算Id---{}",entity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(entity.getId(),0);
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<SettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(SettlementEntity::getId, entity.getId());
		updateWrapper.set(SettlementEntity::getRelationFlag, "0");//(1:是，0：否)
		service.update(updateWrapper);
		return CommonResponse.success();
	}
	/*生成调差单vo*/
	private DifferentVO getDifferent(SettlementEntity settlement,StoreApiVO storeApiVO){
		//生成调差单子表
		ArrayList<DifferentDetailVO> detailVOS = new ArrayList<>();
		//调差单主表
		DifferentVO differentVO = BeanMapper.map(settlement, DifferentVO.class);
		//汇总金额
		BigDecimal costMny = BigDecimal.ZERO;//成本金额(无税)
		BigDecimal costTaxMny= BigDecimal.ZERO;//成本金额
		BigDecimal costTax= BigDecimal.ZERO;//成本税额
		BigDecimal diffMny= BigDecimal.ZERO;//调差金额(无税)
		BigDecimal diffTaxMny= BigDecimal.ZERO;//调差金额
		BigDecimal diffTax= BigDecimal.ZERO;//调差税额
		StringBuffer materialTypeName = new StringBuffer();
		//成本子表map
		if(CollectionUtils.isNotEmpty(storeApiVO.getDetail())){
			Map<Long, FlowVO> flowVOMap = storeApiVO.getDetail().stream().filter(t -> t.getSettleDetailId() != null).collect(Collectors.toMap(FlowVO::getSettleDetailId, item -> item, (v1, v2) -> v2));
			if(CollectionUtils.isNotEmpty(settlement.getSettlementDetailList())){
				for (SettlementDetailEntity detail : settlement.getSettlementDetailList()) {
					if(flowVOMap.containsKey(detail.getId())){
						//分类名称汇总
						if(materialTypeName.length()>0){
							materialTypeName.append("、").append(detail.getMaterialTypeName());
						}else {
							materialTypeName.append(detail.getMaterialTypeName());
						}
						//子表数据处理
						FlowVO flowVO = flowVOMap.get(detail.getId());
						DifferentDetailVO differentDetailVO = BeanMapper.map(detail, DifferentDetailVO.class);
						differentDetailVO.setId(null);
						differentDetailVO.setRowState("add");
						BigDecimal costMny1 = flowVO.getCostMny()==null?BigDecimal.ZERO:flowVO.getCostMny();
						BigDecimal costTaxMny1 = flowVO.getCostTaxMny()==null?BigDecimal.ZERO:flowVO.getCostTaxMny();
						BigDecimal costTax1 = flowVO.getCostTax()==null?BigDecimal.ZERO:flowVO.getCostTax();
						BigDecimal diffMny1 = flowVO.getDiffMny()==null?BigDecimal.ZERO:flowVO.getDiffMny();
						BigDecimal diffTaxMny1 = flowVO.getDiffTaxMny()==null?BigDecimal.ZERO:flowVO.getDiffTaxMny();
						BigDecimal diffTax1 = flowVO.getDiffTax()==null?BigDecimal.ZERO:flowVO.getDiffTax();
						//设置子表金额
						differentDetailVO.setDetailDiffMny(diffMny1);
						differentDetailVO.setDetailDiffTax(diffTax1);
						differentDetailVO.setDetailDiffTaxMny(diffTaxMny1);
						differentDetailVO.setDetailCostMny(costMny1);
						differentDetailVO.setDetailCostTaxMny(costTaxMny1);
						//设置主表汇总金额
						costMny = costMny.add(costMny1);
						costTaxMny = costTaxMny.add(costTaxMny1);
						costTax = costTax.add(costTax1);
						diffMny = diffMny.add(diffMny1);
						diffTaxMny = diffTaxMny.add(diffTaxMny1);
						diffTax = diffTax.add(diffTax1);
						//添加到调差单子表集合
						detailVOS.add(differentDetailVO);
					}
				}
			}
		}
		//调差单主表信息设置
		differentVO.setDifferentDetailList(detailVOS);
		differentVO.setId(null);
		differentVO.setBillCode(null);
		differentVO.setDifferentDate(new Date());
		differentVO.setDiffMny(diffMny);
		differentVO.setDiffTaxMny(diffTaxMny);
		differentVO.setDiffTax(diffTax);
		differentVO.setCostMny(costMny);
		differentVO.setCostTaxMny(costTaxMny);
		differentVO.setSettlementId(settlement.getId());
		differentVO.setSettlementCode(settlement.getBillCode());
		differentVO.setMaterialTypeName(materialTypeName.toString());
		differentVO.setProportionFlag("0");
		differentVO.setRelationFlag("0");
		logger.info("结算单实体----"+JSONObject.toJSONString(settlement));
		logger.info("调差单vo---"+JSONObject.toJSONString(differentVO));
		//获取成本科目字段
		List<DifferentDetailVO> differentDetailList = differentVO.getDifferentDetailList();
//		Map<Long, DifferentDetailVO> detailVOMap = differentDetailList.stream().collect(Collectors.toMap(DifferentDetailVO::getMaterialId, DifferentDetailVO -> DifferentDetailVO));
		List<Long> idList = differentDetailList.stream().map(DifferentDetailVO::getMaterialId).collect(Collectors.toList());
		logger.info("成本科目推送数据"+JSONObject.toJSONString(idList));
		CommonResponse<List<MaterialVO>> response = shareMaterialApi.queryMaterialItemByIds(idList);
		if (!response.isSuccess()){
			throw new BusinessException("成本科目查询失败");
		}
		List<MaterialVO> data = response.getData();
		for (DifferentDetailVO detailVO : differentDetailList) {
			for (MaterialVO vo : data) {
				if(Objects.equals(detailVO.getMaterialId(), vo.getId())){
					//				DifferentDetailVO detailVO = detailVOMap.get(vo.getId());
					detailVO.setSubjectId(null==vo.getSubjectId()?null:vo.getSubjectId());
					detailVO.setSubjectName(null==vo.getSubjectName()?null:vo.getSubjectName());
//			detailVO.setSubjectCode();
				}
			}
		}

//		differentVO.getDifferentDetailList().clear();
//		differentVO.setDifferentDetailList(new ArrayList<DifferentDetailVO>(detailVOMap.values()));
		return differentVO;
	}
}
