package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 签章流程
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractSignature")
public class SignatureController implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    private IContractService contractService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/changeStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeStatus(@RequestBody String objectStr) {
        if (objectStr == null || StringUtils.isBlank(objectStr)) {
            return CommonResponse.error("签章流程返回对象为空，请检查！");
        }
        logger.info("进入修改签章流程方法------------->");
        JSONObject object = (JSONObject) JSONObject.parse(objectStr);
        Long billId = Long.valueOf(object.getString("billId"));
        int status = Integer.parseInt(object.getString("status"));
        String refCode = object.getString("refCode");
        Boolean isSuc = contractService.changeSignStatus(billId, status, refCode);
        if(!isSuc) {
            return CommonResponse.error("失败！");
        }
        return CommonResponse.success("更新单据签章状态成功！");
    }
}
