package com.ejianc.business.promaterial.check.service;

import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;

/**
 * 混凝土-验收主表
 * 
 * @author generator
 * 
 */
public interface IConcreteCheckService extends IBaseService<ConcreteCheckEntity> {

    ConcreteCheckVO saveOrUpdates(ConcreteCheckVO saveOrUpdateVO, Boolean isControl);

    void deletes(List<ConcreteCheckVO> vos);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    CommonResponse<ConcreteCheckVO> pushCost(ConcreteCheckVO checkVO);

    void costPush(ConcreteCheckEntity checkEntity);

    ConcreteCheckVO getConcreteDetailListData(ConcreteCheckVO checkVO);

    ConcreteCheckVO queryDetail(Long id);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    /*
     * 材料验收、混凝土验收—无合同验收-单次无合同验收金额控制*/
    List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId);

    /*
     * 材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
     */
    List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId);

    ParamsCheckVO targetCostCtrl(ConcreteCheckVO checkVO);

    ParamsCheckVO checkParams(ConcreteCheckVO vo,ParamsCheckVO paramsCheckVO2);
    /**
     * 单据管控-累计入库数量大于合同数量
     * @return
     */
    List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, ConcreteCheckVO vo);

    CheckEntity syncCost(Long id);

    ConcreteCheckVO getDetailListData(ConcreteCheckVO checkVO);

    /*历史价 控 明细价
     *        @param

     * */
    ParamsCheckVO priceCheckParams(ConcreteCheckVO vo);

    ConcreteCheckVO queryDetailWeigh(ConcreteCheckVO vo);
    /*
     * 【施工合同金额】控【无合同验收、零星机械金额】*/
    List<ParamsCheckVO> checkParamsConstruction(ConcreteCheckVO vo);
}
