package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.vo.SinglePlanDetailVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.SinglePlanDetailMapper;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 单项采购计划子表
 * 
 * @author generator
 * 
 */
@Service("singlePlanDetailService")
public class SinglePlanDetailServiceImpl extends BaseServiceImpl<SinglePlanDetailMapper, SinglePlanDetailEntity> implements ISinglePlanDetailService{

    @Override
    public List<SinglePlanDetailVO> geMaterialDetail(Page<SinglePlanDetailVO> page, QueryWrapper queryWrapper) {
        List<SinglePlanDetailVO> list = baseMapper.geMaterialDetail(page,queryWrapper);
        return list;
    }

    @Override
    public List<OrderDetailVO> queryMaterialDetail(Long projectId, Long materialId) {
        List<OrderDetailVO> orderDetailVOS = baseMapper.queryMaterialDetail(projectId, materialId);
        return orderDetailVOS;
    }

    @Override
    public BigDecimal getSurplusNumsSum(Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = baseMapper.getSurplusNumsSum(projectId, materialId);
        return surplusNumsSum;
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId) {
        return baseMapper.countDetailTotalNum(planId, detailIds, projectId);
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNumByMonth(Long planId, List<Long> detailIds, Long projectId) {
        return baseMapper.countDetailTotalNumByMonth(planId, detailIds, projectId);
    }
}
