package com.ejianc.business.promaterial.plan.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 材料批次采购计划字表（采购清单）
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_bat_plan_detail")
public class BatPlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="plan_id")
    private Long planId; // 采购计划主键ID
    @TableField(value="material_id")
    private Long materialId; // 材料ID
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="material_code")
    private String materialCode; // 材料编码
    @TableField(value="material_type_id")
    private Long materialTypeId; // 材料分类ID
    @TableField(value="material_type_name")
    private String materialTypeName; // 材料分类名称
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="brand")
    private String brand; // 品牌
    @TableField(value="calculate_type")
    private Integer calculateType; // 计量方式(0-理计,1-过磅,2-点数)
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="money")
    private BigDecimal money; // 暂估金额
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="unit_id")
    private Long unitId; // 计量单位
    @TableField(value="source_id")
    private String sourceId; // 来源数据Id
    @TableField(value="source_type")
    private String sourceType; // 来源数据类型（1材料档案；2材料大类；3总计划；4月计划）
    @TableField(value="detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率

    @TableField(value="texture")
    private String texture; // 材质
    @TableField(value="standard")
    private String standard; // 技术标准
    @TableField(value="month_plan_code")
    private String monthPlanCode; // 需用计划编号
    @TableField(value="order_expiry_date")
    private Date orderExpiryDate; // 到货日期
    @TableField(value="buyer_id")
    private Long buyerId; // 采购员
    @TableField(value="buyer_name")
    private String buyerName; // 采购员名称
    @TableField(value="construction")
    private String construction; // 使用部位

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 采购计划主键ID
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 采购计划主键ID
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 暂估金额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 暂估金额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public String getMonthPlanCode() {
        return monthPlanCode;
    }

    public void setMonthPlanCode(String monthPlanCode) {
        this.monthPlanCode = monthPlanCode;
    }

    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
}
