package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.plan.bean.ConcretePlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.ConcretePlanEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.ConcretePlanMapper;
import com.ejianc.business.promaterial.plan.service.IConcretePlanDetailService;
import com.ejianc.business.promaterial.plan.service.IConcretePlanService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.ConcretePlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.ConcretePlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.ConcretePlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailRefVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 混凝土需用计划-主表
 *
 * @author generator
 *
 */
@Service("concretePlanService")
public class ConcretePlanServiceImpl extends BaseServiceImpl<ConcretePlanMapper, ConcretePlanEntity> implements IConcretePlanService{
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "CONCRETE_PLAN01";
    //参数控制编码
    private static final String CHECK_MASTER_NUM_CODE = "P-6xQfrO0218";//【混凝土总计划量】控制【混凝土需用计划量】
    private static final String CHECK_MASTER_PRICE_CODE = "P-3215Nu0219";//【混凝土总计划单价】控制【混凝土需用计划单价】
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IConcretePlanDetailService concretePlanDetailService;
    @Autowired
    private IParamConfigApi paramConfigApi;


    @Override
    public CommonResponse<ConcretePlanVO> saveOrUpdate(ConcretePlanVO saveOrUpdateVO) {
        ConcretePlanEntity entity = BeanMapper.map(saveOrUpdateVO, ConcretePlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<ConcretePlanDetailEntity> planDetailList = entity.getPlanDetailList();
        String materialName = "";
        if(CollectionUtils.isNotEmpty(planDetailList)){
            ArrayList<ConcretePlanDetailEntity> list = new ArrayList<>();
            for(ConcretePlanDetailEntity planDetail :planDetailList ){
                //物资名称集合
                if(!("del".equals(planDetail.getRowState()))){//删除的物资不拼接名称
                    if(StringUtils.isNotBlank(planDetail.getMaterialName())){
                        if(StringUtils.isNotBlank(materialName)){
                            materialName = materialName+","+planDetail.getMaterialName();
                        }else {
                            materialName = planDetail.getMaterialName();
                        }
                    }
                    list.add(planDetail);
                }
                BigDecimal nums = planDetail.getNums() == null ? BigDecimal.ZERO : planDetail.getNums();
                BigDecimal occupyNums = planDetail.getOccupyNums() == null ? BigDecimal.ZERO : planDetail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                planDetail.setSurplusNums(surplusNums);//剩余
                planDetail.setOccupyNums(occupyNums);//占用
                planDetail.setNums(nums);//需用
            }
            Integer planFlag = entity.getPlanFlag()==null?1:entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("最少有一条计划明细！");
            }
        }else{
            throw new BusinessException("最少有一条计划明细！");
        }
        super.saveOrUpdate(entity, false);
        ConcretePlanVO vo = BeanMapper.map(entity, ConcretePlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<ConcretePlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper wrapper) {
        List<ConcretePlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId, wrapper);
        return planVOList;
    }

    @Override
    public ParamsCheckVO checkParams(ConcretePlanVO concretePlanVO, ParamsCheckVO paramsCheckVO2) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*---预警参数添加start*/
        paramsCheckVOS.addAll(this.checkParamsByMasterNum(concretePlanVO));//【混凝土总计划量】控制【混凝土需用计划量】
        paramsCheckVOS.addAll(this.checkParamsByMasterPrice(concretePlanVO));//【混凝土总计划单价】控制【混凝土需用计划单价】
        /*---预警参数添加end*/

        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    //【混凝土总计划量】控制【混凝土需用计划量】
    @Override
    public  List<ParamsCheckVO> checkParamsByMasterNum(ConcretePlanVO concretePlanVO){
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        //  查询 “混凝土总计划量” 根据 “materialId” 封装进map
        MasterPlanEntity masterPlanEntity = masterPlanService.getOne(new QueryWrapper<MasterPlanEntity>().eq("project_id", concretePlanVO.getProjectId()).eq("plan_type", 1));
        List<MasterPlanDetailEntity> masterPlanDetailEntities = masterPlanDetailService.list(new QueryWrapper<MasterPlanDetailEntity>().eq("material_master_plan_id", masterPlanEntity.getId()));
        Map<Long, BigDecimal> masterMap = masterPlanDetailEntities.stream().collect(Collectors.groupingBy(MasterPlanDetailEntity::getMaterialId,
                Collectors.collectingAndThen(Collectors.toList(),m->m.stream().map(a->a.getNum()).reduce(BigDecimal.ZERO,BigDecimal::add))));

        // 查询"含本次累计需用计划量"
        BigDecimal totalNums;
        List<ConcretePlanEntity> concretePlanEntities = super.list(new QueryWrapper<ConcretePlanEntity>().eq("project_id", concretePlanVO.getProjectId()).ne(concretePlanVO.getId()!=null,"id",concretePlanVO.getId()));
        if (CollectionUtils.isNotEmpty(concretePlanEntities)) {
            List<Long> ids = concretePlanEntities.stream().map(ConcretePlanEntity::getId).collect(Collectors.toList());
            List<ConcretePlanDetailEntity> concretePlanDetailEntities = concretePlanDetailService.list(new QueryWrapper<ConcretePlanDetailEntity>().in("plan_id", ids));
            totalNums = concretePlanDetailEntities.stream().map(it -> it.getNums()).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            totalNums = BigDecimal.ZERO;
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MASTER_NUM_CODE, concretePlanVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()){
            List<BillParamVO> data = billParamByCode.getData();
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data){
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    for (ConcretePlanDetailVO detailVO : concretePlanVO.getPlanDetailList()) {
                        if (masterMap.containsKey(detailVO.getMaterialId()) && detailVO.getNums() != null) {
                            if (detailVO.getNums().compareTo(masterMap.get(detailVO.getMaterialId())) == 1) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem("混凝土需用计划量超过总计划量");
                                paramsCheckDsVO.setWarnName("混凝土需用计划量超过总计划量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次需用计划量：").append(detailVO.getNums().setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计需用计划量：").append(ComputeUtil.safeAdd(totalNums, detailVO.getNums()).setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划量*").append(roleValue).append("%:").append(masterMap.get(detailVO.getMaterialId()).setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(detailVO.getNums(), masterMap.get(detailVO.getMaterialId())).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            paramsCheckVO.setDataSource(checkDsVOS);
                            paramsCheckVOList.add(paramsCheckVO);
                        }
                    }
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    //【混凝土总计划单价】控制【混凝土需用计划单价】
    @Override
    public  List<ParamsCheckVO> checkParamsByMasterPrice(ConcretePlanVO concretePlanVO){
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        //  查询 “混凝土总计划单价” 根据 “materialId” 封装进map
        MasterPlanEntity masterPlanEntity = masterPlanService.getOne(new QueryWrapper<MasterPlanEntity>().eq("project_id", concretePlanVO.getProjectId()).eq("plan_type", 1));
        List<MasterPlanDetailEntity> masterPlanDetailEntities = masterPlanDetailService.list(new QueryWrapper<MasterPlanDetailEntity>().eq("material_master_plan_id", masterPlanEntity.getId()));
        Map<Long, BigDecimal> masterMap = masterPlanDetailEntities.stream().collect(Collectors.groupingBy(MasterPlanDetailEntity::getMaterialId,
                Collectors.collectingAndThen(Collectors.toList(),m->m.stream().map(a->a.getPrice()).reduce(BigDecimal.ZERO,BigDecimal::add))));

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MASTER_PRICE_CODE, concretePlanVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()){
            List<BillParamVO> data = billParamByCode.getData();
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data){
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    for (ConcretePlanDetailVO detailVO : concretePlanVO.getPlanDetailList()) {
                        if (masterMap.containsKey(detailVO.getMaterialId()) && detailVO.getPrice() != null) {
                            if (detailVO.getPrice().compareTo(masterMap.get(detailVO.getMaterialId())) == 1) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem("消耗需用计划单价超过总计划单价");
                                paramsCheckDsVO.setWarnName("混凝土需用计划单价超过总计划单价");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次需用计划单价：").append(detailVO.getPrice().setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，总计划单价*").append(roleValue).append("%:").append(masterMap.get(detailVO.getMaterialId()).setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出：").append(ComputeUtil.safeSub(detailVO.getPrice(), masterMap.get(detailVO.getMaterialId())).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            paramsCheckVO.setDataSource(checkDsVOS);
                            paramsCheckVOList.add(paramsCheckVO);
                        }
                    }
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
}
